/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.util;

import java.io.Serializable;
import org.apache.spark.sql.pipelines.util.BackoffStrategy;
import org.apache.spark.sql.pipelines.util.ExponentialBackoffStrategy$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001\u0002\u000e\u001c\u0001\"B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\t\"AQ\n\u0001BK\u0002\u0013\u00051\t\u0003\u0005O\u0001\tE\t\u0015!\u0003E\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u001dY\u0006!!A\u0005\u0002qCqa\u0018\u0001\u0012\u0002\u0013\u0005\u0001\rC\u0004l\u0001E\u0005I\u0011\u00011\t\u000f1\u0004\u0011\u0011!C![\"9a\u000fAA\u0001\n\u00039\bb\u0002=\u0001\u0003\u0003%\t!\u001f\u0005\t\u007f\u0002\t\t\u0011\"\u0011\u0002\u0002!I\u0011q\u0002\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0003\u0005\n\u00037\u0001\u0011\u0011!C!\u0003;A\u0011\"!\t\u0001\u0003\u0003%\t%a\t\t\u0013\u0005\u0015\u0002!!A\u0005B\u0005\u001d\u0002\"CA\u0015\u0001\u0005\u0005I\u0011IA\u0016\u000f%\tycGA\u0001\u0012\u0003\t\tD\u0002\u0005\u001b7\u0005\u0005\t\u0012AA\u001a\u0011\u0019yE\u0003\"\u0001\u0002L!I\u0011Q\u0005\u000b\u0002\u0002\u0013\u0015\u0013q\u0005\u0005\n\u0003\u001b\"\u0012\u0011!CA\u0003\u001fB\u0011\"!\u0016\u0015\u0003\u0003%\t)a\u0016\t\u0013\u0005%D#!A\u0005\n\u0005-$AG#ya>tWM\u001c;jC2\u0014\u0015mY6pM\u001a\u001cFO]1uK\u001eL(B\u0001\u000f\u001e\u0003\u0011)H/\u001b7\u000b\u0005yy\u0012!\u00039ja\u0016d\u0017N\\3t\u0015\t\u0001\u0013%A\u0002tc2T!AI\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0011fL\u001a7!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011\u0001'M\u0007\u00027%\u0011!g\u0007\u0002\u0010\u0005\u0006\u001c7n\u001c4g'R\u0014\u0018\r^3hsB\u0011!\u0006N\u0005\u0003k-\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00028\u007f9\u0011\u0001(\u0010\b\u0003sqj\u0011A\u000f\u0006\u0003w\u001d\na\u0001\u0010:p_Rt\u0014\"\u0001\u0017\n\u0005yZ\u0013a\u00029bG.\fw-Z\u0005\u0003\u0001\u0006\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!AP\u0016\u0002\u000f5\f\u0007\u0010V5nKV\tA\t\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006AA-\u001e:bi&|gN\u0003\u0002JW\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005-3%A\u0004$j]&$X\rR;sCRLwN\\\u0001\t[\u0006DH+[7fA\u0005A1\u000f^3q'&TX-A\u0005ti\u0016\u00048+\u001b>fA\u00051A(\u001b8jiz\"2!\u0015*T!\t\u0001\u0004\u0001C\u0003C\u000b\u0001\u0007A\tC\u0003N\u000b\u0001\u0007A)\u0001\u0007xC&$H)\u001e:bi&|g\u000e\u0006\u0002E-\")qK\u0002a\u00011\u0006Ya.^7GC&dWO]3t!\tQ\u0013,\u0003\u0002[W\t\u0019\u0011J\u001c;\u0002\t\r|\u0007/\u001f\u000b\u0004#vs\u0006b\u0002\"\b!\u0003\u0005\r\u0001\u0012\u0005\b\u001b\u001e\u0001\n\u00111\u0001E\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u0019\u0016\u0003\t\n\\\u0013a\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005!\\\u0013AC1o]>$\u0018\r^5p]&\u0011!.\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u00039\u0004\"a\u001c;\u000e\u0003AT!!\u001d:\u0002\t1\fgn\u001a\u0006\u0002g\u0006!!.\u0019<b\u0013\t)\bO\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u00021\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HC\u0001>~!\tQ30\u0003\u0002}W\t\u0019\u0011I\\=\t\u000fyd\u0011\u0011!a\u00011\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0001\u0011\u000b\u0005\u0015\u00111\u0002>\u000e\u0005\u0005\u001d!bAA\u0005W\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0011q\u0001\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0014\u0005e\u0001c\u0001\u0016\u0002\u0016%\u0019\u0011qC\u0016\u0003\u000f\t{w\u000e\\3b]\"9aPDA\u0001\u0002\u0004Q\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$2A\\A\u0010\u0011\u001dqx\"!AA\u0002a\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u00021\u0006AAo\\*ue&tw\rF\u0001o\u0003\u0019)\u0017/^1mgR!\u00111CA\u0017\u0011\u001dq(#!AA\u0002i\f!$\u0012=q_:,g\u000e^5bY\n\u000b7m[8gMN#(/\u0019;fOf\u0004\"\u0001\r\u000b\u0014\u000bQ\t)$!\u0011\u0011\u000f\u0005]\u0012Q\b#E#6\u0011\u0011\u0011\b\u0006\u0004\u0003wY\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003\u007f\tIDA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f\u0012\u0018AA5p\u0013\r\u0001\u0015Q\t\u000b\u0003\u0003c\tQ!\u00199qYf$R!UA)\u0003'BQAQ\fA\u0002\u0011CQ!T\fA\u0002\u0011\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002Z\u0005\u0015\u0004#\u0002\u0016\u0002\\\u0005}\u0013bAA/W\t1q\n\u001d;j_:\u0004RAKA1\t\u0012K1!a\u0019,\u0005\u0019!V\u000f\u001d7fe!A\u0011q\r\r\u0002\u0002\u0003\u0007\u0011+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!\u001c\u0011\u0007=\fy'C\u0002\u0002rA\u0014aa\u00142kK\u000e$\b")
public class ExponentialBackoffStrategy
implements BackoffStrategy,
Product,
Serializable {
    private final FiniteDuration maxTime;
    private final FiniteDuration stepSize;

    public static Option<Tuple2<FiniteDuration, FiniteDuration>> unapply(ExponentialBackoffStrategy x$0) {
        return ExponentialBackoffStrategy$.MODULE$.unapply(x$0);
    }

    public static ExponentialBackoffStrategy apply(FiniteDuration maxTime, FiniteDuration stepSize) {
        return ExponentialBackoffStrategy$.MODULE$.apply(maxTime, stepSize);
    }

    public static Function1<Tuple2<FiniteDuration, FiniteDuration>, ExponentialBackoffStrategy> tupled() {
        return ExponentialBackoffStrategy$.MODULE$.tupled();
    }

    public static Function1<FiniteDuration, Function1<FiniteDuration, ExponentialBackoffStrategy>> curried() {
        return ExponentialBackoffStrategy$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public FiniteDuration maxTime() {
        return this.maxTime;
    }

    public FiniteDuration stepSize() {
        return this.stepSize;
    }

    @Override
    public FiniteDuration waitDuration(int numFailures) {
        boolean willExceedMax;
        Predef$.MODULE$.require(numFailures >= 0, (Function0 & Serializable)() -> "Number of failures must be non-negative. Given value: " + numFailures + ".");
        if (this.stepSize().$less$eq((Object)new package.DurationInt(package$.MODULE$.DurationInt(0)).seconds())) {
            return new package.DurationInt(package$.MODULE$.DurationInt(0)).seconds();
        }
        if (this.stepSize().$greater$eq((Object)this.maxTime())) {
            return this.maxTime();
        }
        boolean bl = willExceedMax = (double)numFailures >= ExponentialBackoffStrategy.log2$1((double)this.maxTime().toNanos() / (double)this.stepSize().toNanos()) + 1.0;
        if (!willExceedMax) {
            return package.LongMult$.MODULE$.$times$extension(package$.MODULE$.LongMult((long)scala.math.package$.MODULE$.pow(2.0, (double)(numFailures - 1))), this.stepSize());
        }
        return this.maxTime();
    }

    public ExponentialBackoffStrategy copy(FiniteDuration maxTime, FiniteDuration stepSize) {
        return new ExponentialBackoffStrategy(maxTime, stepSize);
    }

    public FiniteDuration copy$default$1() {
        return this.maxTime();
    }

    public FiniteDuration copy$default$2() {
        return this.stepSize();
    }

    public String productPrefix() {
        return "ExponentialBackoffStrategy";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.maxTime();
            }
            case 1: {
                return this.stepSize();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ExponentialBackoffStrategy;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "maxTime";
            }
            case 1: {
                return "stepSize";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -1417095083, true);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ExponentialBackoffStrategy)) return false;
        boolean bl = true;
        if (!bl) return false;
        ExponentialBackoffStrategy exponentialBackoffStrategy = (ExponentialBackoffStrategy)x$1;
        FiniteDuration finiteDuration = this.maxTime();
        FiniteDuration finiteDuration2 = exponentialBackoffStrategy.maxTime();
        if (finiteDuration == null) {
            if (finiteDuration2 != null) {
                return false;
            }
        } else if (!finiteDuration.equals(finiteDuration2)) return false;
        FiniteDuration finiteDuration3 = this.stepSize();
        FiniteDuration finiteDuration4 = exponentialBackoffStrategy.stepSize();
        if (finiteDuration3 == null) {
            if (finiteDuration4 != null) {
                return false;
            }
        } else if (!finiteDuration3.equals(finiteDuration4)) return false;
        if (!exponentialBackoffStrategy.canEqual(this)) return false;
        return true;
    }

    private static final double log2$1(double x) {
        return scala.math.package$.MODULE$.log10(x) / scala.math.package$.MODULE$.log10(2.0);
    }

    public ExponentialBackoffStrategy(FiniteDuration maxTime, FiniteDuration stepSize) {
        this.maxTime = maxTime;
        this.stepSize = stepSize;
        Product.$init$((Product)this);
        Predef$.MODULE$.require(stepSize.$greater$eq((Object)new package.DurationInt(package$.MODULE$.DurationInt(0)).seconds()), (Function0 & Serializable)() -> "Back-off step size must be non-negative. Given value: " + this.stepSize());
        Predef$.MODULE$.require(maxTime.$greater$eq((Object)new package.DurationInt(package$.MODULE$.DurationInt(0)).seconds()), (Function0 & Serializable)() -> "Back-off max time must be non-negative. Given value: " + this.stepSize());
    }
}

