/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.compress.snappy;

import coursierapi.shaded.compress.MalformedInputException;
import coursierapi.shaded.compress.snappy.SnappyRawDecompressor;
import java.util.Objects;
import sun.misc.Unsafe;

public class SnappyDecompressor {
    public static int getUncompressedLength(byte[] compressed, int compressedOffset) {
        long compressedAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + compressedOffset;
        long compressedLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + compressed.length;
        return SnappyRawDecompressor.getUncompressedLength(compressed, compressedAddress, compressedLimit);
    }

    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        SnappyDecompressor.verifyRange(input, inputOffset, inputLength);
        SnappyDecompressor.verifyRange(output, outputOffset, maxOutputLength);
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long inputLimit = inputAddress + (long)inputLength;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        long outputLimit = outputAddress + (long)maxOutputLength;
        return SnappyRawDecompressor.decompress(input, inputAddress, inputLimit, output, outputAddress, outputLimit);
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(String.format("Invalid offset or length (%s, %s) in array of length %s", offset, length, data.length));
        }
    }
}

