/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.SessionPersistence;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.SessionPersistenceBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.SessionPersistenceFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.BackendLBPolicySpec;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReferenceBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class BackendLBPolicySpecFluent<A extends BackendLBPolicySpecFluent<A>>
extends BaseFluent<A> {
    private SessionPersistenceBuilder sessionPersistence;
    private ArrayList<LocalPolicyTargetReferenceBuilder> targetRefs = new ArrayList();
    private Map<String, Object> additionalProperties;

    public BackendLBPolicySpecFluent() {
    }

    public BackendLBPolicySpecFluent(BackendLBPolicySpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BackendLBPolicySpec instance) {
        BackendLBPolicySpec backendLBPolicySpec = instance = instance != null ? instance : new BackendLBPolicySpec();
        if (instance != null) {
            this.withSessionPersistence(instance.getSessionPersistence());
            this.withTargetRefs(instance.getTargetRefs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SessionPersistence buildSessionPersistence() {
        return this.sessionPersistence != null ? this.sessionPersistence.build() : null;
    }

    public A withSessionPersistence(SessionPersistence sessionPersistence) {
        this._visitables.remove((Object)"sessionPersistence");
        if (sessionPersistence != null) {
            this.sessionPersistence = new SessionPersistenceBuilder(sessionPersistence);
            this._visitables.get((Object)"sessionPersistence").add(this.sessionPersistence);
        } else {
            this.sessionPersistence = null;
            this._visitables.get((Object)"sessionPersistence").remove((Object)this.sessionPersistence);
        }
        return (A)((Object)this);
    }

    public boolean hasSessionPersistence() {
        return this.sessionPersistence != null;
    }

    public SessionPersistenceNested<A> withNewSessionPersistence() {
        return new SessionPersistenceNested(null);
    }

    public SessionPersistenceNested<A> withNewSessionPersistenceLike(SessionPersistence item) {
        return new SessionPersistenceNested(item);
    }

    public SessionPersistenceNested<A> editSessionPersistence() {
        return this.withNewSessionPersistenceLike(Optional.ofNullable(this.buildSessionPersistence()).orElse(null));
    }

    public SessionPersistenceNested<A> editOrNewSessionPersistence() {
        return this.withNewSessionPersistenceLike(Optional.ofNullable(this.buildSessionPersistence()).orElse(new SessionPersistenceBuilder().build()));
    }

    public SessionPersistenceNested<A> editOrNewSessionPersistenceLike(SessionPersistence item) {
        return this.withNewSessionPersistenceLike(Optional.ofNullable(this.buildSessionPersistence()).orElse(item));
    }

    public A addToTargetRefs(int index, LocalPolicyTargetReference item) {
        if (this.targetRefs == null) {
            this.targetRefs = new ArrayList();
        }
        LocalPolicyTargetReferenceBuilder builder = new LocalPolicyTargetReferenceBuilder(item);
        if (index < 0 || index >= this.targetRefs.size()) {
            this._visitables.get((Object)"targetRefs").add(builder);
            this.targetRefs.add(builder);
        } else {
            this._visitables.get((Object)"targetRefs").add(builder);
            this.targetRefs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTargetRefs(int index, LocalPolicyTargetReference item) {
        if (this.targetRefs == null) {
            this.targetRefs = new ArrayList();
        }
        LocalPolicyTargetReferenceBuilder builder = new LocalPolicyTargetReferenceBuilder(item);
        if (index < 0 || index >= this.targetRefs.size()) {
            this._visitables.get((Object)"targetRefs").add(builder);
            this.targetRefs.add(builder);
        } else {
            this._visitables.get((Object)"targetRefs").add(builder);
            this.targetRefs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTargetRefs(LocalPolicyTargetReference ... items) {
        if (this.targetRefs == null) {
            this.targetRefs = new ArrayList();
        }
        for (LocalPolicyTargetReference item : items) {
            LocalPolicyTargetReferenceBuilder builder = new LocalPolicyTargetReferenceBuilder(item);
            this._visitables.get((Object)"targetRefs").add(builder);
            this.targetRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTargetRefs(Collection<LocalPolicyTargetReference> items) {
        if (this.targetRefs == null) {
            this.targetRefs = new ArrayList();
        }
        for (LocalPolicyTargetReference item : items) {
            LocalPolicyTargetReferenceBuilder builder = new LocalPolicyTargetReferenceBuilder(item);
            this._visitables.get((Object)"targetRefs").add(builder);
            this.targetRefs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTargetRefs(LocalPolicyTargetReference ... items) {
        if (this.targetRefs == null) {
            return (A)((Object)this);
        }
        for (LocalPolicyTargetReference item : items) {
            LocalPolicyTargetReferenceBuilder builder = new LocalPolicyTargetReferenceBuilder(item);
            this._visitables.get((Object)"targetRefs").remove((Object)builder);
            this.targetRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTargetRefs(Collection<LocalPolicyTargetReference> items) {
        if (this.targetRefs == null) {
            return (A)((Object)this);
        }
        for (LocalPolicyTargetReference item : items) {
            LocalPolicyTargetReferenceBuilder builder = new LocalPolicyTargetReferenceBuilder(item);
            this._visitables.get((Object)"targetRefs").remove((Object)builder);
            this.targetRefs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTargetRefs(Predicate<LocalPolicyTargetReferenceBuilder> predicate) {
        if (this.targetRefs == null) {
            return (A)((Object)this);
        }
        Iterator<LocalPolicyTargetReferenceBuilder> each = this.targetRefs.iterator();
        List visitables = this._visitables.get((Object)"targetRefs");
        while (each.hasNext()) {
            LocalPolicyTargetReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<LocalPolicyTargetReference> buildTargetRefs() {
        return this.targetRefs != null ? BackendLBPolicySpecFluent.build(this.targetRefs) : null;
    }

    public LocalPolicyTargetReference buildTargetRef(int index) {
        return this.targetRefs.get(index).build();
    }

    public LocalPolicyTargetReference buildFirstTargetRef() {
        return this.targetRefs.get(0).build();
    }

    public LocalPolicyTargetReference buildLastTargetRef() {
        return this.targetRefs.get(this.targetRefs.size() - 1).build();
    }

    public LocalPolicyTargetReference buildMatchingTargetRef(Predicate<LocalPolicyTargetReferenceBuilder> predicate) {
        for (LocalPolicyTargetReferenceBuilder item : this.targetRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTargetRef(Predicate<LocalPolicyTargetReferenceBuilder> predicate) {
        for (LocalPolicyTargetReferenceBuilder item : this.targetRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTargetRefs(List<LocalPolicyTargetReference> targetRefs) {
        if (this.targetRefs != null) {
            this._visitables.get((Object)"targetRefs").clear();
        }
        if (targetRefs != null) {
            this.targetRefs = new ArrayList();
            for (LocalPolicyTargetReference item : targetRefs) {
                this.addToTargetRefs(item);
            }
        } else {
            this.targetRefs = null;
        }
        return (A)((Object)this);
    }

    public A withTargetRefs(LocalPolicyTargetReference ... targetRefs) {
        if (this.targetRefs != null) {
            this.targetRefs.clear();
            this._visitables.remove((Object)"targetRefs");
        }
        if (targetRefs != null) {
            for (LocalPolicyTargetReference item : targetRefs) {
                this.addToTargetRefs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTargetRefs() {
        return this.targetRefs != null && !this.targetRefs.isEmpty();
    }

    public A addNewTargetRef(String group, String kind, String name) {
        return this.addToTargetRefs(new LocalPolicyTargetReference(group, kind, name));
    }

    public TargetRefsNested<A> addNewTargetRef() {
        return new TargetRefsNested(-1, null);
    }

    public TargetRefsNested<A> addNewTargetRefLike(LocalPolicyTargetReference item) {
        return new TargetRefsNested(-1, item);
    }

    public TargetRefsNested<A> setNewTargetRefLike(int index, LocalPolicyTargetReference item) {
        return new TargetRefsNested(index, item);
    }

    public TargetRefsNested<A> editTargetRef(int index) {
        if (this.targetRefs.size() <= index) {
            throw new RuntimeException("Can't edit targetRefs. Index exceeds size.");
        }
        return this.setNewTargetRefLike(index, this.buildTargetRef(index));
    }

    public TargetRefsNested<A> editFirstTargetRef() {
        if (this.targetRefs.size() == 0) {
            throw new RuntimeException("Can't edit first targetRefs. The list is empty.");
        }
        return this.setNewTargetRefLike(0, this.buildTargetRef(0));
    }

    public TargetRefsNested<A> editLastTargetRef() {
        int index = this.targetRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last targetRefs. The list is empty.");
        }
        return this.setNewTargetRefLike(index, this.buildTargetRef(index));
    }

    public TargetRefsNested<A> editMatchingTargetRef(Predicate<LocalPolicyTargetReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.targetRefs.size(); ++i) {
            if (!predicate.test(this.targetRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching targetRefs. No match found.");
        }
        return this.setNewTargetRefLike(index, this.buildTargetRef(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BackendLBPolicySpecFluent that = (BackendLBPolicySpecFluent)((Object)o);
        if (!Objects.equals((Object)this.sessionPersistence, (Object)that.sessionPersistence)) {
            return false;
        }
        if (!Objects.equals(this.targetRefs, that.targetRefs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sessionPersistence, this.targetRefs, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sessionPersistence != null) {
            sb.append("sessionPersistence:");
            sb.append(String.valueOf((Object)this.sessionPersistence) + ",");
        }
        if (this.targetRefs != null && !this.targetRefs.isEmpty()) {
            sb.append("targetRefs:");
            sb.append(String.valueOf(this.targetRefs) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetRefsNested<N>
    extends LocalPolicyTargetReferenceFluent<TargetRefsNested<N>>
    implements Nested<N> {
        LocalPolicyTargetReferenceBuilder builder;
        int index;

        TargetRefsNested(int index, LocalPolicyTargetReference item) {
            this.index = index;
            this.builder = new LocalPolicyTargetReferenceBuilder(this, item);
        }

        public N and() {
            return (N)BackendLBPolicySpecFluent.this.setToTargetRefs(this.index, this.builder.build());
        }

        public N endTargetRef() {
            return this.and();
        }
    }

    public class SessionPersistenceNested<N>
    extends SessionPersistenceFluent<SessionPersistenceNested<N>>
    implements Nested<N> {
        SessionPersistenceBuilder builder;

        SessionPersistenceNested(SessionPersistence item) {
            this.builder = new SessionPersistenceBuilder(this, item);
        }

        public N and() {
            return (N)BackendLBPolicySpecFluent.this.withSessionPersistence(this.builder.build());
        }

        public N endSessionPersistence() {
            return this.and();
        }
    }
}

