/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.LastDay$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(date) - Returns the last day of the month which the date belongs to.", examples="\n    Examples:\n      > SELECT _FUNC_('2009-01-12');\n       2009-01-31\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001\u0002\u000f\u001e\u0001*B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\")!\n\u0001C\u0001\u0017\")a\n\u0001C!\u001f\")1\u000b\u0001C!\u000b\")A\u000b\u0001C!+\")q\f\u0001C!A\")A\r\u0001C!K\")1\u000e\u0001C)Y\")!\u0010\u0001C!w\"9\u0011\u0011\u0002\u0001\u0005R\u0005-\u0001\"CA\t\u0001\u0005\u0005I\u0011AA\n\u0011%\t9\u0002AI\u0001\n\u0003\tI\u0002C\u0005\u00020\u0001\t\t\u0011\"\u0011\u00022!I\u0011\u0011\t\u0001\u0002\u0002\u0013\u0005\u00111\t\u0005\n\u0003\u0017\u0002\u0011\u0011!C\u0001\u0003\u001bB\u0011\"a\u0015\u0001\u0003\u0003%\t%!\u0016\t\u0013\u0005\r\u0004!!A\u0005\u0002\u0005\u0015\u0004\"CA5\u0001\u0005\u0005I\u0011IA6\u0011%\ty\u0007AA\u0001\n\u0003\n\thB\u0005\u0002\u0016v\t\t\u0011#\u0001\u0002\u0018\u001aAA$HA\u0001\u0012\u0003\tI\n\u0003\u0004K-\u0011\u0005\u0011\u0011\u0017\u0005\n\u0003g3\u0012\u0011!C#\u0003kC\u0011\"a.\u0017\u0003\u0003%\t)!/\t\u0013\u0005uf#!A\u0005\u0002\u0006}\u0006\"CAf-\u0005\u0005I\u0011BAg\u0005\u001da\u0015m\u001d;ECfT!AH\u0010\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003A\u0005\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003E\r\n1a]9m\u0015\t!S%A\u0003ta\u0006\u00148N\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<7\u0001A\n\u0006\u0001-z#\u0007\u000f\t\u0003Y5j\u0011!H\u0005\u0003]u\u0011q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003YAJ!!M\u000f\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002:\u0003:\u0011!h\u0010\b\u0003wyj\u0011\u0001\u0010\u0006\u0003{%\na\u0001\u0010:p_Rt\u0014\"A\u001b\n\u0005\u0001#\u0014a\u00029bG.\fw-Z\u0005\u0003\u0005\u000e\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0011\u001b\u0002\u0013M$\u0018M\u001d;ECR,W#\u0001$\u0011\u00051:\u0015B\u0001%\u001e\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u000bgR\f'\u000f\u001e#bi\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002M\u001bB\u0011A\u0006\u0001\u0005\u0006\t\u000e\u0001\rAR\u0001\u000f]VdG.\u00138u_2,'/\u00198u+\u0005\u0001\u0006CA\u001aR\u0013\t\u0011FGA\u0004C_>dW-\u00198\u0002\u000b\rD\u0017\u000e\u001c3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001W!\rIt+W\u0005\u00031\u000e\u00131aU3r!\tQV,D\u0001\\\u0015\ta\u0016%A\u0003usB,7/\u0003\u0002_7\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\t\u0011\r\u0005\u0002[E&\u00111m\u0017\u0002\t\t\u0006$\u0018\rV=qK\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0011a-\u001b\t\u0003g\u001dL!\u0001\u001b\u001b\u0003\u0007\u0005s\u0017\u0010C\u0003k\u0011\u0001\u0007a-\u0001\u0003eCR,\u0017!\u00033p\u000f\u0016t7i\u001c3f)\ri7\u000f\u001f\t\u0003]Fl\u0011a\u001c\u0006\u0003av\tqaY8eK\u001e,g.\u0003\u0002s_\nAQ\t\u001f9s\u0007>$W\rC\u0003u\u0013\u0001\u0007Q/A\u0002dib\u0004\"A\u001c<\n\u0005]|'AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006s&\u0001\r!\\\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\u0005a\bcA?\u0002\u00049\u0011ap \t\u0003wQJ1!!\u00015\u0003\u0019\u0001&/\u001a3fM&!\u0011QAA\u0004\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0001\u001b\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\ra\u0015Q\u0002\u0005\u0007\u0003\u001fY\u0001\u0019\u0001$\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR\u0019A*!\u0006\t\u000f\u0011c\u0001\u0013!a\u0001\r\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u000eU\r1\u0015QD\u0016\u0003\u0003?\u0001B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0006\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002.\u0005\r\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\r\u0011\t\u0005U\u0012qH\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005!A.\u00198h\u0015\t\ti$\u0001\u0003kCZ\f\u0017\u0002BA\u0003\u0003o\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0012\u0011\u0007M\n9%C\u0002\u0002JQ\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2AZA(\u0011%\t\t\u0006EA\u0001\u0002\u0004\t)%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003/\u0002R!!\u0017\u0002`\u0019l!!a\u0017\u000b\u0007\u0005uC'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0019\u0002\\\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u0001\u0016q\r\u0005\t\u0003#\u0012\u0012\u0011!a\u0001M\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019$!\u001c\t\u0013\u0005E3#!AA\u0002\u0005\u0015\u0013AB3rk\u0006d7\u000fF\u0002Q\u0003gB\u0001\"!\u0015\u0015\u0003\u0003\u0005\rA\u001a\u0015\u0014\u0001\u0005]\u0014QPA@\u0003\u0007\u000b))!#\u0002\f\u0006=\u0015\u0011\u0013\t\u0004Y\u0005e\u0014bAA>;\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAA\u0003-{f)\u0016(D?\"\"\u0017\r^3*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA1\f7\u000f\u001e\u0011eCf\u0004sN\u001a\u0011uQ\u0016\u0004Sn\u001c8uQ\u0002:\b.[2iAQDW\r\t3bi\u0016\u0004#-\u001a7p]\u001e\u001c\b\u0005^8/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAD\u0003!S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1aej\u0003'M\u00172e\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1aej\u0003'M\u00174c)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002\u000e\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAJ\u0003\u0015\td&\u000e\u00181\u0003\u001da\u0015m\u001d;ECf\u0004\"\u0001\f\f\u0014\u000bY\tY*a*\u0011\r\u0005u\u00151\u0015$M\u001b\t\tyJC\u0002\u0002\"R\nqA];oi&lW-\u0003\u0003\u0002&\u0006}%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!\u0011\u0011VAX\u001b\t\tYK\u0003\u0003\u0002.\u0006m\u0012AA5p\u0013\r\u0011\u00151\u0016\u000b\u0003\u0003/\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003g\tQ!\u00199qYf$2\u0001TA^\u0011\u0015!\u0015\u00041\u0001G\u0003\u001d)h.\u00199qYf$B!!1\u0002HB!1'a1G\u0013\r\t)\r\u000e\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005%'$!AA\u00021\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ty\r\u0005\u0003\u00026\u0005E\u0017\u0002BAj\u0003o\u0011aa\u00142kK\u000e$\b")
public class LastDay
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression startDate;

    public static Option<Expression> unapply(LastDay x$0) {
        return LastDay$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<LastDay, A> g) {
        return LastDay$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, LastDay> compose(Function1<A$, Expression> g) {
        return LastDay$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression child() {
        return this.startDate();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)DateType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object date) {
        return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getLastDayOfMonth(BoxesRunTime.unboxToInt((Object)date)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)sd -> dtu + ".getLastDayOfMonth(" + sd + ")");
    }

    @Override
    public String prettyName() {
        return "last_day";
    }

    @Override
    public LastDay withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public LastDay copy(Expression startDate) {
        return new LastDay(startDate);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    @Override
    public String productPrefix() {
        return "LastDay";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.startDate();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LastDay;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "startDate";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LastDay)) return false;
        boolean bl = true;
        if (!bl) return false;
        LastDay lastDay = (LastDay)x$1;
        Expression expression = this.startDate();
        Expression expression2 = lastDay.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!lastDay.canEqual(this)) return false;
        return true;
    }

    public LastDay(Expression startDate) {
        this.startDate = startDate;
        ExpectsInputTypes.$init$(this);
    }
}

