/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml.regression;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sparkproject.dmg.pmml.Extension;
import org.sparkproject.dmg.pmml.FieldRef;
import org.sparkproject.dmg.pmml.HasExtensions;
import org.sparkproject.dmg.pmml.HasName;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.Version;
import org.sparkproject.dmg.pmml.Visitor;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.dmg.pmml.adapters.RealNumberAdapter;
import org.sparkproject.dmg.pmml.regression.PMMLAttributes;
import org.sparkproject.dmg.pmml.regression.PMMLElements;
import org.sparkproject.dmg.pmml.regression.Term;
import org.sparkproject.jpmml.model.MissingAttributeException;
import org.sparkproject.jpmml.model.MissingElementException;
import org.sparkproject.jpmml.model.annotations.Added;
import org.sparkproject.jpmml.model.annotations.CollectionElementType;
import org.sparkproject.jpmml.model.annotations.Property;
import org.sparkproject.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="PredictorTerm", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "fieldRefs"})
@JsonRootName(value="PredictorTerm")
@JsonPropertyOrder(value={"name", "coefficient", "extensions", "fieldRefs"})
public class PredictorTerm
extends Term
implements HasExtensions<PredictorTerm>,
HasName<PredictorTerm> {
    @XmlAttribute(name="name")
    @JsonProperty(value="name")
    @Added(value=Version.PMML_4_1)
    private String name;
    @XmlAttribute(name="coefficient", required=true)
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="coefficient")
    private Number coefficient;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="FieldRef", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="FieldRef")
    @CollectionElementType(value=FieldRef.class)
    private List<FieldRef> fieldRefs;
    private static final long serialVersionUID = 67371272L;

    public PredictorTerm() {
    }

    @ValueConstructor
    public PredictorTerm(@Property(value="coefficient") Number coefficient, @Property(value="fieldRefs") List<FieldRef> fieldRefs) {
        this.coefficient = coefficient;
        this.fieldRefs = fieldRefs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PredictorTerm setName(@Property(value="name") String name) {
        this.name = name;
        return this;
    }

    @Override
    public Number requireCoefficient() {
        if (this.coefficient == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PREDICTORTERM_COEFFICIENT);
        }
        return this.coefficient;
    }

    @Override
    public Number getCoefficient() {
        return this.coefficient;
    }

    @Override
    public PredictorTerm setCoefficient(@Property(value="coefficient") Number coefficient) {
        this.coefficient = coefficient;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public PredictorTerm addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldRefs() {
        return this.fieldRefs != null && !this.fieldRefs.isEmpty();
    }

    public List<FieldRef> requireFieldRefs() {
        if (this.fieldRefs == null || this.fieldRefs.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.PREDICTORTERM_FIELDREFS);
        }
        return this.fieldRefs;
    }

    public List<FieldRef> getFieldRefs() {
        if (this.fieldRefs == null) {
            this.fieldRefs = new ArrayList<FieldRef>();
        }
        return this.fieldRefs;
    }

    public PredictorTerm addFieldRefs(FieldRef ... fieldRefs) {
        this.getFieldRefs().addAll(Arrays.asList(fieldRefs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasFieldRefs()) {
                status = PMMLObject.traverse(visitor, this.getFieldRefs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

