/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.mllib.clustering.EuclideanDistanceMeasure;
import org.apache.spark.mllib.clustering.EuclideanDistanceMeasure$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class LocalKMeans$
implements Logging {
    public static final LocalKMeans$ MODULE$ = new LocalKMeans$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public VectorWithNorm[] kMeansPlusPlus(int seed, VectorWithNorm[] points, double[] weights, int k, int maxIterations) {
        Random rand = new Random(seed);
        int dimensions = points[0].vector().size();
        VectorWithNorm[] centers = new VectorWithNorm[k];
        centers[0] = ((VectorWithNorm)this.pickWeighted(rand, points, weights)).toDense();
        double[] costArray = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])points), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(x$1, centers[0])), (ClassTag)ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), k).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int j;
            double sum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(costArray), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(weights))), (Function1 & Serializable)p -> BoxesRunTime.boxToDouble((double)LocalKMeans$.$anonfun$kMeansPlusPlus$3(p)), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double r = rand.nextDouble() * sum;
            double cumulativeScore = 0.0;
            for (j = 0; j < points.length && cumulativeScore < r; cumulativeScore += weights[j] * costArray[j], ++j) {
            }
            if (j == 0) {
                MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"kMeansPlusPlus initialization ran out of distinct points for centers."}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" Using duplicate point for center k = ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.POINT_OF_CENTER$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)i))})))));
                centers$1[i] = points[0].toDense();
            } else {
                centers$1[i] = points[j - 1].toDense();
            }
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])points)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)p -> {
                costArray$1[p] = package$.MODULE$.min(EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(points[p], centers[i]), costArray[p]);
            });
        });
        EuclideanDistanceMeasure distanceMeasureInstance = new EuclideanDistanceMeasure();
        int[] oldClosest = (int[])Array$.MODULE$.fill(points.length, (Function0)(JFunction0.mcI.sp & Serializable)() -> -1, (ClassTag)ClassTag$.MODULE$.Int());
        IntRef iteration = IntRef.create((int)0);
        boolean moved = true;
        while (moved && iteration.elem < maxIterations) {
            moved = false;
            double[] counts = (double[])Array$.MODULE$.ofDim(k, (ClassTag)ClassTag$.MODULE$.Double());
            Vector[] sums = (Vector[])Array$.MODULE$.fill(k, (Function0 & Serializable)() -> Vectors$.MODULE$.zeros(dimensions), ClassTag$.MODULE$.apply(Vector.class));
            for (int i2 = 0; i2 < points.length; ++i2) {
                VectorWithNorm p = points[i2];
                int index = distanceMeasureInstance.findClosest(centers, p)._1$mcI$sp();
                BLAS$.MODULE$.axpy(weights[i2], p.vector(), sums[index]);
                counts[index] = counts[index] + weights[i2];
                if (index == oldClosest[i2]) continue;
                moved = true;
                oldClosest[i2] = index;
            }
            for (int j = 0; j < k; ++j) {
                if (counts[j] == 0.0) {
                    centers[j] = points[rand.nextInt(points.length)].toDense();
                    continue;
                }
                BLAS$.MODULE$.scal(1.0 / counts[j], sums[j]);
                centers[j] = new VectorWithNorm(sums[j]);
            }
            ++iteration.elem;
        }
        if (iteration.elem == maxIterations) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Local KMeans++ reached the max number of "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"iterations: ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_ITERATIONS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)maxIterations))})))));
        } else {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Local KMeans++ converged in ", " iterations."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_ITERATIONS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)iteration$1.elem))}))));
        }
        return centers;
    }

    private <T> T pickWeighted(Random rand, Object data, double[] weights) {
        double r = rand.nextDouble() * BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(weights).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        int i = 0;
        for (double curWeight = 0.0; i < ScalaRunTime$.MODULE$.array_length(data) && curWeight < r; curWeight += weights[i], ++i) {
        }
        return (T)ScalaRunTime$.MODULE$.array_apply(data, i - 1);
    }

    public static final /* synthetic */ double $anonfun$kMeansPlusPlus$3(Tuple2 p) {
        return p._1$mcD$sp() * p._2$mcD$sp();
    }

    private LocalKMeans$() {
    }
}

