/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchGroup;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.FetchGroupMemberMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.util.MultiMap;

public class FetchGroupManager {
    private MultiMap fetchGroupByName;
    private NucleusContext nucleusCtx;

    public FetchGroupManager(NucleusContext ctx) {
        this.nucleusCtx = ctx;
    }

    public synchronized void addFetchGroup(FetchGroup grp) {
        Collection coll;
        if (this.fetchGroupByName == null) {
            this.fetchGroupByName = new MultiMap();
        }
        if ((coll = (Collection)this.fetchGroupByName.get(grp.getName())) != null) {
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                FetchGroup existingGrp = (FetchGroup)iter.next();
                if (!existingGrp.getName().equals(grp.getName()) || !existingGrp.getType().getName().equals(grp.getType().getName())) continue;
                existingGrp.disconnectFromListeners();
                iter.remove();
            }
        }
        this.fetchGroupByName.put(grp.getName(), grp);
    }

    public synchronized void removeFetchGroup(FetchGroup grp) {
        Collection coll;
        if (this.fetchGroupByName != null && (coll = (Collection)this.fetchGroupByName.get(grp.getName())) != null) {
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                FetchGroup existingGrp = (FetchGroup)iter.next();
                if (existingGrp.getType() != grp.getType()) continue;
                existingGrp.disconnectFromListeners();
                iter.remove();
            }
        }
    }

    public synchronized <T> FetchGroup<T> getFetchGroup(Class<T> cls, String name, boolean createIfNotPresent) {
        Collection coll;
        if (this.fetchGroupByName != null && (coll = (Collection)this.fetchGroupByName.get(name)) != null) {
            for (FetchGroup grp : coll) {
                if (grp.getType() != cls) continue;
                return grp;
            }
        }
        if (createIfNotPresent) {
            FetchGroup<T> grp = this.createFetchGroup(cls, name);
            this.addFetchGroup(grp);
            return grp;
        }
        return null;
    }

    public <T> FetchGroup<T> createFetchGroup(Class<T> cls, String name) {
        FetchGroup<T> fg = new FetchGroup<T>(this.nucleusCtx, name, cls);
        if (name.equals("default")) {
            fg.addCategory("default");
        } else {
            FetchGroupMetaData fgmd;
            ClassLoaderResolver clr = this.nucleusCtx.getClassLoaderResolver(cls.getClassLoader());
            AbstractClassMetaData cmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(cls, clr);
            if (cmd != null && (fgmd = cmd.getFetchGroupMetaData(name)) != null) {
                Set<FetchGroupMemberMetaData> fgmmds = fgmd.getMembers();
                for (FetchGroupMemberMetaData fgmmd : fgmmds) {
                    fg.addMember(fgmmd.getName());
                    if (fgmmd.getRecursionDepth() == 1) continue;
                    fg.setRecursionDepth(fgmmd.getName(), fgmmd.getRecursionDepth());
                }
            }
        }
        return fg;
    }

    public synchronized Set<FetchGroup> getFetchGroupsWithName(String name) {
        Collection coll;
        if (this.fetchGroupByName != null && (coll = (Collection)this.fetchGroupByName.get(name)) != null) {
            return new HashSet<FetchGroup>(coll);
        }
        return null;
    }

    public synchronized void clearFetchGroups() {
        if (this.fetchGroupByName != null) {
            Collection fetchGroups = this.fetchGroupByName.values();
            for (FetchGroup grp : fetchGroups) {
                grp.disconnectFromListeners();
            }
            this.fetchGroupByName.clear();
        }
    }
}

