/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.DataSourceManager$;
import org.apache.spark.sql.execution.datasources.v2.python.UserDefinedPythonDataSource;
import org.slf4j.Logger;
import scala.Function0;
import scala.StringContext;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005u4AAE\n\u0001A!)Q\u0006\u0001C\u0001]!A\u0011\u0007\u0001EC\u0002\u0013%!\u0007C\u0004J\u0001\t\u0007I\u0011\u0002&\t\rU\u0003\u0001\u0015!\u0003L\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u0015A\u0007\u0001\"\u0011/\u000f\u0015I7\u0003#\u0001k\r\u0015\u00112\u0003#\u0001l\u0011\u0015i#\u0002\"\u0001m\u0011!i'\u00021A\u0005\u0002eq\u0007\u0002\u0003:\u000b\u0001\u0004%\t!G:\t\rYT\u0001\u0015)\u0003p\u0011!9(\u0002#b\u0001\n\u0013A\b\"B=\u000b\t\u0013Q\b\"\u0002?\u000b\t\u0013\u0011$!\u0005#bi\u0006\u001cv.\u001e:dK6\u000bg.Y4fe*\u0011A#F\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u0017/\u0005IQ\r_3dkRLwN\u001c\u0006\u00031e\t1a]9m\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)W5\t\u0011F\u0003\u0002+3\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002-S\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00010!\t\u0001\u0004!D\u0001\u0014\u0003a\u0019H/\u0019;jG\u0012\u000bG/Y*pkJ\u001cWMQ;jY\u0012,'o]\u000b\u0002gA!Ag\u000f B\u001d\t)\u0014\b\u0005\u00027G5\tqG\u0003\u00029?\u00051AH]8pizJ!AO\u0012\u0002\rA\u0013X\rZ3g\u0013\taTHA\u0002NCBT!AO\u0012\u0011\u0005Qz\u0014B\u0001!>\u0005\u0019\u0019FO]5oOB\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0007af$\bn\u001c8\u000b\u0005\u0019\u001b\u0012A\u0001<3\u0013\tA5IA\u000eVg\u0016\u0014H)\u001a4j]\u0016$\u0007+\u001f;i_:$\u0015\r^1T_V\u00148-Z\u0001\u001aeVtG/[7f\t\u0006$\u0018mU8ve\u000e,')^5mI\u0016\u00148/F\u0001L!\u0011a5KP!\u000e\u00035S!AT(\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002Q#\u0006!Q\u000f^5m\u0015\u0005\u0011\u0016\u0001\u00026bm\u0006L!\u0001V'\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007/\u0001\u000esk:$\u0018.\\3ECR\f7k\\;sG\u0016\u0014U/\u001b7eKJ\u001c\b%\u0001\nsK\u001eL7\u000f^3s\t\u0006$\u0018mU8ve\u000e,Gc\u0001-\\;B\u0011!%W\u0005\u00035\u000e\u0012A!\u00168ji\")A,\u0002a\u0001}\u0005!a.Y7f\u0011\u0015qV\u00011\u0001B\u0003\u0019\u0019x.\u001e:dK\u0006\u0001Bn\\8lkB$\u0015\r^1T_V\u00148-\u001a\u000b\u0003\u0003\u0006DQ\u0001\u0018\u0004A\u0002y\n\u0001\u0003Z1uCN{WO]2f\u000bbL7\u000f^:\u0015\u0005\u0011<\u0007C\u0001\u0012f\u0013\t17EA\u0004C_>dW-\u00198\t\u000bq;\u0001\u0019\u0001 \u0002\u000b\rdwN\\3\u0002#\u0011\u000bG/Y*pkJ\u001cW-T1oC\u001e,'\u000f\u0005\u00021\u0015M\u0019!\"I\u0014\u0015\u0003)\f!\u0003Z1uCN{WO]2f\u0005VLG\u000eZ3sgV\tq\u000eE\u0002#aNJ!!]\u0012\u0003\r=\u0003H/[8o\u0003Y!\u0017\r^1T_V\u00148-\u001a\"vS2$WM]:`I\u0015\fHC\u0001-u\u0011\u001d)X\"!AA\u0002=\f1\u0001\u001f\u00132\u0003M!\u0017\r^1T_V\u00148-\u001a\"vS2$WM]:!\u0003m\u0019\bn\\;mI2{\u0017\r\u001a)zi\"|g\u000eR1uCN{WO]2fgV\tA-A\u0005o_Jl\u0017\r\\5{KR\u0011ah\u001f\u0005\u00069B\u0001\rAP\u0001 S:LG/[1m'R\fG/[2ECR\f7k\\;sG\u0016\u0014U/\u001b7eKJ\u001c\b")
public class DataSourceManager
implements Logging {
    private Map<String, UserDefinedPythonDataSource> staticDataSourceBuilders;
    private final ConcurrentHashMap<String, UserDefinedPythonDataSource> runtimeDataSourceBuilders;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Map<String, UserDefinedPythonDataSource> staticDataSourceBuilders$lzycompute() {
        DataSourceManager dataSourceManager = this;
        synchronized (dataSourceManager) {
            if (!this.bitmap$0) {
                this.staticDataSourceBuilders = DataSourceManager$.MODULE$.org$apache$spark$sql$execution$datasources$DataSourceManager$$initialStaticDataSourceBuilders();
                this.bitmap$0 = true;
            }
        }
        return this.staticDataSourceBuilders;
    }

    private Map<String, UserDefinedPythonDataSource> staticDataSourceBuilders() {
        if (!this.bitmap$0) {
            return this.staticDataSourceBuilders$lzycompute();
        }
        return this.staticDataSourceBuilders;
    }

    private ConcurrentHashMap<String, UserDefinedPythonDataSource> runtimeDataSourceBuilders() {
        return this.runtimeDataSourceBuilders;
    }

    public void registerDataSource(String name, UserDefinedPythonDataSource source) {
        String normalizedName = DataSourceManager$.MODULE$.org$apache$spark$sql$execution$datasources$DataSourceManager$$normalize(name);
        if (this.staticDataSourceBuilders().contains((Object)normalizedName)) {
            throw QueryCompilationErrors$.MODULE$.dataSourceAlreadyExists(name);
        }
        UserDefinedPythonDataSource previousValue = this.runtimeDataSourceBuilders().put(normalizedName, source);
        if (previousValue != null) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The data source ", " replaced a previously "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.DATA_SOURCE$.MODULE$, (Object)name)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"registered data source."}))).log((Seq)Nil$.MODULE$))));
            return;
        }
    }

    public UserDefinedPythonDataSource lookupDataSource(String name) {
        if (this.dataSourceExists(name)) {
            String normalizedName = DataSourceManager$.MODULE$.org$apache$spark$sql$execution$datasources$DataSourceManager$$normalize(name);
            return (UserDefinedPythonDataSource)this.staticDataSourceBuilders().getOrElse((Object)normalizedName, (Function0 & Serializable)() -> this.runtimeDataSourceBuilders().get(normalizedName));
        }
        throw QueryCompilationErrors$.MODULE$.dataSourceDoesNotExist(name);
    }

    public boolean dataSourceExists(String name) {
        String normalizedName = DataSourceManager$.MODULE$.org$apache$spark$sql$execution$datasources$DataSourceManager$$normalize(name);
        return this.staticDataSourceBuilders().contains((Object)normalizedName) || this.runtimeDataSourceBuilders().containsKey(normalizedName);
    }

    public DataSourceManager clone() {
        DataSourceManager manager = new DataSourceManager();
        this.runtimeDataSourceBuilders().forEach((k, v) -> manager.registerDataSource((String)k, (UserDefinedPythonDataSource)v));
        return manager;
    }

    public DataSourceManager() {
        Logging.$init$((Logging)this);
        this.runtimeDataSourceBuilders = new ConcurrentHashMap();
    }
}

