/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Observation$;
import org.apache.spark.sql.ObservationListener;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.CollectMetrics;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.util.SparkThreadUtils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\u000f\u001f\u0001\u001dB\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tw\u0001\u0011\t\u0011)A\u0005a!)A\b\u0001C\u0001{!)A\b\u0001C\u0001\u0003\"9!\t\u0001b\u0001\n\u0013\u0019\u0005BB$\u0001A\u0003%A\tC\u0004I\u0001\u0001\u0007I\u0011B%\t\u000fA\u0003\u0001\u0019!C\u0005#\"1q\u000b\u0001Q!\n)Cq\u0001\u0018\u0001A\u0002\u0013%Q\fC\u0004c\u0001\u0001\u0007I\u0011B2\t\r\u0015\u0004\u0001\u0015)\u0003_\u0011\u001d9\u0007A1A\u0005\n!DaA\u001d\u0001!\u0002\u0013I\u0007bB:\u0001\u0005\u0004%\t\u0001\u001e\u0005\u0007q\u0002\u0001\u000b\u0011B;\t\re\u0004A\u0011\u0001\u0011{\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!a \u0001\t\u0003\t\t\tC\u0004\u0002\u001e\u0002!I!a(\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002(\"A\u0011\u0011\u0016\u0001\u0005\u0002\u0001\nY\u000b\u0003\u0005\u0002>\u0002!\tAHA`\u000f\u001d\t\tM\bE\u0001\u0003\u00074a!\b\u0010\t\u0002\u0005\u0015\u0007B\u0002\u001f\u001a\t\u0003\t9\r\u0003\u0004\u0002Jf!\t!\u0011\u0005\b\u0003\u0013LB\u0011AAf\u0005-y%m]3sm\u0006$\u0018n\u001c8\u000b\u0005}\u0001\u0013aA:rY*\u0011\u0011EI\u0001\u0006gB\f'o\u001b\u0006\u0003G\u0011\na!\u00199bG\",'\"A\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001A\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g-\u0001\u0003oC6,W#\u0001\u0019\u0011\u0005EBdB\u0001\u001a7!\t\u0019$&D\u00015\u0015\t)d%\u0001\u0004=e>|GOP\u0005\u0003o)\na\u0001\u0015:fI\u00164\u0017BA\u001d;\u0005\u0019\u0019FO]5oO*\u0011qGK\u0001\u0006]\u0006lW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005y\u0002\u0005CA \u0001\u001b\u0005q\u0002\"\u0002\u0018\u0004\u0001\u0004\u0001D#\u0001 \u0002\u00111L7\u000f^3oKJ,\u0012\u0001\u0012\t\u0003\u007f\u0015K!A\u0012\u0010\u0003'=\u00137/\u001a:wCRLwN\u001c'jgR,g.\u001a:\u0002\u00131L7\u000f^3oKJ\u0004\u0013\u0001D:qCJ\\7+Z:tS>tW#\u0001&\u0011\u0007%ZU*\u0003\u0002MU\t1q\n\u001d;j_:\u0004\"a\u0010(\n\u0005=s\"\u0001D*qCJ\\7+Z:tS>t\u0017\u0001E:qCJ\\7+Z:tS>tw\fJ3r)\t\u0011V\u000b\u0005\u0002*'&\u0011AK\u000b\u0002\u0005+:LG\u000fC\u0004W\u0011\u0005\u0005\t\u0019\u0001&\u0002\u0007a$\u0013'A\u0007ta\u0006\u00148nU3tg&|g\u000e\t\u0015\u0003\u0013e\u0003\"!\u000b.\n\u0005mS#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0017\u0011\fG/\u00194sC6,\u0017\nZ\u000b\u0002=B\u0019\u0011fS0\u0011\u0005%\u0002\u0017BA1+\u0005\u0011auN\\4\u0002\u001f\u0011\fG/\u00194sC6,\u0017\nZ0%KF$\"A\u00153\t\u000fY[\u0011\u0011!a\u0001=\u0006aA-\u0019;bMJ\fW.Z%eA!\u0012A\"W\u0001\baJ|W.[:f+\u0005I\u0007c\u00016n_6\t1N\u0003\u0002mU\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u00059\\'a\u0002)s_6L7/\u001a\t\u0003\u007fAL!!\u001d\u0010\u0003\u0007I{w/\u0001\u0005qe>l\u0017n]3!\u0003\u00191W\u000f^;sKV\tQ\u000fE\u0002km>L!a^6\u0003\r\u0019+H/\u001e:f\u0003\u001d1W\u000f^;sK\u0002\n!a\u001c8\u0016\u0007m\f\u0019\u0001F\u0004}\u0003+\tI\"a\t\u0011\u0007}jx0\u0003\u0002\u007f=\t9A)\u0019;bg\u0016$\b\u0003BA\u0001\u0003\u0007a\u0001\u0001B\u0004\u0002\u0006E\u0011\r!a\u0002\u0003\u0003Q\u000bB!!\u0003\u0002\u0010A\u0019\u0011&a\u0003\n\u0007\u00055!FA\u0004O_RD\u0017N\\4\u0011\u0007%\n\t\"C\u0002\u0002\u0014)\u00121!\u00118z\u0011\u0019\t9\"\u0005a\u0001y\u0006\u0011Am\u001d\u0005\b\u00037\t\u0002\u0019AA\u000f\u0003\u0011)\u0007\u0010\u001d:\u0011\u0007}\ny\"C\u0002\u0002\"y\u0011aaQ8mk6t\u0007bBA\u0013#\u0001\u0007\u0011qE\u0001\u0006Kb\u0004(o\u001d\t\u0006S\u0005%\u0012QD\u0005\u0004\u0003WQ#A\u0003\u001fsKB,\u0017\r^3e}\u0005\u0019q-\u001a;\u0016\u0005\u0005E\u0002\u0007BA\u001a\u0003w\u0001b!MA\u001ba\u0005e\u0012bAA\u001cu\t\u0019Q*\u00199\u0011\t\u0005\u0005\u00111\b\u0003\f\u0003{\u0011\u0012\u0011!A\u0001\u0006\u0003\t9AA\u0002`IEBSAEA!\u00033\u0002R!KA\"\u0003\u000fJ1!!\u0012+\u0005\u0019!\bN]8xgB!\u0011\u0011JA*\u001d\u0011\tY%a\u0014\u000f\u0007M\ni%C\u0001,\u0013\r\t\tFK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)&a\u0016\u0003)%sG/\u001a:skB$X\rZ#yG\u0016\u0004H/[8o\u0015\r\t\tFK\u0019\u0007=A\nY&! 2\u0013\r\ni&!\u0019\u0002t\u0005\rTcA\u0018\u0002`\u00119\u0011Q\u0001\u0014C\u0002\u0005%\u0014\u0002BA2\u0003K\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAA4U\u00051A\u000f\u001b:poN\fB!!\u0003\u0002lA!\u0011QNA8\u001d\rI\u0013qJ\u0005\u0005\u0003c\n9FA\u0005UQJ|w/\u00192mKFJ1%!\u001e\u0002x\u0005e\u0014q\r\b\u0004S\u0005]\u0014bAA4UE*!%\u000b\u0016\u0002|\t)1oY1mCF\u001aa%a\u0012\u0002\u0013\u001d,G/Q:KCZ\fWCAAB!\u0019\t))a$1Q5\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)\u0001\u0003vi&d'BAAG\u0003\u0011Q\u0017M^1\n\t\u0005]\u0012q\u0011\u0015\u0006'\u0005\u0005\u00131S\u0019\u0007=A\n)*a'2\u0013\r\ni&!\u0019\u0002\u0018\u0006\r\u0014'C\u0012\u0002v\u0005]\u0014\u0011TA4c\u0015\u0011\u0013FKA>c\r1\u0013qI\u0001\te\u0016<\u0017n\u001d;feR)!+!)\u0002$\")\u0001\n\u0006a\u0001\u001b\")A\f\u0006a\u0001?\u0006QQO\u001c:fO&\u001cH/\u001a:\u0015\u0003I\u000b\u0001b\u001c8GS:L7\u000f\u001b\u000b\u0004%\u00065\u0006bBAX-\u0001\u0007\u0011\u0011W\u0001\u0003c\u0016\u0004B!a-\u0002:6\u0011\u0011Q\u0017\u0006\u0004\u0003os\u0012!C3yK\u000e,H/[8o\u0013\u0011\tY,!.\u0003\u001dE+XM]=Fq\u0016\u001cW\u000f^5p]\u00061q-\u001a;S_^,\u0012a\\\u0001\f\u001f\n\u001cXM\u001d<bi&|g\u000e\u0005\u0002@3M\u0011\u0011\u0004\u000b\u000b\u0003\u0003\u0007\fQ!\u00199qYf$2APAg\u0011\u0015qC\u00041\u00011\u0001")
public class Observation {
    private final String name;
    private final ObservationListener listener;
    private volatile Option<SparkSession> sparkSession;
    private volatile Option<Object> dataframeId;
    private final Promise<Row> promise;
    private final Future<Row> future;

    public static Observation apply(String name) {
        return Observation$.MODULE$.apply(name);
    }

    public static Observation apply() {
        return Observation$.MODULE$.apply();
    }

    public String name() {
        return this.name;
    }

    private ObservationListener listener() {
        return this.listener;
    }

    private Option<SparkSession> sparkSession() {
        return this.sparkSession;
    }

    private void sparkSession_$eq(Option<SparkSession> x$1) {
        this.sparkSession = x$1;
    }

    private Option<Object> dataframeId() {
        return this.dataframeId;
    }

    private void dataframeId_$eq(Option<Object> x$1) {
        this.dataframeId = x$1;
    }

    private Promise<Row> promise() {
        return this.promise;
    }

    public Future<Row> future() {
        return this.future;
    }

    public <T> Dataset<T> on(Dataset<T> ds, Column expr, Seq<Column> exprs) {
        if (ds.isStreaming()) {
            throw new IllegalArgumentException("Observation does not support streaming Datasets");
        }
        long dataframeId = ds.id();
        this.register(ds.sparkSession(), dataframeId);
        return ds.observe(this.name(), expr, exprs);
    }

    public scala.collection.immutable.Map<String, Object> get() throws InterruptedException {
        Row row = this.getRow();
        return row == null || row.schema() == null ? Predef$.MODULE$.Map().empty() : row.getValuesMap((Seq)row.schema().map((Function1 & Serializable)x$1 -> x$1.name()));
    }

    public java.util.Map<String, Object> getAsJava() throws InterruptedException {
        return JavaConverters$.MODULE$.mapAsJavaMap((Map)this.get().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Object value = tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, value);
            return tuple22;
        }));
    }

    private void register(SparkSession sparkSession, long dataframeId) {
        Observation observation = this;
        synchronized (observation) {
            if (this.sparkSession().isDefined()) {
                throw new IllegalArgumentException("An Observation can be used with a Dataset only once");
            }
            this.sparkSession_$eq((Option<SparkSession>)new Some((Object)sparkSession));
            this.dataframeId_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)dataframeId)));
        }
        sparkSession.listenerManager().register(this.listener());
    }

    private void unregister() {
        this.sparkSession().foreach((Function1 & Serializable)x$2 -> {
            Observation.$anonfun$unregister$1(this, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public void onFinish(QueryExecution qe) {
        block2: {
            if (!qe.logical().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Observation.$anonfun$onFinish$1(this, x0$1)))) break block2;
            Option metrics2 = qe.observedMetrics().get((Object)this.name());
            if (metrics2.isEmpty()) {
                this.promise().trySuccess((Object)Row$.MODULE$.empty());
                this.unregister();
            } else {
                metrics2.foreach((Function1 & Serializable)metrics -> {
                    Observation.$anonfun$onFinish$2(this, metrics);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public Row getRow() {
        return (Row)SparkThreadUtils$.MODULE$.awaitResult(this.future(), (Duration)Duration$.MODULE$.Inf());
    }

    public static final /* synthetic */ void $anonfun$unregister$1(Observation $this, SparkSession x$2) {
        x$2.listenerManager().unregister($this.listener());
    }

    public static final /* synthetic */ boolean $anonfun$onFinish$1(Observation $this, LogicalPlan x0$1) {
        boolean bl;
        LogicalPlan logicalPlan2 = x0$1;
        if (logicalPlan2 instanceof CollectMetrics) {
            CollectMetrics collectMetrics = (CollectMetrics)logicalPlan2;
            String name = collectMetrics.name();
            long dataframeId = collectMetrics.dataframeId();
            String string = name;
            String string2 = $this.name();
            bl = !(string != null ? !string.equals(string2) : string2 != null) && dataframeId == BoxesRunTime.unboxToLong((Object)$this.dataframeId().get());
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$onFinish$2(Observation $this, Row metrics) {
        $this.promise().trySuccess((Object)metrics);
        $this.unregister();
    }

    public Observation(String name) {
        this.name = name;
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        this.listener = new ObservationListener(this);
        this.sparkSession = None$.MODULE$;
        this.dataframeId = None$.MODULE$;
        this.promise = Promise$.MODULE$.apply();
        this.future = this.promise().future();
    }

    public Observation() {
        this(UUID.randomUUID().toString());
    }
}

