/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;

public class HiveSortRemoveRule
extends RelOptRule {
    protected final float reductionProportion;
    protected final float reductionTuples;

    public HiveSortRemoveRule(float reductionProportion, long reductionTuples) {
        this(HiveSortRemoveRule.operand(HiveSortLimit.class, (RelOptRuleOperandChildren)HiveSortRemoveRule.any()), reductionProportion, reductionTuples);
    }

    private HiveSortRemoveRule(RelOptRuleOperand operand, float reductionProportion, long reductionTuples) {
        super(operand);
        this.reductionProportion = reductionProportion;
        this.reductionTuples = reductionTuples;
    }

    public boolean matches(RelOptRuleCall call) {
        HiveSortLimit sortLimit = (HiveSortLimit)call.rel(0);
        if (!sortLimit.isRuleCreated()) {
            return false;
        }
        int limit = RexLiteral.intValue((RexNode)sortLimit.fetch);
        Double rowCount = RelMetadataQuery.instance().getRowCount(sortLimit.getInput());
        return rowCount == null || !((double)limit <= (double)this.reductionProportion * rowCount) || !(rowCount - (double)limit >= (double)this.reductionTuples);
    }

    public void onMatch(RelOptRuleCall call) {
        HiveSortLimit sortLimit = (HiveSortLimit)call.rel(0);
        call.transformTo(sortLimit.getInput());
    }
}

