/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead;

import com.google.crypto.tink.aead.AesCtrHmacAeadParameters;
import com.google.crypto.tink.aead.AesEaxParameters;
import com.google.crypto.tink.aead.AesGcmParameters;
import com.google.crypto.tink.aead.ChaCha20Poly1305Parameters;
import com.google.crypto.tink.aead.XChaCha20Poly1305Parameters;
import com.google.crypto.tink.internal.TinkBugException;

public final class PredefinedAeadParameters {
    public static final AesGcmParameters AES128_GCM = TinkBugException.exceptionIsBug(() -> AesGcmParameters.builder().setIvSizeBytes(12).setKeySizeBytes(16).setTagSizeBytes(16).setVariant(AesGcmParameters.Variant.TINK).build());
    public static final AesGcmParameters AES256_GCM = TinkBugException.exceptionIsBug(() -> AesGcmParameters.builder().setIvSizeBytes(12).setKeySizeBytes(32).setTagSizeBytes(16).setVariant(AesGcmParameters.Variant.TINK).build());
    public static final AesEaxParameters AES128_EAX = TinkBugException.exceptionIsBug(() -> AesEaxParameters.builder().setIvSizeBytes(16).setKeySizeBytes(16).setTagSizeBytes(16).setVariant(AesEaxParameters.Variant.TINK).build());
    public static final AesEaxParameters AES256_EAX = TinkBugException.exceptionIsBug(() -> AesEaxParameters.builder().setIvSizeBytes(16).setKeySizeBytes(32).setTagSizeBytes(16).setVariant(AesEaxParameters.Variant.TINK).build());
    public static final AesCtrHmacAeadParameters AES128_CTR_HMAC_SHA256 = TinkBugException.exceptionIsBug(() -> AesCtrHmacAeadParameters.builder().setAesKeySizeBytes(16).setHmacKeySizeBytes(32).setTagSizeBytes(16).setHashType(AesCtrHmacAeadParameters.HashType.SHA256).setVariant(AesCtrHmacAeadParameters.Variant.TINK).build());
    public static final AesCtrHmacAeadParameters AES256_CTR_HMAC_SHA256 = TinkBugException.exceptionIsBug(() -> AesCtrHmacAeadParameters.builder().setAesKeySizeBytes(32).setHmacKeySizeBytes(32).setTagSizeBytes(32).setHashType(AesCtrHmacAeadParameters.HashType.SHA256).setVariant(AesCtrHmacAeadParameters.Variant.TINK).build());
    public static final ChaCha20Poly1305Parameters CHACHA20_POLY1305 = ChaCha20Poly1305Parameters.create(ChaCha20Poly1305Parameters.Variant.TINK);
    public static final XChaCha20Poly1305Parameters XCHACHA20_POLY1305 = XChaCha20Poly1305Parameters.create(XChaCha20Poly1305Parameters.Variant.TINK);

    private PredefinedAeadParameters() {
    }
}

