/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.AccumulableInfo;
import org.apache.spark.status.api.v1.ApplicationAttemptInfo;
import org.apache.spark.status.api.v1.ExecutorMetricsDistributions;
import org.apache.spark.status.api.v1.ExecutorStageSummary;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.SpeculationStageSummary;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.StageStatus;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetricDistributions;
import org.apache.spark.ui.ToolTips$;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.ui.jobs.JobDataUtil$;
import org.apache.spark.ui.jobs.JobsTab;
import org.apache.spark.ui.jobs.StageTableBase;
import org.apache.spark.ui.scope.RDDOperationGraph;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;
import scala.xml.Utility$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015b!\u0002\n\u0014\u0001Ui\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\t\u0011!\u0002!\u0011!Q\u0001\n%BQa\f\u0001\u0005\u0002ABq\u0001\u000e\u0001C\u0002\u0013%Q\u0007\u0003\u0004=\u0001\u0001\u0006IA\u000e\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019\u0011\u0005\u0001)A\u0005\u007f!91\t\u0001b\u0001\n\u0013q\u0004B\u0002#\u0001A\u0003%q\bC\u0004F\u0001\t\u0007I\u0011\u0002$\t\rI\u0003\u0001\u0015!\u0003H\u0011\u001d\u0019\u0006A1A\u0005\n\u0019Ca\u0001\u0016\u0001!\u0002\u00139\u0005\"B+\u0001\t\u00131\u0006\"B6\u0001\t\u0003a\u0007\"B:\u0001\t\u0013!\bbBA\u0005\u0001\u0011\u0005\u00111\u0002\u0002\b\u0015>\u0014\u0007+Y4f\u0015\t!R#\u0001\u0003k_\n\u001c(B\u0001\f\u0018\u0003\t)\u0018N\u0003\u0002\u00193\u0005)1\u000f]1sW*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h'\t\u0001a\u0004\u0005\u0002 A5\tQ#\u0003\u0002\"+\tIq+\u001a2V\u0013B\u000bw-Z\u0001\u0007a\u0006\u0014XM\u001c;\u0004\u0001A\u0011QEJ\u0007\u0002'%\u0011qe\u0005\u0002\b\u0015>\u00147\u000fV1c\u0003\u0015\u0019Ho\u001c:f!\tQS&D\u0001,\u0015\tas#\u0001\u0004ti\u0006$Xo]\u0005\u0003]-\u0012a\"\u00119q'R\fG/^:Ti>\u0014X-\u0001\u0004=S:LGO\u0010\u000b\u0004cI\u001a\u0004CA\u0013\u0001\u0011\u0015\u00113\u00011\u0001%\u0011\u0015A3\u00011\u0001*\u0003A!\u0016*T#M\u0013:+u,\u0012(B\u00052+E)F\u00017!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u001d\u0011un\u001c7fC:\f\u0011\u0003V%N\u000b2Ke*R0F\u001d\u0006\u0013E*\u0012#!\u0003Mi\u0015\tW0U\u00136+E*\u0013(F?N#\u0016iR#T+\u0005y\u0004CA\u001cA\u0013\t\t\u0005HA\u0002J]R\fA#T!Y?RKU*\u0012'J\u001d\u0016{6\u000bV!H\u000bN\u0003\u0013AF'B1~#\u0016*T#M\u0013:+u,\u0012-F\u0007V#vJU*\u0002/5\u000b\u0005l\u0018+J\u001b\u0016c\u0015JT#`\u000bb+5)\u0016+P%N\u0003\u0013!D*U\u0003\u001e+5k\u0018'F\u000f\u0016sE)F\u0001H!\tAuJ\u0004\u0002J\u001bB\u0011!\nO\u0007\u0002\u0017*\u0011AjI\u0001\u0007yI|w\u000e\u001e \n\u00059C\u0014A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!A\u0014\u001d\u0002\u001dM#\u0016iR#T?2+u)\u0012(EA\u0005\u0001R\tW#D+R{%kU0M\u000b\u001e+e\nR\u0001\u0012\u000bb+5)\u0016+P%N{F*R$F\u001d\u0012\u0003\u0013AD7bW\u0016\u001cF/Y4f\u000bZ,g\u000e\u001e\u000b\u0003/\u0002\u00042\u0001W/H\u001d\tI6L\u0004\u0002K5&\t\u0011(\u0003\u0002]q\u00059\u0001/Y2lC\u001e,\u0017B\u00010`\u0005\r\u0019V-\u001d\u0006\u00039bBQ!\u0019\bA\u0002\t\f!b\u001d;bO\u0016LeNZ8t!\rAVl\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\f!A^\u0019\u000b\u0005!\\\u0013aA1qS&\u0011!.\u001a\u0002\n'R\fw-\u001a#bi\u0006\f\u0011#\\1lK\u0016CXmY;u_J,e/\u001a8u)\t9V\u000eC\u0003o\u001f\u0001\u0007q.A\u0005fq\u0016\u001cW\u000f^8sgB\u0019\u0001,\u00189\u0011\u0005\u0011\f\u0018B\u0001:f\u0005=)\u00050Z2vi>\u00148+^7nCJL\u0018\u0001D7bW\u0016$\u0016.\\3mS:,G\u0003B;}}~\u00042\u0001W/w!\t9(0D\u0001y\u0015\tI\b(A\u0002y[2L!a\u001f=\u0003\t9{G-\u001a\u0005\u0006{B\u0001\rAY\u0001\u0007gR\fw-Z:\t\u000b9\u0004\u0002\u0019A8\t\u000f\u0005\u0005\u0001\u00031\u0001\u0002\u0004\u0005a\u0011\r\u001d9Ti\u0006\u0014H\u000fV5nKB\u0019q'!\u0002\n\u0007\u0005\u001d\u0001H\u0001\u0003M_:<\u0017A\u0002:f]\u0012,'\u000fF\u0002v\u0003\u001bAq!a\u0004\u0012\u0001\u0004\t\t\"A\u0004sKF,Xm\u001d;\u0011\t\u0005M\u0011\u0011E\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005!\u0001\u000e\u001e;q\u0015\u0011\tY\"!\b\u0002\u000fM,'O\u001e7fi*\u0011\u0011qD\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003G\t)B\u0001\nIiR\u00048+\u001a:wY\u0016$(+Z9vKN$\b")
public class JobPage
extends WebUIPage {
    private final JobsTab parent;
    private final AppStatusStore store;
    private final boolean TIMELINE_ENABLED;
    private final int MAX_TIMELINE_STAGES;
    private final int MAX_TIMELINE_EXECUTORS;
    private final String STAGES_LEGEND;
    private final String EXECUTORS_LEGEND;

    private boolean TIMELINE_ENABLED() {
        return this.TIMELINE_ENABLED;
    }

    private int MAX_TIMELINE_STAGES() {
        return this.MAX_TIMELINE_STAGES;
    }

    private int MAX_TIMELINE_EXECUTORS() {
        return this.MAX_TIMELINE_EXECUTORS;
    }

    private String STAGES_LEGEND() {
        return this.STAGES_LEGEND;
    }

    private String EXECUTORS_LEGEND() {
        return this.EXECUTORS_LEGEND;
    }

    private scala.collection.immutable.Seq<String> makeStageEvent(scala.collection.immutable.Seq<StageData> stageInfos) {
        long now = System.currentTimeMillis();
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)stageInfos.sortBy((Function1 & Serializable)s -> new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)s.completionTime().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> now)), ((Date)s.submissionTime().get()).getTime()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$))).takeRight(this.MAX_TIMELINE_STAGES())).map((Function1 & Serializable)stage -> {
            int stageId = stage.stageId();
            int attemptId = stage.attemptId();
            String name = stage.name();
            String status = stage.status().toString().toLowerCase(Locale.ROOT);
            long submissionTime = ((Date)stage.submissionTime().get()).getTime();
            long completionTime = BoxesRunTime.unboxToLong((Object)stage.completionTime().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> now));
            String escapedName = Utility$.MODULE$.escape(name);
            String jsEscapedNameForTooltip = StringEscapeUtils.escapeEcmaScript((String)Utility$.MODULE$.escape(escapedName));
            String jsEscapedNameForLabel = StringEscapeUtils.escapeEcmaScript((String)escapedName);
            String string = status;
            String string2 = "running";
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(477).append("\n         |{\n         |  'className': 'stage job-timeline-object ").append(status).append("',\n         |  'group': 'stages',\n         |  'start': new Date(").append(submissionTime).append("),\n         |  'end': new Date(").append(completionTime).append("),\n         |  'content': '<div class=\"job-timeline-content\" data-toggle=\"tooltip\"' +\n         |   'data-placement=\"top\" data-html=\"true\"' +\n         |   'data-title=\"").append(jsEscapedNameForTooltip).append(" (Stage ").append(stageId).append(".").append(attemptId).append(")<br>' +\n         |   'Status: ").append(status.toUpperCase(Locale.ROOT)).append("<br>' +\n         |   'Submitted: ").append(UIUtils$.MODULE$.formatDate(submissionTime)).append("' +\n         |   '").append((Object)((string == null ? string2 != null : !string.equals(string2)) ? new StringBuilder(15).append("<br>Completed: ").append(UIUtils$.MODULE$.formatDate(completionTime)).toString() : "")).append("\">' +\n         |    '").append(jsEscapedNameForLabel).append(" (Stage ").append(stageId).append(".").append(attemptId).append(")</div>',\n         |}\n       ").toString()));
        });
    }

    public scala.collection.immutable.Seq<String> makeExecutorEvent(scala.collection.immutable.Seq<ExecutorSummary> executors) {
        ListBuffer events = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((IterableOnceOps)((IterableOps)executors.sortBy((Function1 & Serializable)e -> BoxesRunTime.boxToLong((long)JobPage.$anonfun$makeExecutorEvent$1(e)), (Ordering)Ordering.Long$.MODULE$)).takeRight(this.MAX_TIMELINE_EXECUTORS())).foreach((Function1 & Serializable)e -> {
            JobPage.$anonfun$makeExecutorEvent$4(events, e);
            return BoxedUnit.UNIT;
        });
        return events.toSeq();
    }

    private scala.collection.immutable.Seq<Node> makeTimeline(scala.collection.immutable.Seq<StageData> stages, scala.collection.immutable.Seq<ExecutorSummary> executors, long appStartTime) {
        Elem elem;
        Elem elem2;
        if (!this.TIMELINE_ENABLED()) {
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        }
        scala.collection.immutable.Seq<String> stageEventJsonAsStrSeq = this.makeStageEvent(stages);
        scala.collection.immutable.Seq<String> executorsJsonAsStrSeq = this.makeExecutorEvent(executors);
        String groupJsonArrayAsStr = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(258).append("\n          |[\n          |  {\n          |    'id': 'executors',\n          |    'content': '<div>Executors</div>").append(this.EXECUTORS_LEGEND()).append("',\n          |  },\n          |  {\n          |    'id': 'stages',\n          |    'content': '<div>Stages</div>").append(this.STAGES_LEGEND()).append("',\n          |  }\n          |]\n        ").toString()));
        String eventArrayAsStr = ((IterableOnceOps)stageEventJsonAsStrSeq.$plus$plus(executorsJsonAsStrSeq)).mkString("[", ",", "]");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-job-timeline"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("expand-job-timeline-arrow arrow-closed"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("data-placement", (Seq)new Text("top"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("title", ToolTips$.MODULE$.STAGE_TIMELINE(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md3);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        Event Timeline\n      "));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        Elem elem3 = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("collapsed"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("id", (Seq)new Text("job-timeline"), (MetaData)$md4);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n      "));
        if (this.MAX_TIMELINE_STAGES() < stages.size()) {
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n            Only the most recent "));
            $buf5.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.MAX_TIMELINE_STAGES()));
            $buf5.$amp$plus((Object)new Text(" submitted/completed stages\n            (of "));
            $buf5.$amp$plus((Object)BoxesRunTime.boxToInteger((int)stages.size()));
            $buf5.$amp$plus((Object)new Text(" total) are shown.\n          "));
            $buf4.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf4.$amp$plus((Object)new Text("\n        "));
            Elem elem4 = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4));
            elem2 = elem4;
        } else {
            elem2 = package$.MODULE$.Seq().empty();
        }
        $buf3.$amp$plus((Object)elem2);
        $buf3.$amp$plus((Object)new Text("\n      "));
        if (this.MAX_TIMELINE_EXECUTORS() < executors.size()) {
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n            Only the most recent "));
            $buf7.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.MAX_TIMELINE_EXECUTORS()));
            $buf7.$amp$plus((Object)new Text(" added/removed executors\n            (of "));
            $buf7.$amp$plus((Object)BoxesRunTime.boxToInteger((int)executors.size()));
            $buf7.$amp$plus((Object)new Text(" total) are shown.\n          "));
            $buf6.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
            $buf6.$amp$plus((Object)new Text("\n        "));
            Elem elem5 = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6));
            elem = elem5;
        } else {
            elem = package$.MODULE$.Seq().empty();
        }
        $buf3.$amp$plus((Object)elem);
        $buf3.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("control-panel"), (MetaData)$md5);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("id", (Seq)new Text("job-timeline-zoom-lock"), (MetaData)$md6);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n          "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md7);
        $buf9.$amp$plus((Object)new Elem(null, "input", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf9.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Enable zooming"));
        $buf9.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf9.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf3.$amp$plus((Object)new Text("\n    "));
        NodeSeq nodeSeq = elem3.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md8);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n      "));
        $buf11.$amp$plus((Object)Unparsed$.MODULE$.apply(new StringBuilder(0).append(new StringBuilder(20).append("drawJobTimeline(").append(groupJsonArrayAsStr).append(", ").append(eventArrayAsStr).append(", ").toString()).append(new StringBuilder(4).append(appStartTime).append(", ").append(UIUtils$.MODULE$.getTimeZoneOffset()).append(");").toString()).toString()));
        $buf11.$amp$plus((Object)new Text("\n    "));
        return nodeSeq.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "script", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
    }

    @Override
    public scala.collection.immutable.Seq<Node> render(HttpServletRequest request) {
        scala.collection.immutable.Seq<Node> seq;
        Object object = new Object();
        try {
            Elem elem;
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            BoxedUnit boxedUnit5;
            BoxedUnit boxedUnit6;
            BoxedUnit boxedUnit7;
            String parameterId = request.getParameter("id");
            Predef$.MODULE$.require(parameterId != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(parameterId)), (Function0 & Serializable)() -> "Missing id parameter");
            int jobId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(parameterId));
            Tuple2 tuple2 = (Tuple2)this.store.asOption((Function0 & Serializable)() -> $this.store.jobWithAssociatedSql(jobId)).getOrElse((Function0 & Serializable)() -> {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("id", (Seq)new Text("no-info"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("No information to display for job "));
                $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)jobId));
                $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
                $buf.$amp$plus((Object)new Text("\n        "));
                Elem content = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
                throw new NonLocalReturnControl(object, UIUtils$.MODULE$.headerSparkPage(request, new StringBuilder(16).append("Details for Job ").append(jobId).toString(), (Function0<scala.collection.immutable.Seq<Node>>)(Function0 & Serializable)() -> content, $this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7()));
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            JobData jobData = (JobData)tuple2._1();
            Option sqlExecutionId = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)jobData, (Object)sqlExecutionId);
            Tuple2 tuple23 = tuple22;
            JobData jobData2 = (JobData)tuple23._1();
            Option sqlExecutionId2 = (Option)tuple23._2();
            JobExecutionStatus jobExecutionStatus = jobData2.status();
            JobExecutionStatus jobExecutionStatus2 = JobExecutionStatus.RUNNING;
            boolean isComplete = jobExecutionStatus == null ? jobExecutionStatus2 != null : !((Object)((Object)jobExecutionStatus)).equals((Object)jobExecutionStatus2);
            Seq stages = (Seq)jobData2.stageIds().map((Function1 & Serializable)stageId -> JobPage.$anonfun$render$5(this, BoxesRunTime.unboxToInt((Object)stageId)));
            Buffer activeStages = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            Buffer completedStages = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            Buffer pendingOrSkippedStages = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            Buffer failedStages = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            stages.foreach((Function1 & Serializable)stage -> {
                Buffer buffer;
                if (stage.submissionTime().isEmpty()) {
                    buffer = (Buffer)pendingOrSkippedStages.$plus$eq(stage);
                } else if (stage.completionTime().isDefined()) {
                    StageStatus stageStatus = stage.status();
                    StageStatus stageStatus2 = StageStatus.FAILED;
                    buffer = !(stageStatus != null ? !((Object)((Object)stageStatus)).equals((Object)stageStatus2) : stageStatus2 != null) ? (Buffer)failedStages.$plus$eq(stage) : (Buffer)completedStages.$plus$eq(stage);
                } else {
                    buffer = (Buffer)activeStages.$plus$eq(stage);
                }
                return buffer;
            });
            String basePath = "jobs/job";
            String pendingOrSkippedTableId = isComplete ? "skipped" : "pending";
            StageTableBase activeStagesTable = new StageTableBase(this.store, request, (scala.collection.immutable.Seq<StageData>)activeStages.toSeq(), "active", "activeStage", this.parent.basePath(), basePath, this.parent.isFairScheduler(), this.parent.killEnabled(), false);
            StageTableBase pendingOrSkippedStagesTable = new StageTableBase(this.store, request, (scala.collection.immutable.Seq<StageData>)pendingOrSkippedStages.toSeq(), pendingOrSkippedTableId, "pendingStage", this.parent.basePath(), basePath, this.parent.isFairScheduler(), false, false);
            StageTableBase completedStagesTable = new StageTableBase(this.store, request, (scala.collection.immutable.Seq<StageData>)completedStages.toSeq(), "completed", "completedStage", this.parent.basePath(), basePath, this.parent.isFairScheduler(), false, false);
            StageTableBase failedStagesTable = new StageTableBase(this.store, request, (scala.collection.immutable.Seq<StageData>)failedStages.toSeq(), "failed", "failedStage", this.parent.basePath(), basePath, this.parent.isFairScheduler(), false, true);
            boolean shouldShowActiveStages = activeStages.nonEmpty();
            boolean shouldShowPendingStages = !isComplete && pendingOrSkippedStages.nonEmpty();
            boolean shouldShowCompletedStages = completedStages.nonEmpty();
            boolean shouldShowSkippedStages = isComplete && pendingOrSkippedStages.nonEmpty();
            boolean shouldShowFailedStages = failedStages.nonEmpty();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("list-unstyled"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("Status:"));
            $buf3.$amp$plus((Object)new Elem(null, "Strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)jobData2.status());
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("Submitted:"));
            $buf5.$amp$plus((Object)new Elem(null, "Strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
            $buf5.$amp$plus((Object)new Text("\n            "));
            $buf5.$amp$plus((Object)JobDataUtil$.MODULE$.getFormattedSubmissionTime(jobData2));
            $buf5.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("Duration:"));
            $buf7.$amp$plus((Object)new Elem(null, "Strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
            $buf7.$amp$plus((Object)new Text("\n            "));
            $buf7.$amp$plus((Object)JobDataUtil$.MODULE$.getFormattedDuration(jobData2));
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (sqlExecutionId2.isDefined()) {
                NodeBuffer $buf9 = new NodeBuffer();
                $buf9.$amp$plus((Object)new Text("\n                "));
                NodeBuffer $buf10 = new NodeBuffer();
                $buf10.$amp$plus((Object)new Text("Associated SQL Query: "));
                $buf9.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
                $buf9.$amp$plus((Object)new Text("\n                "));
                Null$ $md2 = Null$.MODULE$;
                $md2 = new UnprefixedAttribute("href", StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s/SQL/execution/?id=%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), sqlExecutionId2.get()})), (MetaData)$md2);
                NodeBuffer $buf11 = new NodeBuffer();
                $buf11.$amp$plus(sqlExecutionId2.get());
                $buf9.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
                $buf9.$amp$plus((Object)new Text("\n              "));
                Elem elem2 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9));
                boxedUnit7 = elem2;
            } else {
                boxedUnit7 = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit7);
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (jobData2.jobGroup().isDefined()) {
                NodeBuffer $buf12 = new NodeBuffer();
                $buf12.$amp$plus((Object)new Text("\n                "));
                NodeBuffer $buf13 = new NodeBuffer();
                $buf13.$amp$plus((Object)new Text("Job Group:"));
                $buf12.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
                $buf12.$amp$plus((Object)new Text("\n                "));
                $buf12.$amp$plus(jobData2.jobGroup().get());
                $buf12.$amp$plus((Object)new Text("\n              "));
                Elem elem3 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12));
                boxedUnit6 = elem3;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit6);
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (shouldShowActiveStages) {
                NodeBuffer $buf14 = new NodeBuffer();
                $buf14.$amp$plus((Object)new Text("\n                "));
                Null$ $md3 = Null$.MODULE$;
                $md3 = new UnprefixedAttribute("href", (Seq)new Text("#active"), (MetaData)$md3);
                NodeBuffer $buf15 = new NodeBuffer();
                NodeBuffer $buf16 = new NodeBuffer();
                $buf16.$amp$plus((Object)new Text("Active Stages:"));
                $buf15.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
                $buf14.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
                $buf14.$amp$plus((Object)new Text("\n                "));
                $buf14.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeStages.size()));
                $buf14.$amp$plus((Object)new Text("\n              "));
                Elem elem4 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14));
                boxedUnit5 = elem4;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit5);
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (shouldShowPendingStages) {
                NodeBuffer $buf17 = new NodeBuffer();
                $buf17.$amp$plus((Object)new Text("\n                "));
                Null$ $md4 = Null$.MODULE$;
                $md4 = new UnprefixedAttribute("href", (Seq)new Text("#pending"), (MetaData)$md4);
                NodeBuffer $buf18 = new NodeBuffer();
                $buf18.$amp$plus((Object)new Text("\n                  "));
                NodeBuffer $buf19 = new NodeBuffer();
                $buf19.$amp$plus((Object)new Text("Pending Stages:"));
                $buf18.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf19)));
                $buf18.$amp$plus((Object)new Text("\n                "));
                $buf17.$amp$plus((Object)new Elem(null, "a", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf18)));
                $buf17.$amp$plus((Object)BoxesRunTime.boxToInteger((int)pendingOrSkippedStages.size()));
                $buf17.$amp$plus((Object)new Text("\n              "));
                Elem elem5 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf17));
                boxedUnit4 = elem5;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit4);
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (shouldShowCompletedStages) {
                NodeBuffer $buf20 = new NodeBuffer();
                $buf20.$amp$plus((Object)new Text("\n                "));
                Null$ $md5 = Null$.MODULE$;
                $md5 = new UnprefixedAttribute("href", (Seq)new Text("#completed"), (MetaData)$md5);
                NodeBuffer $buf21 = new NodeBuffer();
                NodeBuffer $buf22 = new NodeBuffer();
                $buf22.$amp$plus((Object)new Text("Completed Stages:"));
                $buf21.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf22)));
                $buf20.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf21)));
                $buf20.$amp$plus((Object)new Text("\n                "));
                $buf20.$amp$plus((Object)BoxesRunTime.boxToInteger((int)completedStages.size()));
                $buf20.$amp$plus((Object)new Text("\n              "));
                Elem elem6 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf20));
                boxedUnit3 = elem6;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit3);
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (shouldShowSkippedStages) {
                NodeBuffer $buf23 = new NodeBuffer();
                $buf23.$amp$plus((Object)new Text("\n              "));
                Null$ $md6 = Null$.MODULE$;
                $md6 = new UnprefixedAttribute("href", (Seq)new Text("#skipped"), (MetaData)$md6);
                NodeBuffer $buf24 = new NodeBuffer();
                NodeBuffer $buf25 = new NodeBuffer();
                $buf25.$amp$plus((Object)new Text("Skipped Stages:"));
                $buf24.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf25)));
                $buf23.$amp$plus((Object)new Elem(null, "a", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf24)));
                $buf23.$amp$plus((Object)new Text("\n              "));
                $buf23.$amp$plus((Object)BoxesRunTime.boxToInteger((int)pendingOrSkippedStages.size()));
                $buf23.$amp$plus((Object)new Text("\n            "));
                Elem elem7 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf23));
                boxedUnit2 = elem7;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit2);
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (shouldShowFailedStages) {
                NodeBuffer $buf26 = new NodeBuffer();
                $buf26.$amp$plus((Object)new Text("\n                "));
                Null$ $md7 = Null$.MODULE$;
                $md7 = new UnprefixedAttribute("href", (Seq)new Text("#failed"), (MetaData)$md7);
                NodeBuffer $buf27 = new NodeBuffer();
                NodeBuffer $buf28 = new NodeBuffer();
                $buf28.$amp$plus((Object)new Text("Failed Stages:"));
                $buf27.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf28)));
                $buf26.$amp$plus((Object)new Elem(null, "a", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf27)));
                $buf26.$amp$plus((Object)new Text("\n                "));
                $buf26.$amp$plus((Object)BoxesRunTime.boxToInteger((int)failedStages.size()));
                $buf26.$amp$plus((Object)new Text("\n              "));
                Elem elem8 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf26));
                boxedUnit = elem8;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit);
            $buf2.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem summary = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
            ObjectRef content = ObjectRef.create((Object)summary);
            long appStartTime = ((ApplicationAttemptInfo)this.store.applicationInfo().attempts().head()).startTime().getTime();
            content.elem = ((NodeSeq)content.elem).$plus$plus(this.makeTimeline((scala.collection.immutable.Seq<StageData>)((IterableOnceOps)((IterableOps)activeStages.$plus$plus((IterableOnce)completedStages)).$plus$plus((IterableOnce)failedStages)).toSeq(), this.store.executorList(false), appStartTime));
            Option option = this.store.asOption((Function0 & Serializable)() -> $this.store.operationGraphForJob(jobId));
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq operationGraph = (Seq)some.value();
                elem = UIUtils$.MODULE$.showDagVizForJob(jobId, (Seq<RDDOperationGraph>)operationGraph);
            } else if (None$.MODULE$.equals(option)) {
                Null$ $md8 = Null$.MODULE$;
                $md8 = new UnprefixedAttribute("id", (Seq)new Text("no-info"), (MetaData)$md8);
                NodeBuffer $buf29 = new NodeBuffer();
                $buf29.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf30 = new NodeBuffer();
                $buf30.$amp$plus((Object)new Text("No DAG visualization information to display for job "));
                $buf30.$amp$plus((Object)BoxesRunTime.boxToInteger((int)jobId));
                $buf29.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf30)));
                $buf29.$amp$plus((Object)new Text("\n        "));
                elem = new Elem(null, "div", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf29));
            } else {
                throw new MatchError(option);
            }
            Elem operationGraphContent = elem;
            content.elem = NodeSeq$.MODULE$.seqToNodeSeq((Seq)((NodeSeq)content.elem).$plus$plus(operationGraphContent));
            if (shouldShowActiveStages) {
                NodeSeq nodeSeq = (NodeSeq)content.elem;
                Null$ $md9 = Null$.MODULE$;
                $md9 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-activeStages','aggregated-activeStages')"), (MetaData)$md9);
                $md9 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-activeStages collapse-table"), (MetaData)$md9);
                $md9 = new UnprefixedAttribute("id", (Seq)new Text("active"), (MetaData)$md9);
                NodeBuffer $buf31 = new NodeBuffer();
                $buf31.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf32 = new NodeBuffer();
                $buf32.$amp$plus((Object)new Text("\n            "));
                Null$ $md10 = Null$.MODULE$;
                $md10 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md10);
                $buf32.$amp$plus((Object)new Elem(null, "span", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
                $buf32.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf33 = new NodeBuffer();
                $buf33.$amp$plus((Object)new Text("Active Stages ("));
                $buf33.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeStages.size()));
                $buf33.$amp$plus((Object)new Text(")"));
                $buf32.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf33)));
                $buf32.$amp$plus((Object)new Text("\n          "));
                $buf31.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf32)));
                $buf31.$amp$plus((Object)new Text("\n        "));
                Elem elem9 = new Elem(null, "span", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf31));
                Null$ $md11 = Null$.MODULE$;
                $md11 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-activeStages collapsible-table"), (MetaData)$md11);
                NodeBuffer $buf34 = new NodeBuffer();
                $buf34.$amp$plus((Object)new Text("\n          "));
                $buf34.$amp$plus(activeStagesTable.toNodeSeq());
                $buf34.$amp$plus((Object)new Text("\n        "));
                content.elem = nodeSeq.$plus$plus((scala.collection.immutable.Seq)elem9.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf34))));
            }
            if (shouldShowPendingStages) {
                NodeSeq nodeSeq = (NodeSeq)content.elem;
                Null$ $md12 = Null$.MODULE$;
                $md12 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-pendingOrSkippedStages',\n            'aggregated-pendingOrSkippedStages')"), (MetaData)$md12);
                $md12 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-pendingOrSkippedStages collapse-table"), (MetaData)$md12);
                $md12 = new UnprefixedAttribute("id", (Seq)new Text("pending"), (MetaData)$md12);
                NodeBuffer $buf35 = new NodeBuffer();
                $buf35.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf36 = new NodeBuffer();
                $buf36.$amp$plus((Object)new Text("\n            "));
                Null$ $md13 = Null$.MODULE$;
                $md13 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md13);
                $buf36.$amp$plus((Object)new Elem(null, "span", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
                $buf36.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf37 = new NodeBuffer();
                $buf37.$amp$plus((Object)new Text("Pending Stages ("));
                $buf37.$amp$plus((Object)BoxesRunTime.boxToInteger((int)pendingOrSkippedStages.size()));
                $buf37.$amp$plus((Object)new Text(")"));
                $buf36.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf37)));
                $buf36.$amp$plus((Object)new Text("\n          "));
                $buf35.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf36)));
                $buf35.$amp$plus((Object)new Text("\n        "));
                Elem elem10 = new Elem(null, "span", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf35));
                Null$ $md14 = Null$.MODULE$;
                $md14 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-pendingOrSkippedStages collapsible-table"), (MetaData)$md14);
                NodeBuffer $buf38 = new NodeBuffer();
                $buf38.$amp$plus((Object)new Text("\n          "));
                $buf38.$amp$plus(pendingOrSkippedStagesTable.toNodeSeq());
                $buf38.$amp$plus((Object)new Text("\n        "));
                content.elem = nodeSeq.$plus$plus((scala.collection.immutable.Seq)elem10.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf38))));
            }
            if (shouldShowCompletedStages) {
                NodeSeq nodeSeq = (NodeSeq)content.elem;
                Null$ $md15 = Null$.MODULE$;
                $md15 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-completedStages',\n            'aggregated-completedStages')"), (MetaData)$md15);
                $md15 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-completedStages collapse-table"), (MetaData)$md15);
                $md15 = new UnprefixedAttribute("id", (Seq)new Text("completed"), (MetaData)$md15);
                NodeBuffer $buf39 = new NodeBuffer();
                $buf39.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf40 = new NodeBuffer();
                $buf40.$amp$plus((Object)new Text("\n            "));
                Null$ $md16 = Null$.MODULE$;
                $md16 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md16);
                $buf40.$amp$plus((Object)new Elem(null, "span", (MetaData)$md16, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
                $buf40.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf41 = new NodeBuffer();
                $buf41.$amp$plus((Object)new Text("Completed Stages ("));
                $buf41.$amp$plus((Object)BoxesRunTime.boxToInteger((int)completedStages.size()));
                $buf41.$amp$plus((Object)new Text(")"));
                $buf40.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf41)));
                $buf40.$amp$plus((Object)new Text("\n          "));
                $buf39.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf40)));
                $buf39.$amp$plus((Object)new Text("\n        "));
                Elem elem11 = new Elem(null, "span", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf39));
                Null$ $md17 = Null$.MODULE$;
                $md17 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-completedStages collapsible-table"), (MetaData)$md17);
                NodeBuffer $buf42 = new NodeBuffer();
                $buf42.$amp$plus((Object)new Text("\n          "));
                $buf42.$amp$plus(completedStagesTable.toNodeSeq());
                $buf42.$amp$plus((Object)new Text("\n        "));
                content.elem = nodeSeq.$plus$plus((scala.collection.immutable.Seq)elem11.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md17, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf42))));
            }
            if (shouldShowSkippedStages) {
                NodeSeq nodeSeq = (NodeSeq)content.elem;
                Null$ $md18 = Null$.MODULE$;
                $md18 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-pendingOrSkippedStages',\n            'aggregated-pendingOrSkippedStages')"), (MetaData)$md18);
                $md18 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-pendingOrSkippedStages collapse-table"), (MetaData)$md18);
                $md18 = new UnprefixedAttribute("id", (Seq)new Text("skipped"), (MetaData)$md18);
                NodeBuffer $buf43 = new NodeBuffer();
                $buf43.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf44 = new NodeBuffer();
                $buf44.$amp$plus((Object)new Text("\n            "));
                Null$ $md19 = Null$.MODULE$;
                $md19 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md19);
                $buf44.$amp$plus((Object)new Elem(null, "span", (MetaData)$md19, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
                $buf44.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf45 = new NodeBuffer();
                $buf45.$amp$plus((Object)new Text("Skipped Stages ("));
                $buf45.$amp$plus((Object)BoxesRunTime.boxToInteger((int)pendingOrSkippedStages.size()));
                $buf45.$amp$plus((Object)new Text(")"));
                $buf44.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf45)));
                $buf44.$amp$plus((Object)new Text("\n          "));
                $buf43.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf44)));
                $buf43.$amp$plus((Object)new Text("\n        "));
                Elem elem12 = new Elem(null, "span", (MetaData)$md18, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf43));
                Null$ $md20 = Null$.MODULE$;
                $md20 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-pendingOrSkippedStages collapsible-table"), (MetaData)$md20);
                NodeBuffer $buf46 = new NodeBuffer();
                $buf46.$amp$plus((Object)new Text("\n          "));
                $buf46.$amp$plus(pendingOrSkippedStagesTable.toNodeSeq());
                $buf46.$amp$plus((Object)new Text("\n        "));
                content.elem = nodeSeq.$plus$plus((scala.collection.immutable.Seq)elem12.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md20, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf46))));
            }
            if (shouldShowFailedStages) {
                NodeSeq nodeSeq = (NodeSeq)content.elem;
                Null$ $md21 = Null$.MODULE$;
                $md21 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-failedStages','aggregated-failedStages')"), (MetaData)$md21);
                $md21 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-failedStages collapse-table"), (MetaData)$md21);
                $md21 = new UnprefixedAttribute("id", (Seq)new Text("failed"), (MetaData)$md21);
                NodeBuffer $buf47 = new NodeBuffer();
                $buf47.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf48 = new NodeBuffer();
                $buf48.$amp$plus((Object)new Text("\n            "));
                Null$ $md22 = Null$.MODULE$;
                $md22 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md22);
                $buf48.$amp$plus((Object)new Elem(null, "span", (MetaData)$md22, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
                $buf48.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf49 = new NodeBuffer();
                $buf49.$amp$plus((Object)new Text("Failed Stages ("));
                $buf49.$amp$plus((Object)BoxesRunTime.boxToInteger((int)failedStages.size()));
                $buf49.$amp$plus((Object)new Text(")"));
                $buf48.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf49)));
                $buf48.$amp$plus((Object)new Text("\n          "));
                $buf47.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf48)));
                $buf47.$amp$plus((Object)new Text("\n        "));
                Elem elem13 = new Elem(null, "span", (MetaData)$md21, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf47));
                Null$ $md23 = Null$.MODULE$;
                $md23 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-failedStages collapsible-table"), (MetaData)$md23);
                NodeBuffer $buf50 = new NodeBuffer();
                $buf50.$amp$plus((Object)new Text("\n          "));
                $buf50.$amp$plus(failedStagesTable.toNodeSeq());
                $buf50.$amp$plus((Object)new Text("\n        "));
                content.elem = nodeSeq.$plus$plus((scala.collection.immutable.Seq)elem13.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md23, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf50))));
            }
            HttpServletRequest x$1 = request;
            String x$2 = new StringBuilder(16).append("Details for Job ").append(jobId).toString();
            Function0 & Serializable x$3 = (Function0 & Serializable)() -> (NodeSeq)content$2.elem;
            JobsTab x$4 = this.parent;
            boolean x$5 = true;
            Option<String> x$6 = UIUtils$.MODULE$.headerSparkPage$default$5();
            boolean x$7 = UIUtils$.MODULE$.headerSparkPage$default$7();
            seq = UIUtils$.MODULE$.headerSparkPage(x$1, x$2, (Function0<scala.collection.immutable.Seq<Node>>)x$3, x$4, x$6, true, x$7);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (scala.collection.immutable.Seq<Node>)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    public static final /* synthetic */ boolean $anonfun$STAGES_LEGEND$1(char x$1) {
        return x$1 != '\n';
    }

    public static final /* synthetic */ boolean $anonfun$EXECUTORS_LEGEND$1(char x$2) {
        return x$2 != '\n';
    }

    public static final /* synthetic */ long $anonfun$makeExecutorEvent$1(ExecutorSummary e) {
        return BoxesRunTime.unboxToLong((Object)e.removeTime().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> e.addTime().getTime()));
    }

    public static final /* synthetic */ void $anonfun$makeExecutorEvent$4(ListBuffer events$1, ExecutorSummary e) {
        String addedEvent = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(416).append("\n           |{\n           |  'className': 'executor added',\n           |  'group': 'executors',\n           |  'start': new Date(").append(e.addTime().getTime()).append("),\n           |  'content': '<div class=\"executor-event-content\"' +\n           |    'data-toggle=\"tooltip\" data-placement=\"top\"' +\n           |    'data-title=\"Executor ").append(e.id()).append("<br>' +\n           |    'Added at ").append(UIUtils$.MODULE$.formatDate(e.addTime())).append("\"' +\n           |    'data-html=\"true\">Executor ").append(e.id()).append(" added</div>'\n           |}\n         ").toString()));
        events$1.$plus$eq((Object)addedEvent);
        e.removeTime().foreach((Function1 & Serializable)removeTime -> {
            String removedEvent = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(467).append("\n             |{\n             |  'className': 'executor removed',\n             |  'group': 'executors',\n             |  'start': new Date(").append(removeTime.getTime()).append("),\n             |  'content': '<div class=\"executor-event-content\"' +\n             |    'data-toggle=\"tooltip\" data-placement=\"top\"' +\n             |    'data-title=\"Executor ").append(e.id()).append("<br>' +\n             |    'Removed at ").append(UIUtils$.MODULE$.formatDate((Date)removeTime)).append("' +\n             |    '").append(e.removeReason().map((Function1 & Serializable)reason -> new StringBuilder(12).append("<br>Reason: ").append(StringEscapeUtils.escapeEcmaScript((String)reason.replace("\n", " "))).toString()).getOrElse((Function0 & Serializable)() -> "")).append("\"' +\n             |    'data-html=\"true\">Executor ").append(e.id()).append(" removed</div>'\n             |}\n           ").toString()));
            return (ListBuffer)events$1.$plus$eq((Object)removedEvent);
        });
    }

    public static final /* synthetic */ StageData $anonfun$render$5(JobPage $this, int stageId) {
        return (StageData)$this.store.asOption((Function0 & Serializable)() -> $this.store.lastStageAttempt(stageId)).getOrElse((Function0 & Serializable)() -> new StageData(StageStatus.PENDING, stageId, 0, 0, 0, 0, 0, 0, 0, (Option<Date>)None$.MODULE$, (Option<Date>)None$.MODULE$, (Option<Date>)None$.MODULE$, (Option<String>)None$.MODULE$, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, "Unknown", (Option<String>)None$.MODULE$, "Unknown", null, (Seq<Object>)package$.MODULE$.Nil(), (Seq<AccumulableInfo>)package$.MODULE$.Nil(), (Option<Map<Object, TaskData>>)None$.MODULE$, (Option<Map<String, ExecutorStageSummary>>)None$.MODULE$, (Option<SpeculationStageSummary>)None$.MODULE$, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), ResourceProfile$.MODULE$.UNKNOWN_RESOURCE_PROFILE_ID(), (Option<ExecutorMetrics>)None$.MODULE$, (Option<TaskMetricDistributions>)None$.MODULE$, (Option<ExecutorMetricsDistributions>)None$.MODULE$, false, 0));
    }

    public JobPage(JobsTab parent, AppStatusStore store) {
        this.parent = parent;
        this.store = store;
        super("job");
        this.TIMELINE_ENABLED = BoxesRunTime.unboxToBoolean((Object)parent.conf().get(UI$.MODULE$.UI_TIMELINE_ENABLED()));
        this.MAX_TIMELINE_STAGES = BoxesRunTime.unboxToInt((Object)parent.conf().get(UI$.MODULE$.UI_TIMELINE_STAGES_MAXIMUM()));
        this.MAX_TIMELINE_EXECUTORS = BoxesRunTime.unboxToInt((Object)parent.conf().get(UI$.MODULE$.UI_TIMELINE_EXECUTORS_MAXIMUM()));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("height", (Seq)new Text("85px"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("width", (Seq)new Text("150px"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("y", (Seq)new Text("5px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("completed-stage-legend"), (MetaData)$md3);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("y", (Seq)new Text("17px"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md4);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Completed"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("y", (Seq)new Text("30px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("failed-stage-legend"), (MetaData)$md5);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("y", (Seq)new Text("42px"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md6);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Failed"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("y", (Seq)new Text("55px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("active-stage-legend"), (MetaData)$md7);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("y", (Seq)new Text("67px"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md8);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Active"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "svg", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        this.STAGES_LEGEND = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)).toString()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JobPage.$anonfun$STAGES_LEGEND$1(BoxesRunTime.unboxToChar((Object)x$1))));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md9);
        NodeBuffer $buf6 = new NodeBuffer();
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("height", (Seq)new Text("55px"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("width", (Seq)new Text("150px"), (MetaData)$md10);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("y", (Seq)new Text("5px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("executor-added-legend"), (MetaData)$md11);
        $buf7.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("y", (Seq)new Text("17px"), (MetaData)$md12);
        $md12 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md12);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Added"));
        $buf7.$amp$plus((Object)new Elem(null, "text", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("y", (Seq)new Text("30px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("class", (Seq)new Text("executor-removed-legend"), (MetaData)$md13);
        $buf7.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("y", (Seq)new Text("42px"), (MetaData)$md14);
        $md14 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md14);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Removed"));
        $buf7.$amp$plus((Object)new Elem(null, "text", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf7.$amp$plus((Object)new Text("\n    "));
        $buf6.$amp$plus((Object)new Elem(null, "svg", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        this.EXECUTORS_LEGEND = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(new Elem(null, "div", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)).toString()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JobPage.$anonfun$EXECUTORS_LEGEND$1(BoxesRunTime.unboxToChar((Object)x$2))));
    }
}

