/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class HealthTracker$
implements Logging {
    public static final HealthTracker$ MODULE$ = new HealthTracker$();
    private static final String DEFAULT_TIMEOUT;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DEFAULT_TIMEOUT = "1h";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Clock $lessinit$greater$default$4() {
        return new SystemClock();
    }

    private String DEFAULT_TIMEOUT() {
        return DEFAULT_TIMEOUT;
    }

    public boolean isExcludeOnFailureEnabled(SparkConf conf) {
        boolean bl;
        Option option = (Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_ENABLED());
        if (option instanceof Some) {
            boolean enabled;
            Some some = (Some)option;
            bl = enabled = BoxesRunTime.unboxToBoolean((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            String legacyKey = org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_LEGACY_TIMEOUT_CONF().key();
            bl = ((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_LEGACY_TIMEOUT_CONF())).exists((Function1)(JFunction1.mcZJ.sp & Serializable)legacyTimeout -> {
                boolean bl;
                if (legacyTimeout == 0L) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Turning off excludeOnFailure due to legacy configuration: ").append(legacyKey).append(" == 0").toString());
                    bl = false;
                } else {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Turning on excludeOnFailure due to legacy configuration: ").append(legacyKey).append(" > 0").toString());
                    bl = true;
                }
                return bl;
            });
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public long getExcludeOnFailureTimeout(SparkConf conf) {
        return BoxesRunTime.unboxToLong((Object)((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_TIMEOUT_CONF())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_LEGACY_TIMEOUT_CONF())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> Utils$.MODULE$.timeStringAsMs(MODULE$.DEFAULT_TIMEOUT())))));
    }

    public void validateExcludeOnFailureConfs(SparkConf conf) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{org.apache.spark.internal.config.package$.MODULE$.MAX_TASK_ATTEMPTS_PER_EXECUTOR(), org.apache.spark.internal.config.package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE(), org.apache.spark.internal.config.package$.MODULE$.MAX_FAILURES_PER_EXEC_STAGE(), org.apache.spark.internal.config.package$.MODULE$.MAX_FAILED_EXEC_PER_NODE_STAGE(), org.apache.spark.internal.config.package$.MODULE$.MAX_FAILURES_PER_EXEC(), org.apache.spark.internal.config.package$.MODULE$.MAX_FAILED_EXEC_PER_NODE()})).foreach((Function1 & Serializable)config -> {
            HealthTracker$.$anonfun$validateExcludeOnFailureConfs$1(conf, config);
            return BoxedUnit.UNIT;
        });
        long timeout = this.getExcludeOnFailureTimeout(conf);
        if (timeout <= 0L) {
            Option option = (Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_TIMEOUT_CONF());
            if (option instanceof Some) {
                HealthTracker$.mustBePos$1(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_TIMEOUT_CONF().key(), Long.toString(timeout));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                HealthTracker$.mustBePos$1(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_LEGACY_TIMEOUT_CONF().key(), Long.toString(timeout));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
        int maxTaskFailures = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.TASK_MAX_FAILURES()));
        int maxNodeAttempts = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE()));
        if (maxNodeAttempts >= maxTaskFailures) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(1).append(org.apache.spark.internal.config.package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE().key()).append(" ").toString()).append(new StringBuilder(14).append("( = ").append(maxNodeAttempts).append(") was >= ").append(org.apache.spark.internal.config.package$.MODULE$.TASK_MAX_FAILURES().key()).append(" ").toString()).append(new StringBuilder(69).append("( = ").append(maxTaskFailures).append(" ). Though excludeOnFailure is enabled, with this configuration, ").toString()).append("Spark will not be robust to one bad node. Decrease ").append(new StringBuilder(13).append(org.apache.spark.internal.config.package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE().key()).append(", increase ").append(org.apache.spark.internal.config.package$.MODULE$.TASK_MAX_FAILURES().key()).append(", ").toString()).append(new StringBuilder(33).append("or disable excludeOnFailure with ").append(org.apache.spark.internal.config.package$.MODULE$.EXCLUDE_ON_FAILURE_ENABLED().key()).toString()).toString());
        }
    }

    private static final void mustBePos$1(String k, String v) {
        throw new IllegalArgumentException(new StringBuilder(23).append(k).append(" was ").append(v).append(", but must be > 0.").toString());
    }

    public static final /* synthetic */ void $anonfun$validateExcludeOnFailureConfs$1(SparkConf conf$2, ConfigEntry config) {
        block0: {
            int v = BoxesRunTime.unboxToInt(conf$2.get(config));
            if (v > 0) break block0;
            HealthTracker$.mustBePos$1(config.key(), Integer.toString(v));
        }
    }

    private HealthTracker$() {
    }
}

