/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSDataOutputStreamBuilder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkHadoopUtil$
implements Logging {
    public static final SparkHadoopUtil$ MODULE$ = new SparkHadoopUtil$();
    private static SparkHadoopUtil instance;
    private static Seq<Map.Entry<String, String>> hiveConfKeys;
    private static final int UPDATE_INPUT_METRICS_INTERVAL_RECORDS;
    private static final String SPARK_HADOOP_CONF_FILE;
    private static final String SOURCE_HIVE_SITE;
    private static final String SOURCE_SPARK;
    private static final String SOURCE_SPARK_HADOOP;
    private static final String ENV_VAR_AWS_ACCESS_KEY;
    private static final String ENV_VAR_AWS_SECRET_KEY;
    private static final String ENV_VAR_AWS_SESSION_TOKEN;
    private static final String SOURCE_SPARK_HIVE;
    private static final String SET_TO_DEFAULT_VALUES;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile byte bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        UPDATE_INPUT_METRICS_INTERVAL_RECORDS = 1000;
        SPARK_HADOOP_CONF_FILE = "__spark_hadoop_conf__.xml";
        SOURCE_HIVE_SITE = "Set by Spark from hive-site.xml";
        SOURCE_SPARK = "Set by Spark";
        SOURCE_SPARK_HADOOP = "Set by Spark from keys starting with 'spark.hadoop'";
        ENV_VAR_AWS_ACCESS_KEY = "AWS_ACCESS_KEY_ID";
        ENV_VAR_AWS_SECRET_KEY = "AWS_SECRET_ACCESS_KEY";
        ENV_VAR_AWS_SESSION_TOKEN = "AWS_SESSION_TOKEN";
        SOURCE_SPARK_HIVE = "Set by Spark from keys starting with 'spark.hive'";
        SET_TO_DEFAULT_VALUES = "Set by Spark to default values";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkHadoopUtil instance$lzycompute() {
        SparkHadoopUtil$ sparkHadoopUtil$ = this;
        synchronized (sparkHadoopUtil$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                instance = new SparkHadoopUtil();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return instance;
    }

    private SparkHadoopUtil instance() {
        return (byte)(bitmap$0 & 1) == 0 ? this.instance$lzycompute() : instance;
    }

    public int UPDATE_INPUT_METRICS_INTERVAL_RECORDS() {
        return UPDATE_INPUT_METRICS_INTERVAL_RECORDS;
    }

    public String SPARK_HADOOP_CONF_FILE() {
        return SPARK_HADOOP_CONF_FILE;
    }

    public String SOURCE_HIVE_SITE() {
        return SOURCE_HIVE_SITE;
    }

    public String SOURCE_SPARK() {
        return SOURCE_SPARK;
    }

    public String SOURCE_SPARK_HADOOP() {
        return SOURCE_SPARK_HADOOP;
    }

    public String ENV_VAR_AWS_ACCESS_KEY() {
        return ENV_VAR_AWS_ACCESS_KEY;
    }

    public String ENV_VAR_AWS_SECRET_KEY() {
        return ENV_VAR_AWS_SECRET_KEY;
    }

    public String ENV_VAR_AWS_SESSION_TOKEN() {
        return ENV_VAR_AWS_SESSION_TOKEN;
    }

    public String SOURCE_SPARK_HIVE() {
        return SOURCE_SPARK_HIVE;
    }

    public String SET_TO_DEFAULT_VALUES() {
        return SET_TO_DEFAULT_VALUES;
    }

    public SparkHadoopUtil get() {
        return this.instance();
    }

    /*
     * WARNING - void declaration
     */
    public Configuration newConfiguration(SparkConf conf) {
        void var2_2;
        Configuration hadoopConf = new Configuration();
        this.org$apache$spark$deploy$SparkHadoopUtil$$appendS3AndSparkHadoopHiveConfigurations(conf, hadoopConf);
        return var2_2;
    }

    public void org$apache$spark$deploy$SparkHadoopUtil$$appendS3AndSparkHadoopHiveConfigurations(SparkConf conf, Configuration hadoopConf) {
        block0: {
            if (conf == null) break block0;
            this.appendS3CredentialsFromEnvironment(hadoopConf, System.getenv(this.ENV_VAR_AWS_ACCESS_KEY()), System.getenv(this.ENV_VAR_AWS_SECRET_KEY()), System.getenv(this.ENV_VAR_AWS_SESSION_TOKEN()));
            this.appendHiveConfigs(hadoopConf);
            this.org$apache$spark$deploy$SparkHadoopUtil$$appendSparkHadoopConfigs(conf, hadoopConf);
            this.appendSparkHiveConfigs(conf, hadoopConf);
            String bufferSize = conf.get(org.apache.spark.internal.config.package$.MODULE$.BUFFER_SIZE()).toString();
            hadoopConf.set("io.file.buffer.size", bufferSize, org.apache.spark.internal.config.package$.MODULE$.BUFFER_SIZE().key());
        }
    }

    public void appendS3CredentialsFromEnvironment(Configuration hadoopConf, String keyId, String accessKey, String sessionToken) {
        block1: {
            if (keyId == null || accessKey == null) break block1;
            String source = new StringBuilder(10).append(this.SOURCE_SPARK()).append(" on ").append(InetAddress.getLocalHost().toString()).append(" from ").toString();
            hadoopConf.set("fs.s3.awsAccessKeyId", keyId, new StringBuilder(0).append(source).append(this.ENV_VAR_AWS_ACCESS_KEY()).toString());
            hadoopConf.set("fs.s3n.awsAccessKeyId", keyId, new StringBuilder(0).append(source).append(this.ENV_VAR_AWS_ACCESS_KEY()).toString());
            hadoopConf.set("fs.s3a.access.key", keyId, new StringBuilder(0).append(source).append(this.ENV_VAR_AWS_ACCESS_KEY()).toString());
            hadoopConf.set("fs.s3.awsSecretAccessKey", accessKey, new StringBuilder(0).append(source).append(this.ENV_VAR_AWS_SECRET_KEY()).toString());
            hadoopConf.set("fs.s3n.awsSecretAccessKey", accessKey, new StringBuilder(0).append(source).append(this.ENV_VAR_AWS_SECRET_KEY()).toString());
            hadoopConf.set("fs.s3a.secret.key", accessKey, new StringBuilder(0).append(source).append(this.ENV_VAR_AWS_SECRET_KEY()).toString());
            if (sessionToken != null) {
                hadoopConf.set("fs.s3a.session.token", sessionToken, new StringBuilder(0).append(source).append(this.ENV_VAR_AWS_SESSION_TOKEN()).toString());
            }
        }
    }

    private Seq<Map.Entry<String, String>> hiveConfKeys$lzycompute() {
        SparkHadoopUtil$ sparkHadoopUtil$ = this;
        synchronized (sparkHadoopUtil$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                Nil$ nil$;
                URL configFile = Utils$.MODULE$.getContextOrSparkClassLoader().getResource("hive-site.xml");
                if (configFile != null) {
                    Configuration conf = new Configuration(false);
                    conf.addResource(configFile);
                    nil$ = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(conf.iterator()).asScala()).toSeq();
                } else {
                    nil$ = package$.MODULE$.Nil();
                }
                hiveConfKeys = nil$;
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return hiveConfKeys;
    }

    private Seq<Map.Entry<String, String>> hiveConfKeys() {
        return (byte)(bitmap$0 & 2) == 0 ? this.hiveConfKeys$lzycompute() : hiveConfKeys;
    }

    private void appendHiveConfigs(Configuration hadoopConf) {
        this.hiveConfKeys().foreach((Function1 & Serializable)kv -> {
            hadoopConf.set((String)kv.getKey(), (String)kv.getValue(), SparkHadoopUtil$.MODULE$.SOURCE_HIVE_SITE());
            return BoxedUnit.UNIT;
        });
    }

    public void org$apache$spark$deploy$SparkHadoopUtil$$appendSparkHadoopConfigs(SparkConf conf, Configuration hadoopConf) {
        block2: {
            ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])conf.getAll()), (Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHadoopConfigs$4(check$ifrefutable$3))).withFilter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHadoopConfigs$5(x$11))).foreach((Function1 & Serializable)x$12 -> {
                SparkHadoopUtil$.$anonfun$appendSparkHadoopConfigs$6(hadoopConf, x$12);
                return BoxedUnit.UNIT;
            });
            String setBySpark = this.SET_TO_DEFAULT_VALUES();
            if (conf.getOption("spark.hadoop.mapreduce.fileoutputcommitter.algorithm.version").isEmpty()) {
                hadoopConf.set("mapreduce.fileoutputcommitter.algorithm.version", "1", setBySpark);
            }
            if (conf.getOption("spark.hadoop.fs.s3a.downgrade.syncable.exceptions").isEmpty()) {
                hadoopConf.set("fs.s3a.downgrade.syncable.exceptions", "true", setBySpark);
            }
            if (!hadoopConf.get("fs.s3a.endpoint", "").isEmpty() || hadoopConf.get("fs.s3a.endpoint.region") != null) break block2;
            hadoopConf.set("fs.s3a.endpoint", "s3.amazonaws.com", setBySpark);
        }
    }

    private void appendSparkHiveConfigs(SparkConf conf, Configuration hadoopConf) {
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])conf.getAll()), (Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHiveConfigs$4(check$ifrefutable$4))).withFilter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHiveConfigs$5(x$13))).foreach((Function1 & Serializable)x$14 -> {
            SparkHadoopUtil$.$anonfun$appendSparkHiveConfigs$6(hadoopConf, x$14);
            return BoxedUnit.UNIT;
        });
    }

    public String propertySources(Configuration hadoopConf, String key) {
        String[] sources = hadoopConf.getPropertySources(key);
        return sources != null && ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])sources)) ? Predef$.MODULE$.wrapRefArray((Object[])sources).mkString(",") : "";
    }

    public FSDataOutputStream createFile(FileSystem fs, Path path, boolean allowEC) {
        FSDataOutputStream fSDataOutputStream;
        if (allowEC) {
            fSDataOutputStream = fs.create(path);
        } else {
            FSDataOutputStream fSDataOutputStream2;
            if (!fs.mkdirs(path.getParent())) {
                throw new IOException(new StringBuilder(28).append("Failed to create parents of ").append(path).toString());
            }
            Path qualifiedPath = fs.makeQualified(path);
            FSDataOutputStreamBuilder builder = fs.createFile(qualifiedPath);
            FSDataOutputStreamBuilder fSDataOutputStreamBuilder = builder;
            if (fSDataOutputStreamBuilder instanceof DistributedFileSystem.HdfsDataOutputStreamBuilder) {
                DistributedFileSystem.HdfsDataOutputStreamBuilder hdfsDataOutputStreamBuilder = (DistributedFileSystem.HdfsDataOutputStreamBuilder)fSDataOutputStreamBuilder;
                fSDataOutputStream2 = hdfsDataOutputStreamBuilder.replicate().build();
            } else {
                fSDataOutputStream2 = fs.create(path);
            }
            fSDataOutputStream = fSDataOutputStream2;
        }
        return fSDataOutputStream;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHadoopConfigs$4(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHadoopConfigs$5(Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith("spark.hadoop.");
        return bl;
    }

    public static final /* synthetic */ void $anonfun$appendSparkHadoopConfigs$6(Configuration hadoopConf$2, Tuple2 x$12) {
        Tuple2 tuple2 = x$12;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        hadoopConf$2.set(key.substring("spark.hadoop.".length()), value, MODULE$.SOURCE_SPARK_HADOOP());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHiveConfigs$4(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHiveConfigs$5(Tuple2 x$13) {
        Tuple2 tuple2 = x$13;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith("spark.hive.");
        return bl;
    }

    public static final /* synthetic */ void $anonfun$appendSparkHiveConfigs$6(Configuration hadoopConf$3, Tuple2 x$14) {
        Tuple2 tuple2 = x$14;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        hadoopConf$3.set(key.substring("spark.".length()), value, MODULE$.SOURCE_SPARK_HIVE());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SparkHadoopUtil$() {
    }
}

