/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeYMInterval$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([years[, months]]) - Make year-month interval from years, months.", arguments="\n    Arguments:\n      * years - the number of years, positive or negative\n      * months - the number of months, positive or negative\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 2);\n       1-2\n      > SELECT _FUNC_(1, 0);\n       1-0\n      > SELECT _FUNC_(-1, 1);\n       -0-11\n      > SELECT _FUNC_(2);\n       2-0\n  ", since="3.2.0", group="datetime_funcs")
@ScalaSignature(bytes="\u0006\u0005\t=a\u0001B\u0011#\u0001>B\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t)\u0002\u0011\t\u0012)A\u0005#\"AQ\u000b\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003R\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u00159\u0006\u0001\"\u0001]\u0011\u00159\u0006\u0001\"\u0001_\u0011\u0015y\u0006\u0001\"\u0011Q\u0011\u0015\u0001\u0007\u0001\"\u0011Q\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015\t\b\u0001\"\u0011s\u0011\u0015Q\b\u0001\"\u0011|\u0011\u001d\t\u0019\u0002\u0001C!\u0003+Aq!a\n\u0001\t#\nI\u0003C\u0005\u00024\u0001\t\t\u0011\"\u0001\u00026!I\u00111\b\u0001\u0012\u0002\u0013\u0005\u0011Q\b\u0005\n\u0003'\u0002\u0011\u0013!C\u0001\u0003{A\u0011\"!\u0016\u0001\u0003\u0003%\t%a\u0016\t\u0013\u0005\u001d\u0004!!A\u0005\u0002\u0005%\u0004\"CA9\u0001\u0005\u0005I\u0011AA:\u0011%\tI\bAA\u0001\n\u0003\nY\bC\u0005\u0002\n\u0002\t\t\u0011\"\u0001\u0002\f\"I\u0011Q\u0013\u0001\u0002\u0002\u0013\u0005\u0013q\u0013\u0005\n\u00037\u0003\u0011\u0011!C!\u0003;;\u0011\"a2#\u0003\u0003E\t!!3\u0007\u0011\u0005\u0012\u0013\u0011!E\u0001\u0003\u0017DaaV\u000e\u0005\u0002\u0005\r\b\"CAs7\u0005\u0005IQIAt\u0011%\tIoGA\u0001\n\u0003\u000bY\u000fC\u0005\u0002rn\t\t\u0011\"!\u0002t\"I!QA\u000e\u0002\u0002\u0013%!q\u0001\u0002\u000f\u001b\u0006\\W-W'J]R,'O^1m\u0015\t\u0019C%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0013'\u0003!\u0019\u0017\r^1msN$(BA\u0014)\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003S)\nQa\u001d9be.T!a\u000b\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0013aA8sO\u000e\u00011C\u0002\u00011i]r4\n\u0005\u00022e5\t!%\u0003\u00024E\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003cUJ!A\u000e\u0012\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001O\u001e\u000f\u0005EJ\u0014B\u0001\u001e#\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001P\u001f\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011!H\t\t\u0003\u007f!s!\u0001\u0011$\u000f\u0005\u0005#U\"\u0001\"\u000b\u0005\rs\u0013A\u0002\u001fs_>$h(C\u0001F\u0003\u0015\u00198-\u00197b\u0013\tQtIC\u0001F\u0013\tI%J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002;\u000fB\u0011A*T\u0007\u0002\u000f&\u0011aj\u0012\u0002\b!J|G-^2u\u0003\u0015IX-\u0019:t+\u0005\t\u0006CA\u0019S\u0013\t\u0019&E\u0001\u0006FqB\u0014Xm]:j_:\fa!_3beN\u0004\u0013AB7p]RD7/A\u0004n_:$\bn\u001d\u0011\u0002\rqJg.\u001b;?)\rI&l\u0017\t\u0003c\u0001AQaT\u0003A\u0002ECQ!V\u0003A\u0002E#\"!W/\t\u000b=3\u0001\u0019A)\u0015\u0003e\u000bA\u0001\\3gi\u0006)!/[4ii\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003\r\u00042a\u00103g\u0013\t)'JA\u0002TKF\u0004\"a\u001a6\u000e\u0003!T!!\u001b\u0014\u0002\u000bQL\b/Z:\n\u0005-D'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#\u00018\u0011\u0005\u001d|\u0017B\u00019i\u0005!!\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA:wqB\u0011A\n^\u0005\u0003k\u001e\u00131!\u00118z\u0011\u00159H\u00021\u0001t\u0003\u0011IX-\u0019:\t\u000bed\u0001\u0019A:\u0002\u000b5|g\u000e\u001e5\u0002\u0013\u0011|w)\u001a8D_\u0012,G#\u0002?\u0002\u0006\u0005=\u0001cA?\u0002\u00025\taP\u0003\u0002\u0000E\u000591m\u001c3fO\u0016t\u0017bAA\u0002}\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\b5\u0001\r!!\u0003\u0002\u0007\r$\b\u0010E\u0002~\u0003\u0017I1!!\u0004\u007f\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!!\u0005\u000e\u0001\u0004a\u0018AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003/\u0001B!!\u0007\u0002\"9!\u00111DA\u000f!\t\tu)C\u0002\u0002 \u001d\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0012\u0003K\u0011aa\u0015;sS:<'bAA\u0010\u000f\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006#\u0006-\u0012q\u0006\u0005\u0007\u0003[y\u0001\u0019A)\u0002\u000f9,w\u000fT3gi\"1\u0011\u0011G\bA\u0002E\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0003Z\u0003o\tI\u0004C\u0004P!A\u0005\t\u0019A)\t\u000fU\u0003\u0002\u0013!a\u0001#\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA U\r\t\u0016\u0011I\u0016\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%A\u0005v]\u000eDWmY6fI*\u0019\u0011QJ$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0005\u001d#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002ZA!\u00111LA3\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014\u0001\u00027b]\u001eT!!a\u0019\u0002\t)\fg/Y\u0005\u0005\u0003G\ti&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002lA\u0019A*!\u001c\n\u0007\u0005=tIA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002t\u0003kB\u0011\"a\u001e\u0016\u0003\u0003\u0005\r!a\u001b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\bE\u0003\u0002\u0000\u0005\u00155/\u0004\u0002\u0002\u0002*\u0019\u00111Q$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\b\u0006\u0005%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!$\u0002\u0014B\u0019A*a$\n\u0007\u0005EuIA\u0004C_>dW-\u00198\t\u0011\u0005]t#!AA\u0002M\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011LAM\u0011%\t9\bGA\u0001\u0002\u0004\tY'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u001b\u000by\n\u0003\u0005\u0002xe\t\t\u00111\u0001tQ]\u0001\u00111UAU\u0003W\u000by+!-\u00026\u0006]\u00161XA_\u0003\u0003\f\u0019\rE\u00022\u0003KK1!a*#\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!,\u0002\u0011~3UKT\"`QmKX-\u0019:t72\u0002Sn\u001c8uQNlV,\u000b\u0011.A5\u000b7.\u001a\u0011zK\u0006\u0014X&\\8oi\"\u0004\u0013N\u001c;feZ\fG\u000e\t4s_6\u0004\u00130Z1sg2\u0002Sn\u001c8uQNt\u0013!C1sOVlWM\u001c;tC\t\t\u0019,AA\t\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u00130Z1sg\u0002j\u0003\u0005\u001e5fA9,XNY3sA=4\u0007%_3beNd\u0003\u0005]8tSRLg/\u001a\u0011pe\u0002rWmZ1uSZ,'\u0002\t\u0011!A\u0001\u0002#\u0006I7p]RD7\u000fI\u0017!i\",\u0007E\\;nE\u0016\u0014\be\u001c4![>tG\u000f[:-AA|7/\u001b;jm\u0016\u0004sN\u001d\u0011oK\u001e\fG/\u001b<f\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005e\u0016!a\u0019\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QEb\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AEj#G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152Y\u0001\u0002\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112[AR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&L\u0019-AEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00171[E\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012T\u0006\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qX\u0001\u0006g9\u0012d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u000b\fa\u0002Z1uKRLW.Z0gk:\u001c7/\u0001\bNC.,\u0017,T%oi\u0016\u0014h/\u00197\u0011\u0005EZ2#B\u000e\u0002N\u0006e\u0007cBAh\u0003+\f\u0016+W\u0007\u0003\u0003#T1!a5H\u0003\u001d\u0011XO\u001c;j[\u0016LA!a6\u0002R\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005m\u0017\u0011]\u0007\u0003\u0003;TA!a8\u0002b\u0005\u0011\u0011n\\\u0005\u0004\u0013\u0006uGCAAe\u0003!!xn\u0015;sS:<GCAA-\u0003\u0015\t\u0007\u000f\u001d7z)\u0015I\u0016Q^Ax\u0011\u0015ye\u00041\u0001R\u0011\u0015)f\u00041\u0001R\u0003\u001d)h.\u00199qYf$B!!>\u0003\u0002A)A*a>\u0002|&\u0019\u0011\u0011`$\u0003\r=\u0003H/[8o!\u0015a\u0015Q`)R\u0013\r\typ\u0012\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\t\rq$!AA\u0002e\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011I\u0001\u0005\u0003\u0002\\\t-\u0011\u0002\u0002B\u0007\u0003;\u0012aa\u00142kK\u000e$\b")
public class MakeYMInterval
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression years;
    private final Expression months;

    public static Option<Tuple2<Expression, Expression>> unapply(MakeYMInterval x$0) {
        return MakeYMInterval$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, MakeYMInterval> tupled() {
        return MakeYMInterval$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MakeYMInterval>> curried() {
        return MakeYMInterval$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression years() {
        return this.years;
    }

    public Expression months() {
        return this.months;
    }

    @Override
    public Expression left() {
        return this.years();
    }

    @Override
    public Expression right() {
        return this.months();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IntegerType$[]{IntegerType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return YearMonthIntervalType$.MODULE$.apply();
    }

    @Override
    public Object nullSafeEval(Object year, Object month) {
        return BoxesRunTime.boxToInteger((int)Math.toIntExact(Math.addExact(((Number)month).longValue(), Math.multiplyExact(((Number)year).longValue(), 12L))));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(years, months) -> {
            String math = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(Math.class.getName()), "$");
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(104).append("\n         |").append(math).append(".toIntExact(java.lang.Math.addExact(").append((String)months).append(",\n         |  ").append(math).append(".multiplyExact(").append((String)years).append(", ").append(12).append(")))\n         |").toString()));
        });
    }

    @Override
    public String prettyName() {
        return "make_ym_interval";
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public MakeYMInterval copy(Expression years, Expression months) {
        return new MakeYMInterval(years, months);
    }

    public Expression copy$default$1() {
        return this.years();
    }

    public Expression copy$default$2() {
        return this.months();
    }

    @Override
    public String productPrefix() {
        return "MakeYMInterval";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.years();
                break;
            }
            case 1: {
                object = this.months();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeYMInterval;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "years";
                break;
            }
            case 1: {
                string = "months";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeYMInterval)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeYMInterval makeYMInterval = (MakeYMInterval)x$1;
        Expression expression = this.years();
        Expression expression2 = makeYMInterval.years();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.months();
        Expression expression4 = makeYMInterval.months();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!makeYMInterval.canEqual(this)) return false;
        return true;
    }

    public MakeYMInterval(Expression years, Expression months) {
        this.years = years;
        this.months = months;
        ExpectsInputTypes.$init$(this);
    }

    public MakeYMInterval(Expression years) {
        this(years, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeYMInterval() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

