% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\name{write.df}
\alias{write.df}
\alias{saveDF}
\alias{write.df,SparkDataFrame-method}
\alias{saveDF,SparkDataFrame,character-method}
\title{Save the contents of SparkDataFrame to a data source.}
\usage{
write.df(df, path = NULL, ...)

saveDF(df, path, source = NULL, mode = "error", ...)

write.df(df, path = NULL, ...)

\S4method{write.df}{SparkDataFrame}(
  df,
  path = NULL,
  source = NULL,
  mode = "error",
  partitionBy = NULL,
  ...
)

\S4method{saveDF}{SparkDataFrame,character}(df, path, source = NULL, mode = "error", ...)
}
\arguments{
\item{df}{a SparkDataFrame.}

\item{path}{a name for the table.}

\item{...}{additional argument(s) passed to the method.}

\item{source}{a name for external data source.}

\item{mode}{one of 'append', 'overwrite', 'error', 'errorifexists', 'ignore'
save mode (it is 'error' by default)}

\item{partitionBy}{a name or a list of names of columns to partition the output by on the file
system. If specified, the output is laid out on the file system similar
to Hive's partitioning scheme.}
}
\description{
The data source is specified by the \code{source} and a set of options (...).
If \code{source} is not specified, the default data source configured by
spark.sql.sources.default will be used.
}
\details{
Additionally, mode is used to specify the behavior of the save operation when data already
exists in the data source. There are four modes:
\itemize{
  \item 'append': Contents of this SparkDataFrame are expected to be appended to existing data.
  \item 'overwrite': Existing data is expected to be overwritten by the contents of this
        SparkDataFrame.
  \item 'error' or 'errorifexists': An exception is expected to be thrown.
  \item 'ignore': The save operation is expected to not save the contents of the SparkDataFrame
        and to not change the existing data.
}
}
\note{
write.df since 1.4.0

saveDF since 1.4.0
}
\examples{
\dontrun{
sparkR.session()
path <- "path/to/file.json"
df <- read.json(path)
write.df(df, "myfile", "parquet", "overwrite", partitionBy = c("col1", "col2"))
saveDF(df, parquetPath2, "parquet", mode = "append", mergeSchema = TRUE)
}
}
\seealso{
Other SparkDataFrame functions: 
\code{\link{SparkDataFrame-class}},
\code{\link{agg}()},
\code{\link{alias}()},
\code{\link{arrange}()},
\code{\link{as.data.frame}()},
\code{\link{attach,SparkDataFrame-method}},
\code{\link{broadcast}()},
\code{\link{cache}()},
\code{\link{checkpoint}()},
\code{\link{coalesce}()},
\code{\link{collect}()},
\code{\link{colnames}()},
\code{\link{coltypes}()},
\code{\link{createOrReplaceTempView}()},
\code{\link{crossJoin}()},
\code{\link{cube}()},
\code{\link{dapply}()},
\code{\link{dapplyCollect}()},
\code{\link{describe}()},
\code{\link{dim}()},
\code{\link{distinct}()},
\code{\link{drop}()},
\code{\link{dropDuplicates}()},
\code{\link{dropna}()},
\code{\link{dtypes}()},
\code{\link{except}()},
\code{\link{exceptAll}()},
\code{\link{explain}()},
\code{\link{filter}()},
\code{\link{first}()},
\code{\link{gapply}()},
\code{\link{gapplyCollect}()},
\code{\link{getNumPartitions}()},
\code{\link{group_by}()},
\code{\link{head}()},
\code{\link{hint}()},
\code{\link{histogram}()},
\code{\link{insertInto}()},
\code{\link{intersect}()},
\code{\link{intersectAll}()},
\code{\link{isLocal}()},
\code{\link{isStreaming}()},
\code{\link{join}()},
\code{\link{limit}()},
\code{\link{localCheckpoint}()},
\code{\link{merge}()},
\code{\link{mutate}()},
\code{\link{ncol}()},
\code{\link{nrow}()},
\code{\link{persist}()},
\code{\link{printSchema}()},
\code{\link{randomSplit}()},
\code{\link{rbind}()},
\code{\link{rename}()},
\code{\link{repartition}()},
\code{\link{repartitionByRange}()},
\code{\link{rollup}()},
\code{\link{sample}()},
\code{\link{saveAsTable}()},
\code{\link{schema}()},
\code{\link{select}()},
\code{\link{selectExpr}()},
\code{\link{show}()},
\code{\link{showDF}()},
\code{\link{storageLevel}()},
\code{\link{str}()},
\code{\link{subset}()},
\code{\link{summary}()},
\code{\link{take}()},
\code{\link{toJSON}()},
\code{\link{union}()},
\code{\link{unionAll}()},
\code{\link{unionByName}()},
\code{\link{unpersist}()},
\code{\link{unpivot}()},
\code{\link{with}()},
\code{\link{withColumn}()},
\code{\link{withWatermark}()},
\code{\link{write.jdbc}()},
\code{\link{write.json}()},
\code{\link{write.orc}()},
\code{\link{write.parquet}()},
\code{\link{write.stream}()},
\code{\link{write.text}()}
}
\concept{SparkDataFrame functions}
