/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.relation.service;

import java.util.Optional;
import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.manual.relation.service.ServiceRelationClientSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.manual.relation.service.ServiceRelationServerSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntList;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ServiceRelation;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class ServiceCallRelationDispatcher
implements SourceDispatcher<ServiceRelation> {
    @Override
    public void dispatch(ServiceRelation source) {
        switch (source.getDetectPoint()) {
            case SERVER: {
                this.serverSide(source);
                break;
            }
            case CLIENT: {
                this.clientSide(source);
            }
        }
    }

    private void serverSide(ServiceRelation source) {
        ServiceRelationServerSideMetrics metrics = new ServiceRelationServerSideMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setSourceServiceId(source.getSourceServiceId());
        metrics.setDestServiceId(source.getDestServiceId());
        IntList componentIds = metrics.getComponentIds();
        componentIds.add(source.getComponentId());
        this.tlsStatus(source.getTlsMode()).ifPresent(componentIds::add);
        metrics.setEntityId(source.getEntityId());
        MetricsStreamProcessor.getInstance().in(metrics);
    }

    private void clientSide(ServiceRelation source) {
        ServiceRelationClientSideMetrics metrics = new ServiceRelationClientSideMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setSourceServiceId(source.getSourceServiceId());
        metrics.setDestServiceId(source.getDestServiceId());
        IntList componentIds = metrics.getComponentIds();
        componentIds.add(source.getComponentId());
        this.tlsStatus(source.getTlsMode()).ifPresent(componentIds::add);
        metrics.setEntityId(source.getEntityId());
        MetricsStreamProcessor.getInstance().in(metrics);
    }

    private Optional<Integer> tlsStatus(String tlsMode) {
        if (StringUtil.isBlank((String)tlsMode)) {
            return Optional.empty();
        }
        switch (tlsMode) {
            case "mTLS": {
                return Optional.of(142);
            }
            case "TLS": {
                return Optional.of(130);
            }
        }
        return Optional.empty();
    }
}

