/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider.trace;

import java.io.StringReader;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.skywalking.oap.server.analyzer.provider.AnalyzerModuleConfig;
import org.apache.skywalking.oap.server.analyzer.provider.trace.sampling.SamplingPolicy;
import org.apache.skywalking.oap.server.analyzer.provider.trace.sampling.SamplingPolicySettings;
import org.apache.skywalking.oap.server.analyzer.provider.trace.sampling.SamplingPolicySettingsReader;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceSamplingPolicyWatcher
extends ConfigChangeWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceSamplingPolicyWatcher.class);
    private final AtomicReference<String> settingsString = new AtomicReference<Object>(null);
    private final AtomicReference<SamplingPolicySettings> samplingPolicySettings = new AtomicReference<Object>(null);
    private final SamplingPolicySettings defaultSamplingPolicySettings;

    public TraceSamplingPolicyWatcher(AnalyzerModuleConfig moduleConfig, ModuleProvider provider) {
        super("agent-analyzer", provider, "traceSamplingPolicy");
        this.defaultSamplingPolicySettings = this.parseFromFile(moduleConfig.getTraceSamplingPolicySettingsFile());
        this.loadDefaultPolicySettings();
    }

    public void notify(ConfigChangeWatcher.ConfigChangeEvent value) {
        if (ConfigChangeWatcher.EventType.DELETE.equals((Object)value.getEventType()) || StringUtil.isBlank((String)value.getNewValue())) {
            this.settingsString.set(null);
            log.info("[trace-sampling-policy] Delete trace-sampling-policy,use default config");
            this.loadDefaultPolicySettings();
        } else {
            this.activeSetting(value.getNewValue());
        }
    }

    public String value() {
        return this.settingsString.get();
    }

    public boolean shouldSample(String service, int sample, int duration) {
        SamplingPolicy samplingPolicy = this.samplingPolicySettings.get().get(service);
        if (samplingPolicy == null) {
            return this.shouldSampleByDefault(sample, duration);
        }
        return this.shouldSampleService(samplingPolicy, sample, duration);
    }

    private boolean shouldSampleByDefault(int sample, int duration) {
        return this.isOverDefaultSlowThreshold(duration) || this.withinDefaultRateRange(sample);
    }

    private boolean shouldSampleService(SamplingPolicy samplingPolicy, int sample, int duration) {
        return samplingPolicy.getDuration() != null && this.isOverSlowThreshold(duration, samplingPolicy.getDuration()) || samplingPolicy.getRate() != null && this.withinRateRange(sample, samplingPolicy.getRate()) || samplingPolicy.getDuration() == null && this.isOverDefaultSlowThreshold(duration) || samplingPolicy.getRate() == null && this.withinDefaultRateRange(sample);
    }

    private boolean withinDefaultRateRange(int sample) {
        return this.withinRateRange(sample, this.samplingPolicySettings.get().getDefaultPolicy().getRate());
    }

    private boolean isOverDefaultSlowThreshold(int duration) {
        return this.isOverSlowThreshold(duration, this.samplingPolicySettings.get().getDefaultPolicy().getDuration());
    }

    private boolean isOverSlowThreshold(int currentDuration, int policyDuration) {
        return policyDuration > -1 && currentDuration >= policyDuration;
    }

    private boolean withinRateRange(int currentSample, int policySample) {
        return currentSample < policySample;
    }

    private void loadDefaultPolicySettings() {
        this.samplingPolicySettings.set(this.defaultSamplingPolicySettings);
        log.info("[trace-sampling-policy] use trace-sample-policy in static file : {}", this.samplingPolicySettings);
    }

    private void activeSetting(String config) {
        if (log.isDebugEnabled()) {
            log.debug("[trace-sampling-policy] Updating using new config: {}", (Object)config);
        }
        this.onUpdated(this.parseFromYml(config));
    }

    private void onUpdated(SamplingPolicySettings samplingPolicySettings) {
        if (!Objects.isNull(samplingPolicySettings)) {
            this.samplingPolicySettings.set(samplingPolicySettings);
            log.info("[trace-sampling-policy] Updating trace-sample-policy with: {}", (Object)samplingPolicySettings);
        } else {
            log.info("[trace-sampling-policy] Parse yaml fail, retain last configuration: {}", this.samplingPolicySettings);
        }
    }

    private SamplingPolicySettings parseFromFile(String file) {
        try {
            SamplingPolicySettingsReader reader = new SamplingPolicySettingsReader(ResourceUtils.read((String)file));
            return reader.readSettings();
        }
        catch (Exception e) {
            log.error("[trace-sampling-policy] Cannot load configs from: {}", (Object)file, (Object)e);
            return new SamplingPolicySettings();
        }
    }

    private SamplingPolicySettings parseFromYml(String ymlContent) {
        try {
            SamplingPolicySettingsReader reader = new SamplingPolicySettingsReader(new StringReader(ymlContent));
            SamplingPolicySettings settings = reader.readSettings();
            this.settingsString.set(ymlContent);
            return settings;
        }
        catch (Exception e) {
            log.error("[trace-sampling-policy] Failed to parse yml content: \n{}", (Object)ymlContent, (Object)e);
            return null;
        }
    }
}

