/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.awt.Color;
import java.util.Optional;
import org.apache.sis.filter.Expression;
import org.apache.sis.style.se1.GraphicFill;
import org.apache.sis.style.se1.StyleElement;
import org.apache.sis.style.se1.StyleFactory;
import org.apache.sis.style.se1.Translucent;

@XmlType(name="FillType", propOrder={"graphicFill"})
@XmlRootElement(name="Fill")
public class Fill<R>
extends StyleElement<R>
implements Translucent<R> {
    @XmlElement(name="GraphicFill")
    protected GraphicFill<R> graphicFill;
    protected Expression<R, Color> color;
    protected Expression<R, ? extends Number> opacity;

    private Fill() {
    }

    public Fill(StyleFactory<R> factory) {
        super(factory);
    }

    public Fill(Fill<R> source) {
        super(source);
        this.graphicFill = source.graphicFill;
        this.color = source.color;
        this.opacity = source.opacity;
    }

    public Optional<GraphicFill<R>> getGraphicFill() {
        return Optional.ofNullable(this.graphicFill);
    }

    public void setGraphicFill(GraphicFill<R> value) {
        this.graphicFill = value;
    }

    public Expression<R, Color> getColor() {
        Expression<R, Color> value = this.color;
        return value != null ? value : this.factory.gray;
    }

    public void setColor(Expression<R, Color> value) {
        this.color = value;
        if (value != null) {
            this.graphicFill = null;
        }
    }

    public void setColorAndOpacity(Color value) {
        if (value == null) {
            this.color = null;
            this.opacity = null;
        } else {
            this.opacity = this.opacity(value);
            if (this.opacity != null) {
                value = new Color(value.getRGB() | 0xFF000000);
            }
            this.color = this.literal(value);
        }
    }

    @Override
    public Expression<R, ? extends Number> getOpacity() {
        return this.defaultToOne(this.opacity);
    }

    @Override
    public void setOpacity(Expression<R, ? extends Number> value) {
        this.opacity = value;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.graphicFill, this.color, this.opacity};
    }

    @Override
    public Fill<R> clone() {
        Fill clone = (Fill)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.graphicFill != null) {
            this.graphicFill = this.graphicFill.clone();
        }
    }
}

