/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.rpc.protocol.rest.netty.UnSharedHandlerCreator;

public class NettyServer {
    protected ServerBootstrap bootstrap = new ServerBootstrap();
    protected String hostname = null;
    protected int configuredPort = 8080;
    protected int runtimePort = -1;
    private EventLoopGroup eventLoopGroup;
    private EventLoopGroup workerLoopGroup;
    private int ioWorkerCount = Runtime.getRuntime().availableProcessors() * 2;
    private List<ChannelHandler> channelHandlers = Collections.emptyList();
    private Map<ChannelOption, Object> channelOptions = Collections.emptyMap();
    private Map<ChannelOption, Object> childChannelOptions = Collections.emptyMap();
    private UnSharedHandlerCreator unSharedHandlerCallBack;

    public void setIoWorkerCount(int ioWorkerCount) {
        this.ioWorkerCount = ioWorkerCount;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.runtimePort > 0 ? this.runtimePort : this.configuredPort;
    }

    public void setPort(int port) {
        this.configuredPort = port;
    }

    public void setChannelHandlers(List<ChannelHandler> channelHandlers) {
        this.channelHandlers = channelHandlers == null ? Collections.emptyList() : channelHandlers;
    }

    public void setChannelOptions(Map<ChannelOption, Object> channelOptions) {
        this.channelOptions = channelOptions == null ? Collections.emptyMap() : channelOptions;
    }

    public void setChildChannelOptions(Map<ChannelOption, Object> channelOptions) {
        this.childChannelOptions = channelOptions == null ? Collections.emptyMap() : channelOptions;
    }

    public void setUnSharedHandlerCallBack(UnSharedHandlerCreator unSharedHandlerCallBack) {
        this.unSharedHandlerCallBack = unSharedHandlerCallBack;
    }

    public void start(URL url) {
        this.eventLoopGroup = new NioEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory("NettyServerBoss"));
        this.workerLoopGroup = new NioEventLoopGroup(this.ioWorkerCount, (ThreadFactory)new NamedThreadFactory("NettyServerWorker"));
        ((ServerBootstrap)this.bootstrap.group(this.eventLoopGroup, this.workerLoopGroup).channel(NioServerSocketChannel.class)).childHandler(this.setupHandlers(url));
        for (Map.Entry<ChannelOption, Object> entry : this.channelOptions.entrySet()) {
            this.bootstrap.option(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<ChannelOption, Object> entry : this.childChannelOptions.entrySet()) {
            this.bootstrap.childOption(entry.getKey(), entry.getValue());
        }
        InetSocketAddress socketAddress = null == this.getHostname() || this.getHostname().isEmpty() ? new InetSocketAddress(this.configuredPort) : new InetSocketAddress(this.hostname, this.configuredPort);
        Channel channel = this.bootstrap.bind((SocketAddress)socketAddress).syncUninterruptibly().channel();
        this.runtimePort = ((InetSocketAddress)channel.localAddress()).getPort();
    }

    protected ChannelHandler setupHandlers(final URL url) {
        return new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline channelPipeline = ch.pipeline();
                int idleTimeout = url.getParameter("idle.timeout", -1);
                if (idleTimeout > 0) {
                    channelPipeline.addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, idleTimeout)});
                }
                channelPipeline.addLast(NettyServer.this.channelHandlers.toArray(new ChannelHandler[NettyServer.this.channelHandlers.size()]));
                List<ChannelHandler> unSharedHandlers = NettyServer.this.unSharedHandlerCallBack.getUnSharedHandlers(url);
                for (ChannelHandler unSharedHandler : unSharedHandlers) {
                    channelPipeline.addLast(new ChannelHandler[]{unSharedHandler});
                }
            }
        };
    }

    public void stop() {
        this.runtimePort = -1;
        this.eventLoopGroup.shutdownGracefully();
    }
}

