/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.impl.floats;

import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractPrimitiveWriters;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.RepeatedPrimitiveWriteSchemas;

public class FloatNotPackedWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        return RepeatedPrimitiveWriteSchemas.create(protoField, propertyDescriptor, new FloatNotPackedWriters(protoField));
    }

    private static class FloatNotPackedWriters
    extends AbstractPrimitiveWriters<float[], Float> {
        public FloatNotPackedWriters(Field protoField) {
            super(protoField);
            this.primitiveArrayWriter = (output, array) -> {
                for (float element : array) {
                    output.writeFloat(this.tag, this.tagSize, element);
                }
            };
            this.arrayWriter = (output, array) -> {
                for (Float element : array) {
                    if (element != null) {
                        output.writeFloat(this.tag, this.tagSize, element.floatValue());
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
            this.collectionWriter = (output, collection) -> {
                for (Float element : collection) {
                    if (element != null) {
                        output.writeFloat(this.tag, this.tagSize, element.floatValue());
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
            this.stringArrayWriter = (output, array) -> {
                for (String element : array) {
                    if (element != null) {
                        float parsedValue = Float.parseFloat(element);
                        output.writeFloat(this.tag, this.tagSize, parsedValue);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            };
        }
    }
}

