/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.UnsafeInput;
import com.esotericsoftware.kryo.io.UnsafeOutput;
import com.google.common.geometry.PrimitiveArrays;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2PointRegion;
import com.google.common.geometry.S2Region;
import com.google.common.geometry.S2RegionUnion;
import com.google.common.geometry.S2Shape;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.sedona.common.S2Geography.EncodeOptions;
import org.apache.sedona.common.S2Geography.EncodeTag;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.common.S2Geography.SinglePointGeography;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointGeography
extends Geography {
    private static final Logger logger = LoggerFactory.getLogger((String)PointGeography.class.getName());
    private static final int BUFFER_SIZE = 4096;
    public final List<S2Point> points = new ArrayList<S2Point>();

    public PointGeography() {
        super(Geography.GeographyKind.POINT);
    }

    PointGeography(Geography.GeographyKind kind, S2Point point) {
        super(kind);
        if (kind != Geography.GeographyKind.POINT && kind != Geography.GeographyKind.SINGLEPOINT && kind != Geography.GeographyKind.CELL_CENTER) {
            throw new IllegalArgumentException("Invalid GeographyKind for PointGeography: " + kind);
        }
        this.points.add(point);
    }

    public PointGeography(S2Point point) {
        this();
        this.points.add(point);
    }

    public PointGeography(List<S2Point> pts) {
        this();
        this.points.addAll(pts);
    }

    @Override
    public int dimension() {
        return this.points.isEmpty() ? -1 : 0;
    }

    @Override
    public int numShapes() {
        return this.points.size();
    }

    @Override
    public S2Shape shape(int id) {
        return S2Point.Shape.fromList(this.points);
    }

    @Override
    public S2Region region() {
        if (this.points.isEmpty()) {
            return S2Cap.empty();
        }
        if (this.points.size() == 1) {
            return new S2PointRegion(this.points.get(0));
        }
        ArrayList<S2PointRegion> pointRegionCollection = new ArrayList<S2PointRegion>();
        for (S2Point p : this.points) {
            pointRegionCollection.add(new S2PointRegion(p));
        }
        return new S2RegionUnion(pointRegionCollection);
    }

    @Override
    public void getCellUnionBound(List<S2CellId> cellIds) {
        if (this.points.size() < 10) {
            for (S2Point p : this.points) {
                cellIds.add(S2CellId.fromPoint((S2Point)p));
            }
        } else {
            super.getCellUnionBound(cellIds);
        }
    }

    public List<S2Point> getPoints() {
        return List.copyOf(this.points);
    }

    @Override
    public void encodeTagged(OutputStream os, EncodeOptions opts) throws IOException {
        S2CellId cid;
        UnsafeOutput out = new UnsafeOutput(os, 4096);
        if (this.points.size() == 1 && opts.getCodingHint() == EncodeOptions.CodingHint.COMPACT && (cid = S2CellId.fromPoint((S2Point)this.points.get(0))).level() >= 23) {
            EncodeTag tag = new EncodeTag();
            tag.setKind(Geography.GeographyKind.CELL_CENTER);
            tag.setCompact(true);
            tag.setCoveringSize((byte)1);
            tag.encode((Output)out);
            out.writeLong(cid.id());
            out.writeInt(this.getSRID());
            out.flush();
            return;
        }
        super.encodeTagged((OutputStream)out, opts);
    }

    @Override
    public void encode(UnsafeOutput out, EncodeOptions opts) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output tmpOut = new Output((OutputStream)baos);
        S2Point.Shape shp = S2Point.Shape.fromList(this.points);
        switch (opts.getCodingHint()) {
            case FAST: {
                S2Point.Shape.FAST_CODER.encode((Object)shp, (OutputStream)tmpOut);
                break;
            }
            case COMPACT: {
                S2Point.Shape.COMPACT_CODER.encode((Object)shp, (OutputStream)tmpOut);
            }
        }
        tmpOut.flush();
        byte[] payload = baos.toByteArray();
        out.writeInt(payload.length, false);
        out.writeBytes(payload);
        out.flush();
    }

    public static PointGeography decode(Input in, EncodeTag tag) throws IOException {
        if (!(in instanceof UnsafeInput)) {
            throw new IllegalArgumentException("Expected UnsafeInput");
        }
        return PointGeography.decode((UnsafeInput)in, tag);
    }

    public static PointGeography decode(UnsafeInput in, EncodeTag tag) throws IOException {
        PointGeography geo = new PointGeography();
        if ((tag.getFlags() & 1) != 0) {
            logger.warn("Decoded empty PointGeography.");
            return geo;
        }
        if (tag.getKind() == Geography.GeographyKind.CELL_CENTER) {
            long id = in.readLong();
            geo = new PointGeography(new S2CellId(id).toPoint());
            logger.info("Decoded compact single-point geography via cell center.");
            return geo;
        }
        tag.skipCovering(in);
        int length = in.readInt(false);
        if (length < 0) {
            throw new IOException("Invalid payload length: " + length);
        }
        final byte[] payload = new byte[length];
        in.readBytes(payload, 0, length);
        PrimitiveArrays.Bytes bytes = new PrimitiveArrays.Bytes(){

            public long length() {
                return payload.length;
            }

            public byte get(long i) {
                return payload[(int)i];
            }
        };
        PrimitiveArrays.Cursor cursor = bytes.cursor();
        List pts = tag.isCompact() ? (List)S2Point.Shape.COMPACT_CODER.decode(bytes, cursor) : (List)S2Point.Shape.FAST_CODER.decode(bytes, cursor);
        if (tag.getKind() == Geography.GeographyKind.SINGLEPOINT) {
            return new SinglePointGeography((S2Point)pts.get(0));
        }
        geo.points.addAll(pts);
        return geo;
    }

    public CoordinateSequence getCoordinateSequence() {
        List<S2Point> pts = this.getPoints();
        Coordinate[] coordArray = new Coordinate[pts.size()];
        for (int i = 0; i < pts.size(); ++i) {
            Coordinate c;
            S2Point pt = pts.get(i);
            S2LatLng ll = new S2LatLng(pt);
            double lat = ll.latDegrees();
            double lon = ll.lngDegrees();
            coordArray[i] = c = new Coordinate(lon, lat);
        }
        return new CoordinateArraySequence(coordArray);
    }
}

