/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.UnsafeInput;
import com.esotericsoftware.kryo.io.UnsafeOutput;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2Region;
import com.google.common.geometry.S2Shape;
import com.google.common.geometry.S2ShapeIndex;
import com.google.common.geometry.S2ShapeIndexRegion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.sedona.common.S2Geography.EncodeOptions;
import org.apache.sedona.common.S2Geography.EncodeTag;
import org.apache.sedona.common.S2Geography.EncodedShapeIndexGeography;
import org.apache.sedona.common.S2Geography.GeographyCollection;
import org.apache.sedona.common.S2Geography.MultiPolygonGeography;
import org.apache.sedona.common.S2Geography.PointGeography;
import org.apache.sedona.common.S2Geography.PolygonGeography;
import org.apache.sedona.common.S2Geography.PolylineGeography;
import org.apache.sedona.common.S2Geography.WKTWriter;
import org.locationtech.jts.geom.PrecisionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Geography {
    private static final Logger logger = LoggerFactory.getLogger((String)Geography.class.getName());
    private static final int BUFFER_SIZE = 4096;
    protected final GeographyKind kind;
    private int srid = 0;

    protected Geography(GeographyKind kind) {
        this.kind = kind;
    }

    public void setSRID(int srid) {
        if (srid < 0) {
            throw new IllegalArgumentException("SRID must be non-negative, got: " + srid);
        }
        this.srid = srid;
    }

    public int getSRID() {
        return this.srid;
    }

    public int getKind() {
        return this.kind.getKind();
    }

    public abstract int dimension();

    protected final int computeDimensionFromShapes() {
        if (this.numShapes() == 0) {
            return -1;
        }
        int dim = this.shape(0).dimension();
        for (int i = 1; i < this.numShapes(); ++i) {
            if (dim == this.shape(i).dimension()) continue;
            return -1;
        }
        return dim;
    }

    public abstract int numShapes();

    public abstract S2Shape shape(int var1);

    public abstract S2Region region();

    public void getCellUnionBound(List<S2CellId> cellIds) {
        S2ShapeIndex index = new S2ShapeIndex();
        for (int i = 0; i < this.numShapes(); ++i) {
            index.add(this.shape(i));
        }
        S2ShapeIndexRegion region = new S2ShapeIndexRegion(index);
        region.getCellUnionBound(cellIds);
    }

    public String toString() {
        return this.toText(new PrecisionModel(PrecisionModel.FIXED));
    }

    public String toString(PrecisionModel precisionModel) {
        return this.toText(precisionModel);
    }

    public String toText(PrecisionModel precisionModel) {
        WKTWriter writer = new WKTWriter();
        writer.setPrecisionModel(precisionModel);
        return writer.write(this);
    }

    public String toEWKT() {
        return this.toEWKT(new PrecisionModel(PrecisionModel.FIXED));
    }

    public String toEWKT(PrecisionModel precisionModel) {
        WKTWriter writer = new WKTWriter(true);
        writer.setPrecisionModel(precisionModel);
        return writer.write(this);
    }

    public void encodeTagged(OutputStream os, EncodeOptions opts) throws IOException {
        UnsafeOutput out = new UnsafeOutput(os, 4096);
        EncodeTag tag = new EncodeTag(opts);
        ArrayList<S2CellId> cover = new ArrayList<S2CellId>();
        if (this.numShapes() == 0) {
            tag.setKind(GeographyKind.fromKind(this.kind.kind));
            tag.setFlags((byte)(tag.getFlags() | 1));
            tag.setCoveringSize((byte)0);
            tag.encode((Output)out);
            out.writeInt(this.getSRID());
            out.flush();
            return;
        }
        if (opts.isIncludeCovering()) {
            this.getCellUnionBound(cover);
            if (cover.size() > 256) {
                cover.clear();
                logger.warn("Covering size too large (> 256) \u2014 clear Covering");
            }
        }
        tag.setKind(GeographyKind.fromKind(this.kind.kind));
        tag.setCoveringSize((byte)cover.size());
        tag.encode((Output)out);
        for (S2CellId c2 : cover) {
            out.writeLong(c2.id());
        }
        this.encode(out, opts);
        out.writeInt(this.getSRID());
        out.flush();
    }

    public static Geography decodeTagged(InputStream is) throws IOException {
        UnsafeInput kryoIn = new UnsafeInput(is, 4096);
        EncodeTag topTag = EncodeTag.decode((Input)kryoIn);
        return Geography.decode(kryoIn, topTag);
    }

    public static Geography decode(UnsafeInput in, EncodeTag tag) throws IOException {
        Geography geo;
        switch (tag.getKind()) {
            case CELL_CENTER: 
            case POINT: 
            case SINGLEPOINT: {
                geo = PointGeography.decode(in, tag);
                break;
            }
            case POLYLINE: 
            case SINGLEPOLYLINE: {
                geo = PolylineGeography.decode(in, tag);
                break;
            }
            case POLYGON: {
                geo = PolygonGeography.decode(in, tag);
                break;
            }
            case MULTIPOLYGON: {
                geo = MultiPolygonGeography.decode(in, tag);
                break;
            }
            case GEOGRAPHY_COLLECTION: {
                geo = GeographyCollection.decode(in, tag);
                break;
            }
            case SHAPE_INDEX: {
                geo = EncodedShapeIndexGeography.decode(in, tag);
                break;
            }
            default: {
                throw new IOException("Unsupported GeographyKind for decoding: " + tag.getKind());
            }
        }
        geo.setSRID(in.readInt());
        return geo;
    }

    public abstract void encode(UnsafeOutput var1, EncodeOptions var2) throws IOException;

    public static enum GeographyKind {
        UNINITIALIZED(0),
        POINT(1),
        POLYLINE(2),
        POLYGON(3),
        GEOGRAPHY_COLLECTION(4),
        SHAPE_INDEX(5),
        ENCODED_SHAPE_INDEX(6),
        CELL_CENTER(7),
        SINGLEPOINT(8),
        SINGLEPOLYLINE(9),
        MULTIPOLYGON(10);

        private final int kind;

        private GeographyKind(int kind) {
            this.kind = kind;
        }

        public int getKind() {
            return this.kind;
        }

        public static GeographyKind fromKind(int kind) {
            for (GeographyKind k : GeographyKind.values()) {
                if (k.getKind() != kind) continue;
                return k;
            }
            throw new IllegalArgumentException("Unknown GeographyKind: " + kind);
        }
    }
}

