/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.joinJudgement;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sedona.core.enums.DistanceMetric;
import org.apache.sedona.core.joinJudgement.InMemoryKNNJoinIterator;
import org.apache.sedona.core.joinJudgement.JudgementBase;
import org.apache.sedona.core.knnJudgement.EuclideanItemDistance;
import org.apache.sedona.core.knnJudgement.HaversineItemDistance;
import org.apache.sedona.core.knnJudgement.SpheroidDistance;
import org.apache.spark.api.java.function.FlatMapFunction2;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.util.LongAccumulator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.strtree.GeometryItemDistance;
import org.locationtech.jts.index.strtree.ItemDistance;
import org.locationtech.jts.index.strtree.STRtree;

public class KnnJoinIndexJudgement<T extends Geometry, U extends Geometry>
extends JudgementBase<T, U>
implements FlatMapFunction2<Iterator<T>, Iterator<U>, Pair<T, U>>,
Serializable {
    private final int k;
    private final DistanceMetric distanceMetric;
    private final boolean includeTies;
    private final Broadcast<List<T>> broadcastQueryObjects;
    private final Broadcast<STRtree> broadcastObjectsTreeIndex;

    public KnnJoinIndexJudgement(int k, DistanceMetric distanceMetric, boolean includeTies, Broadcast<List<T>> broadcastQueryObjects, Broadcast<STRtree> broadcastObjectsTreeIndex, LongAccumulator buildCount, LongAccumulator streamCount, LongAccumulator resultCount, LongAccumulator candidateCount) {
        super(null, buildCount, streamCount, resultCount, candidateCount);
        this.k = k;
        this.distanceMetric = distanceMetric;
        this.includeTies = includeTies;
        this.broadcastQueryObjects = broadcastQueryObjects;
        this.broadcastObjectsTreeIndex = broadcastObjectsTreeIndex;
    }

    public Iterator<Pair<T, U>> call(Iterator<T> queryShapes, Iterator<U> objectShapes) throws Exception {
        if (!objectShapes.hasNext() || queryShapes != null && !queryShapes.hasNext()) {
            this.buildCount.add(0L);
            this.streamCount.add(0L);
            this.resultCount.add(0L);
            this.candidateCount.add(0L);
            return Collections.emptyIterator();
        }
        STRtree strTree = this.buildSTRtree(objectShapes);
        return new InMemoryKNNJoinIterator(queryShapes, strTree, this.k, this.distanceMetric, this.includeTies, this.streamCount, this.resultCount);
    }

    public Iterator<Pair<T, U>> callUsingBroadcastObjectIndex(Iterator<T> queryShapes) {
        if (!queryShapes.hasNext()) {
            this.buildCount.add(0L);
            this.streamCount.add(0L);
            this.resultCount.add(0L);
            this.candidateCount.add(0L);
            return Collections.emptyIterator();
        }
        STRtree strTree = (STRtree)this.broadcastObjectsTreeIndex.getValue();
        return new InMemoryKNNJoinIterator(queryShapes, strTree, this.k, this.distanceMetric, this.includeTies, this.streamCount, this.resultCount);
    }

    public Iterator<Pair<T, U>> callUsingBroadcastQueryList(Iterator<U> objectShapes) {
        if (!objectShapes.hasNext()) {
            this.buildCount.add(0L);
            this.streamCount.add(0L);
            this.resultCount.add(0L);
            this.candidateCount.add(0L);
            return Collections.emptyIterator();
        }
        List queryItems = (List)this.broadcastQueryObjects.getValue();
        STRtree strTree = this.buildSTRtree(objectShapes);
        return new InMemoryKNNJoinIterator(queryItems.iterator(), strTree, this.k, this.distanceMetric, this.includeTies, this.streamCount, this.resultCount);
    }

    private STRtree buildSTRtree(Iterator<U> objectShapes) {
        STRtree strTree = new STRtree();
        while (objectShapes.hasNext()) {
            Geometry spatialObject = (Geometry)objectShapes.next();
            strTree.insert(spatialObject.getEnvelopeInternal(), (Object)spatialObject);
            this.buildCount.add(1L);
        }
        strTree.build();
        return strTree;
    }

    public static double distanceByMetric(Geometry queryGeom, Geometry candidateGeom, DistanceMetric distanceMetric) {
        switch (distanceMetric) {
            case EUCLIDEAN: {
                EuclideanItemDistance euclideanItemDistance = new EuclideanItemDistance();
                return euclideanItemDistance.distance(queryGeom, candidateGeom);
            }
            case HAVERSINE: {
                HaversineItemDistance haversineItemDistance = new HaversineItemDistance();
                return haversineItemDistance.distance(queryGeom, candidateGeom);
            }
            case SPHEROID: {
                SpheroidDistance spheroidDistance = new SpheroidDistance();
                return spheroidDistance.distance(queryGeom, candidateGeom);
            }
        }
        return queryGeom.distance(candidateGeom);
    }

    public static ItemDistance getItemDistanceByMetric(DistanceMetric distanceMetric) {
        Object itemDistance;
        switch (distanceMetric) {
            case EUCLIDEAN: {
                itemDistance = new EuclideanItemDistance();
                break;
            }
            case HAVERSINE: {
                itemDistance = new HaversineItemDistance();
                break;
            }
            case SPHEROID: {
                itemDistance = new SpheroidDistance();
                break;
            }
            default: {
                itemDistance = new GeometryItemDistance();
            }
        }
        return itemDistance;
    }

    public static <U extends Geometry, T extends Geometry> double distance(U key, T value, DistanceMetric distanceMetric) {
        switch (distanceMetric) {
            case EUCLIDEAN: {
                return new EuclideanItemDistance().distance(key, value);
            }
            case HAVERSINE: {
                return new HaversineItemDistance().distance(key, value);
            }
            case SPHEROID: {
                return new SpheroidDistance().distance(key, value);
            }
        }
        return new EuclideanItemDistance().distance(key, value);
    }

    public static ItemDistance getItemDistance(DistanceMetric distanceMetric) {
        ItemDistance itemDistance = KnnJoinIndexJudgement.getItemDistanceByMetric(distanceMetric);
        return itemDistance;
    }
}

