/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.simpgeometry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.sedona.shaded.guava.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft2.simpgeometry.CFPoint;
import ucar.nc2.ft2.simpgeometry.CFSimpleGeometryHelper;
import ucar.nc2.ft2.simpgeometry.GeometryType;
import ucar.nc2.ft2.simpgeometry.Point;
import ucar.nc2.ft2.simpgeometry.Polygon;
import ucar.nc2.ft2.simpgeometry.SimpleGeometryIndexFinder;
import ucar.nc2.ft2.simpgeometry.exception.InvalidDataseriesException;

public class CFPolygon
implements Polygon {
    private Logger cfpl = LoggerFactory.getLogger(CFPolygon.class);
    private List<Point> points;
    private Polygon next;
    private Polygon prev;
    private boolean isInteriorRing;
    private Array data;

    public GeometryType getGeometryType() {
        return GeometryType.POLYGON;
    }

    @Override
    public List<Point> getPoints() {
        return this.points;
    }

    @Override
    public Array getData() {
        return this.data;
    }

    @Override
    public Polygon getNext() {
        return this.next;
    }

    @Override
    public Polygon getPrev() {
        return this.prev;
    }

    @Override
    public boolean getInteriorRing() {
        return this.isInteriorRing;
    }

    @Override
    public void addPoint(double x, double y) {
        Point ptPrev = null;
        if (!this.points.isEmpty()) {
            ptPrev = this.points.get(this.points.size() - 1);
        }
        this.points.add(new CFPoint(x, y, ptPrev, null, null));
    }

    @Override
    public void setData(Array data) {
        this.data = data;
    }

    @Override
    public void setNext(Polygon next) {
        if (next instanceof CFPolygon) {
            this.setNext((CFPolygon)next);
        } else {
            this.next = next;
        }
    }

    protected void setNext(CFPolygon next) {
        this.next = next;
        if (next != null) {
            next.setPrevOnce(this);
        }
    }

    private void setNextOnce(CFPolygon next) {
        this.next = next;
    }

    @Override
    public void setPrev(Polygon prev) {
        if (prev instanceof CFPolygon) {
            this.setPrev((CFPolygon)prev);
        } else {
            this.prev = prev;
        }
    }

    public void setPrev(CFPolygon prev) {
        this.prev = prev;
        if (prev != null) {
            prev.setNextOnce(this);
        }
    }

    private void setPrevOnce(CFPolygon prev) {
        this.prev = prev;
    }

    @Override
    public void setInteriorRing(boolean interior) {
        this.isInteriorRing = interior;
    }

    @Override
    public Polygon setupPolygon(NetcdfDataset dataset, Variable polyvar, int index) {
        block28: {
            String interiorRingsStr;
            this.points.clear();
            Variable partNodeCounts = null;
            Variable interiorRings = null;
            ImmutableList<CoordinateAxis> axes = dataset.getCoordinateAxes();
            CoordinateAxis x = null;
            CoordinateAxis y = null;
            String[] nodeCoords = polyvar.attributes().findAttributeString("node_coordinates", "").split(" ");
            for (CoordinateAxis ax : axes) {
                if (ax.getFullName().equals(nodeCoords[0])) {
                    x = ax;
                }
                if (!ax.getFullName().equals(nodeCoords[1])) continue;
                y = ax;
            }
            String nodeCoStr = polyvar.findAttributeString("node_count", "");
            if (nodeCoStr.equals("")) {
                return null;
            }
            Variable nodeCounts = dataset.findVariable(nodeCoStr);
            String pNodeCoStr = polyvar.findAttributeString("part_node_count", "");
            if (!pNodeCoStr.equals("")) {
                partNodeCounts = dataset.findVariable(pNodeCoStr);
            }
            if (!(interiorRingsStr = polyvar.findAttributeString("part_node_count", "")).equals("")) {
                interiorRings = dataset.findVariable(interiorRingsStr);
            }
            SimpleGeometryIndexFinder indexFinder = new SimpleGeometryIndexFinder(nodeCounts);
            int lower = indexFinder.getBeginning(index);
            int upper = indexFinder.getEnd(index);
            try {
                Array xPts = x.read(lower + ":" + upper).reduce();
                Array yPts = y.read(lower + ":" + upper).reduce();
                IndexIterator itrX = xPts.getIndexIterator();
                IndexIterator itrY = yPts.getIndexIterator();
                if (partNodeCounts == null) {
                    this.next = null;
                    this.prev = null;
                    this.isInteriorRing = false;
                    while (itrX.hasNext()) {
                        this.addPoint(itrX.getDoubleNext(), itrY.getDoubleNext());
                    }
                    switch (polyvar.getRank()) {
                        case 2: {
                            this.setData(polyvar.read(CFSimpleGeometryHelper.getSubsetString(polyvar, index)).reduce());
                            break block28;
                        }
                        case 1: {
                            this.setData(polyvar.read("" + index));
                            break block28;
                        }
                        default: {
                            throw new InvalidDataseriesException("Error: Only dataseries of rank 1 or 2 are allowed for simple geometry.");
                        }
                    }
                }
                Polygon tail = this;
                Array pnc = partNodeCounts.read();
                Array ir = null;
                IndexIterator pncItr = pnc.getIndexIterator();
                if (interiorRings != null) {
                    ir = interiorRings.read();
                }
                int pncInd = 0;
                int pncEnd = 0;
                while (pncEnd < lower) {
                    pncEnd += pncItr.getIntNext();
                    ++pncInd;
                }
                while (lower < upper) {
                    int smaller = pnc.getInt(pncInd);
                    if (interiorRings != null) {
                        int interiorRingValue = ir.getInt(pncInd);
                        switch (interiorRingValue) {
                            case 0: {
                                this.setInteriorRing(false);
                                break;
                            }
                            case 1: {
                                this.setInteriorRing(true);
                            }
                        }
                    } else {
                        this.isInteriorRing = false;
                    }
                    while (smaller > 0) {
                        tail.addPoint(itrX.getDoubleNext(), itrY.getDoubleNext());
                        --smaller;
                    }
                    switch (polyvar.getRank()) {
                        case 2: {
                            tail.setData(polyvar.read(CFSimpleGeometryHelper.getSubsetString(polyvar, index)).reduce());
                            break;
                        }
                        case 1: {
                            tail.setData(polyvar.read("" + index));
                            break;
                        }
                        default: {
                            throw new InvalidDataseriesException("Error: Only dataseries of rank 1 or 2 are allowed for simple geometry.");
                        }
                    }
                    lower += tail.getPoints().size();
                    ++pncInd;
                    tail.setNext(new CFPolygon());
                    tail = tail.getNext();
                }
                if ((tail = tail.getPrev()) != null) {
                    tail.setNext(null);
                }
            }
            catch (IOException | InvalidRangeException | InvalidDataseriesException e) {
                this.cfpl.error(e.getMessage());
                return null;
            }
        }
        return this;
    }

    @Override
    public double[] getBBUpper() {
        double[] bbUpper = new double[2];
        List<Point> ptList = this.getPoints();
        if (ptList.isEmpty()) {
            return null;
        }
        bbUpper[0] = ptList.get(0).getY();
        bbUpper[1] = ptList.get(0).getY();
        for (Point pt : this.getPoints()) {
            if (bbUpper[0] < pt.getX()) {
                bbUpper[0] = pt.getX();
            }
            if (!(bbUpper[1] < pt.getY())) continue;
            bbUpper[1] = pt.getY();
        }
        bbUpper[0] = bbUpper[0] + 10.0;
        bbUpper[1] = bbUpper[1] + 10.0;
        return bbUpper;
    }

    @Override
    public double[] getBBLower() {
        double[] bbLower = new double[2];
        List<Point> ptList = this.getPoints();
        if (ptList.isEmpty()) {
            return null;
        }
        bbLower[0] = ptList.get(0).getY();
        bbLower[1] = ptList.get(0).getY();
        for (Point pt : this.getPoints()) {
            if (bbLower[0] > pt.getX()) {
                bbLower[0] = pt.getX();
            }
            if (!(bbLower[1] > pt.getY())) continue;
            bbLower[1] = pt.getY();
        }
        bbLower[0] = bbLower[0] - 10.0;
        bbLower[1] = bbLower[1] - 10.0;
        return bbLower;
    }

    public CFPolygon() {
        this.points = new ArrayList<Point>();
        this.next = null;
        this.prev = null;
        this.isInteriorRing = false;
        this.data = null;
    }

    public CFPolygon(List<Point> points) {
        this.points = points;
        this.next = null;
        this.prev = null;
        this.isInteriorRing = false;
        this.data = null;
    }
}

