/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SimplePopup {
    DefaultListModel dlm = new DefaultListModel();
    MouseEvent evt;

    public SimplePopup(MouseEvent evt) {
        this.evt = evt;
    }

    public void add(String simpleName, Runnable runnable) {
        for (int i = 0; i < this.dlm.getSize(); ++i) {
            if (this.dlm.get(i).toString().compareTo(simpleName) != 0) continue;
            return;
        }
        this.dlm.addElement(new Clickable(simpleName, runnable));
    }

    public void add(Runnable runnable) {
        this.add(runnable.toString(), runnable);
    }

    public void addAll(List<Runnable> runs) {
        if (runs == null) {
            return;
        }
        for (Runnable r : runs) {
            this.add(r);
        }
    }

    public void show() {
        DefaultListModel<1> toShow = this.dlm;
        if (this.dlm.isEmpty()) {
            toShow = new DefaultListModel<1>();
            toShow.add(0, new Runnable(){

                @Override
                public void run() {
                }

                public String toString() {
                    return "nothing found";
                }
            });
        }
        Point pt = this.evt.getPoint();
        SwingUtilities.convertPointToScreen(pt, this.evt.getComponent());
        final JList list = new JList(toShow);
        list.setBorder(new LineBorder(new Color(100, 100, 100)));
        final Popup pop = PopupFactory.getSharedInstance().getPopup(this.evt.getComponent(), list, pt.x - 10, pt.y - 10);
        pop.show();
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                pop.hide();
            }
        });
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                Object o = list.getSelectedValue();
                if (o != null && o instanceof Clickable) {
                    ((Clickable)o).runnable.run();
                }
                pop.hide();
            }
        });
    }

    class Clickable {
        String name;
        Runnable runnable;

        public Clickable(String name, Runnable runnable) {
            this.name = name;
            this.runnable = runnable;
        }

        public String toString() {
            return this.name;
        }
    }
}

