/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.geom;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.vecmath.Point2d;
import org.twak.utils.Mathz;
import org.twak.utils.Pair;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.MultiMap;

public class UnionWalker {
    public MultiMap<Point2d, Point2d> map = new MultiMap();
    public Set<Pair<Point2d, Point2d>> starts = new LinkedHashSet<Pair<Point2d, Point2d>>();

    public void addEdge(Point2d a, Point2d b, boolean isStart) {
        this.addEdge(a, b);
        if (isStart) {
            this.starts.add(new Pair<Point2d, Point2d>(a, b));
        }
    }

    public void addEdge(Point2d a, Point2d b) {
        if (!a.equals(b) && !this.map.contains(a, b)) {
            this.map.put(a, b);
        }
    }

    public void addEdges(Point2d a, Point2d b) {
        this.addEdge(a, b);
        this.addEdge(b, a);
    }

    public LoopL<Point2d> find() {
        LoopL<Point2d> loopl = new LoopL<Point2d>();
        block0: for (Pair<Point2d, Point2d> s2 : this.starts) {
            Point2d next;
            Loop<Point2d> loop = new Loop<Point2d>();
            Point2d prev = s2.first();
            Point2d current = s2.second();
            Point2d start = s2.second();
            do {
                next = null;
                double angle = -1.7976931348623157E308;
                for (Point2d n : this.map.get(current)) {
                    double iA;
                    if (n == prev || !((iA = Mathz.interiorAngleBetween(prev, current, n)) > angle)) continue;
                    next = n;
                    angle = iA;
                }
                if (next == null) continue block0;
                this.map.remove(current);
                loop.append(new Point2d(next));
                prev = current;
            } while ((current = next) != start);
            loopl.add((Point2d)((Object)loop));
        }
        return loopl;
    }

    public LoopL<Point2d> findAll() {
        LoopL<Point2d> loopl = new LoopL<Point2d>();
        block0: while (!this.map.isEmpty()) {
            Point2d next;
            Point2d current;
            Loop<Point2d> loop = new Loop<Point2d>();
            Point2d prev = this.map.keySet().iterator().next();
            Point2d start = current = this.map.get(prev).iterator().next();
            do {
                next = null;
                double angle = -1.7976931348623157E308;
                for (Point2d n : this.map.get(current)) {
                    double iA = Mathz.interiorAngleBetween(prev, current, n);
                    if (!(iA > angle)) continue;
                    next = n;
                    angle = iA;
                }
                if (next == null) {
                    this.map.remove(prev);
                    continue block0;
                }
                Point2d tmp = new Point2d(0.01, 0.01);
                tmp.add(current);
                this.map.remove(current, next);
                loop.append(new Point2d(next));
                prev = current;
            } while (!(current = next).equals(start));
            loopl.add((Point2d)((Object)loop));
        }
        return loopl;
    }

    public LoopL<Point2d> findAllMinimizing() {
        LoopL<Point2d> loopl = new LoopL<Point2d>();
        block0: while (!this.map.isEmpty()) {
            Point2d next;
            Point2d current;
            Loop<Point2d> loop = new Loop<Point2d>();
            Point2d prev = this.map.keySet().iterator().next();
            Point2d start = current = this.map.get(prev).iterator().next();
            do {
                next = null;
                double angle = Double.MAX_VALUE;
                for (Point2d n : this.map.get(current)) {
                    double iA = Mathz.interiorAngleBetween(prev, current, n);
                    if (!(iA < angle)) continue;
                    next = n;
                    angle = iA;
                }
                if (next == null) {
                    this.map.remove(prev);
                    continue block0;
                }
                Point2d tmp = new Point2d(0.01, 0.01);
                tmp.add(current);
                this.map.remove(current, next);
                loop.append(new Point2d(next));
                prev = current;
            } while (!(current = next).equals(start));
            loopl.add((Point2d)((Object)loop));
        }
        return loopl;
    }

    public static void main(String[] args) {
        Point2d a = new Point2d(0.0, 0.0);
        Point2d b = new Point2d(1.0, 0.0);
        Point2d c = new Point2d(1.0, 1.0);
        Point2d d = new Point2d(0.0, 1.0);
        Point2d y = new Point2d(0.0, 2.0);
        Point2d x = new Point2d(-1.0, 1.0);
        UnionWalker g2 = new UnionWalker();
        g2.addEdge(a, b, true);
        g2.addEdge(b, c, false);
        g2.addEdge(c, d, false);
        g2.addEdge(d, a, false);
        g2.addEdge(d, x, false);
        g2.addEdge(d, y, false);
        for (Loop loop : g2.find()) {
            for (Point2d p : loop) {
                System.out.println(p);
            }
        }
    }

    public String toString() {
        return this.map.toString();
    }
}

