/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.geom;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import org.twak.utils.Line;
import org.twak.utils.Mathz;
import org.twak.utils.Pair;
import org.twak.utils.collections.ConsecutiveItPairs;
import org.twak.utils.collections.ConsecutivePairs;

public class DRectangle {
    public double x;
    public double y;
    public double width;
    public double height;
    public static final Bounds XMIN = Bounds.XMIN;
    public static final Bounds XCEN = Bounds.XCEN;
    public static final Bounds XMAX = Bounds.XMAX;
    public static final Bounds YMIN = Bounds.YMIN;
    public static final Bounds YCEN = Bounds.YCEN;
    public static final Bounds YMAX = Bounds.YMAX;
    public static final Bounds WIDTH = Bounds.WIDTH;
    public static final Bounds HEIGHT = Bounds.HEIGHT;
    public static final Bounds[] perimeterBounds = new Bounds[]{XMIN, XMAX, YMIN, YMAX};
    public static final Direction Left = Direction.Left;
    public static final Direction Top = Direction.Top;

    public DRectangle() {
    }

    public DRectangle(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public DRectangle(double width, double height) {
        this.x = 0.0;
        this.y = 0.0;
        this.width = width;
        this.height = height;
    }

    public DRectangle(DRectangle dr) {
        this(dr.x, dr.y, dr.width, dr.height);
    }

    public DRectangle(Rectangle bounds) {
        this(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public DRectangle(List<Point2d> envelop) {
        this(envelop.get((int)0).x, envelop.get((int)0).y, 0.0, 0.0);
        for (Point2d pt : envelop) {
            this.envelop(pt);
        }
    }

    public DRectangle(Point2d start) {
        this.x = start.x;
        this.y = start.y;
        this.height = 0.0;
        this.width = 0.0;
    }

    public DRectangle(Line line) {
        this(line.start);
        this.envelop(line.end);
    }

    public boolean contains(Tuple2d pt) {
        return this.contains(pt.x, pt.y);
    }

    public boolean contains(double X2, double Y) {
        return X2 >= this.x && X2 <= this.getMaxX() && Y >= this.y && Y <= this.getMaxY();
    }

    public boolean containsAllowingNegative(double X2, double Y) {
        double w = this.width;
        double h2 = this.height;
        if (w < 0.0 || h2 < 0.0) {
            DRectangle pos = this.toPositive();
            return pos.containsAllowingNegative(X2, Y);
        }
        if (X2 < this.x || Y < this.y) {
            return false;
        }
        return ((w += this.x) < this.x || w > X2) && ((h2 += this.y) < this.y || h2 > Y);
    }

    public DRectangle grow(double e) {
        this.x -= e;
        this.y -= e;
        this.width += 2.0 * e;
        this.height += 2.0 * e;
        return this;
    }

    public boolean intersects(DRectangle other) {
        if (this.width <= 0.0 || this.height <= 0.0 || other.width <= 0.0 || other.height <= 0.0) {
            return false;
        }
        return other.x + other.width > this.x && other.y + other.height > this.y && other.x < this.x + this.width && other.y < this.y + this.height;
    }

    public Rectangle toInteger() {
        return new Rectangle((int)this.x, (int)this.y, (int)this.width, (int)this.height);
    }

    public double intersectionOverUnion(DRectangle other) {
        DRectangle sect = this.intersect(other);
        if (sect == null) {
            return 0.0;
        }
        return sect.area() / this.union(other).area();
    }

    public DRectangle toPositive() {
        if (this.width > 0.0 && this.height > 0.0) {
            return this;
        }
        return new DRectangle(this.x + (this.width < 0.0 ? this.width : 0.0), this.y + (this.height < 0.0 ? this.height : 0.0), Math.abs(this.width), Math.abs(this.height));
    }

    public void setFrom(DRectangle rect) {
        this.width = rect.width;
        this.height = rect.height;
        this.x = rect.x;
        this.y = rect.y;
    }

    public double area() {
        return Math.abs(this.width * this.height);
    }

    public double getMaxX() {
        return this.x + this.width;
    }

    public double getMaxY() {
        return this.y + this.height;
    }

    public Point2d getCenter() {
        return new Point2d(this.x + this.width / 2.0, this.y + this.height / 2.0);
    }

    public DRectangle union(DRectangle b) {
        DRectangle out = new DRectangle();
        out.x = Math.min(this.x, b.x);
        out.y = Math.min(this.y, b.y);
        out.width = Math.max(this.getMaxX(), b.getMaxX()) - out.x;
        out.height = Math.max(this.getMaxY(), b.getMaxY()) - out.y;
        return out;
    }

    public DRectangle intersect(DRectangle b) {
        DRectangle out = new DRectangle();
        out.x = Math.max(this.x, b.x);
        out.y = Math.max(this.y, b.y);
        out.width = Math.min(this.getMaxX(), b.getMaxX()) - out.x;
        out.height = Math.min(this.getMaxY(), b.getMaxY()) - out.y;
        if (out.width < 0.0 || out.height < 0.0) {
            return null;
        }
        return out;
    }

    public String toString() {
        return "( " + this.x + " ," + this.y + " ," + this.width + " ," + this.height + ")";
    }

    public boolean sameAs(DRectangle o) {
        return this.x == o.x && this.y == o.y && this.width == o.width && this.height == o.height;
    }

    public void set(Bounds b, double value) {
        this.set(b, value, false);
    }

    public void set(Bounds b, double value, boolean mod) {
        switch (b) {
            case XMIN: {
                double delta = value - this.x;
                this.x = value;
                if (!mod) break;
                this.width -= delta;
                break;
            }
            case XCEN: {
                this.x = value - this.width / 2.0;
                break;
            }
            case XMAX: {
                this.width = value - this.x;
                break;
            }
            case YMIN: {
                double delta = value - this.y;
                this.y = value;
                if (!mod) break;
                this.height -= delta;
                break;
            }
            case YCEN: {
                this.y = value - this.height / 2.0;
                break;
            }
            case YMAX: {
                this.height = value - this.y;
                break;
            }
            case HEIGHT: {
                double delta = this.height - value;
                this.height = value;
                if (!mod) break;
                this.y += delta / 2.0;
                break;
            }
            case WIDTH: {
                double delta = this.width - value;
                this.width = value;
                if (!mod) break;
                this.x += delta / 2.0;
                break;
            }
            default: {
                throw new Error("WtF?");
            }
        }
    }

    public double get(Bounds object) {
        switch (object) {
            case XMIN: {
                return this.x;
            }
            case XCEN: {
                return this.x + this.width / 2.0;
            }
            case XMAX: {
                return this.x + this.width;
            }
            case YMIN: {
                return this.y;
            }
            case YCEN: {
                return this.y + this.height / 2.0;
            }
            case YMAX: {
                return this.y + this.height;
            }
            case WIDTH: {
                return this.width;
            }
            case HEIGHT: {
                return this.height;
            }
        }
        throw new Error("WtF?");
    }

    public Point2d getPoint(Bounds x, Bounds y) {
        return new Point2d(this.get(x), this.get(y));
    }

    public boolean contains(DRectangle r) {
        return this.contains(r.x, r.y) && this.contains(r.x + r.width, r.y) && this.contains(r.x, r.y + r.height) && this.contains(r.x + r.width, r.y + r.height);
    }

    public void envelop(double px, double py) {
        if (px < this.x) {
            this.width += this.x - px;
            this.x = px;
        } else if (px > this.x + this.width) {
            this.width = px - this.x;
        }
        if (py < this.y) {
            this.height += this.y - py;
            this.y = py;
        } else if (py > this.y + this.height) {
            this.height = py - this.y;
        }
    }

    public void envelop(Tuple2d pt) {
        this.envelop(pt.x, pt.y);
    }

    public List<DRectangle> split(boolean dir, WidthGen gen) {
        ArrayList<DRectangle> out = new ArrayList<DRectangle>();
        List<Double> loc = gen.gen(new RectDir(dir, this));
        if (loc.isEmpty()) {
            return out;
        }
        double sum = (dir ? this.width : this.height) / loc.stream().mapToDouble(xx -> xx).sum();
        double o = 0.0;
        for (double d : loc) {
            if (dir) {
                out.add(new DRectangle(o + this.x, this.y, d * sum, this.height));
            } else {
                out.add(new DRectangle(this.x, o + this.y, this.width, d * sum));
            }
            o += d * sum;
        }
        return out;
    }

    public double distance(DRectangle other) {
        double b;
        double a = this.distancea(other);
        if (Math.abs(a - (b = this.distanceb(other))) > 0.1) {
            throw new Error("BUG");
        }
        return b;
    }

    private double distancea(DRectangle other) {
        if (this.intersects(other)) {
            return 0.0;
        }
        double dist = Double.MAX_VALUE;
        for (Pair<Point2d, Point2d> pair : new ConsecutivePairs<Point2d>(Arrays.asList(this.points()), true)) {
            for (Pair<Point2d, Point2d> pair2 : new ConsecutivePairs<Point2d>(Arrays.asList(other.points()), true)) {
                dist = Math.min(dist, new Line(pair2.first(), pair2.second()).distance(new Line(pair.first(), pair.second())));
            }
        }
        return dist;
    }

    private double distanceb(DRectangle other) {
        double xOverlap = Mathz.min(Math.abs(other.x - this.getMaxX()), Math.abs(this.x - other.getMaxX()));
        if (other.x + other.width > this.x && other.x < this.x + this.width) {
            xOverlap = 0.0;
        }
        double yOverlap = Mathz.min(Math.abs(other.y - this.getMaxY()), Math.abs(this.y - other.getMaxY()));
        if (other.y + other.height > this.y && other.y < this.y + this.height) {
            yOverlap = 0.0;
        }
        if (xOverlap == 0.0) {
            return yOverlap;
        }
        if (yOverlap == 0.0) {
            return xOverlap;
        }
        return Math.sqrt(xOverlap * xOverlap + yOverlap * yOverlap);
    }

    public double distance(Line ray) {
        double dist = Double.MAX_VALUE;
        if (this.contains(ray.start) || this.contains(ray.end)) {
            return 0.0;
        }
        for (Pair<Point2d, Point2d> pair : new ConsecutiveItPairs<Point2d>(Arrays.asList(this.points()))) {
            dist = Math.min(dist, new Line(pair.first(), pair.second()).distance(ray));
        }
        return dist;
    }

    public List<DRectangle> splitX(WidthGen gen) {
        return this.split(true, gen);
    }

    public List<DRectangle> splitY(double l) {
        ArrayList<DRectangle> out = new ArrayList<DRectangle>();
        if (l > this.height) {
            out.add(new DRectangle(this));
        } else {
            out.add(new DRectangle(this.x, this.y, this.width, l));
            out.add(new DRectangle(this.x, this.y + l, this.width, this.height - l));
        }
        return out;
    }

    public List<DRectangle> splitY(WidthGen gen) {
        return this.split(false, gen);
    }

    public List<DRectangle> splitX(double l) {
        ArrayList<DRectangle> out = new ArrayList<DRectangle>();
        if (l > this.width) {
            out.add(new DRectangle(this));
        } else {
            out.add(new DRectangle(this.x, this.y, l, this.height));
            out.add(new DRectangle(this.x + l, this.y, this.width - l, this.height));
        }
        return out;
    }

    public Line getEdge(Bounds b) {
        switch (b) {
            case XMAX: {
                return new Line(this.get(Bounds.XMAX), this.get(Bounds.YMIN), this.get(Bounds.XMAX), this.get(Bounds.YMAX));
            }
            case XMIN: {
                return new Line(this.get(Bounds.XMIN), this.get(Bounds.YMIN), this.get(Bounds.XMIN), this.get(Bounds.YMAX));
            }
            case YMAX: {
                return new Line(this.get(Bounds.XMIN), this.get(Bounds.YMAX), this.get(Bounds.XMAX), this.get(Bounds.YMAX));
            }
            case YMIN: {
                return new Line(this.get(Bounds.XMIN), this.get(Bounds.YMIN), this.get(Bounds.XMAX), this.get(Bounds.YMIN));
            }
        }
        throw new Error();
    }

    public Point2d[] points() {
        return new Point2d[]{new Point2d(this.x, this.y), new Point2d(this.x, this.y + this.height), new Point2d(this.x + this.width, this.y + this.height), new Point2d(this.x + this.width, this.y)};
    }

    public Iterable<Line> lines() {
        ArrayList<Line> out = new ArrayList<Line>();
        out.add(new Line(this.x, this.y, this.x, this.y + this.height));
        out.add(new Line(this.x, this.y + this.height, this.x + this.width, this.y + this.height));
        out.add(new Line(this.x + this.width, this.y + this.height, this.x + this.width, this.y));
        out.add(new Line(this.x + this.width, this.y, this.x, this.y));
        return out;
    }

    public float heightF() {
        return (float)this.height;
    }

    public float widthF() {
        return (float)this.width;
    }

    public float xF() {
        return (float)this.x;
    }

    public float yF() {
        return (float)this.y;
    }

    public int heightI() {
        return (int)this.height;
    }

    public int widthI() {
        return (int)this.width;
    }

    public int xI() {
        return (int)this.x;
    }

    public int yI() {
        return (int)this.y;
    }

    public static Comparator<DRectangle> comparator(final Bounds bounds, final boolean ascending) {
        return new Comparator<DRectangle>(){

            private double score(DRectangle d) {
                return d.get(bounds) * (double)(ascending ? 1 : -1);
            }

            @Override
            public int compare(DRectangle o1, DRectangle o2) {
                return Double.compare(this.score(o1), this.score(o2));
            }
        };
    }

    public static Comparator<DRectangle> comparatorArea(final boolean ascending) {
        return new Comparator<DRectangle>(){

            private double score(DRectangle d) {
                return d.area() * (double)(ascending ? 1 : -1);
            }

            @Override
            public int compare(DRectangle o1, DRectangle o2) {
                return Double.compare(this.score(o1), this.score(o2));
            }
        };
    }

    public double distance(Point2d screenPt) {
        if (this.contains(screenPt)) {
            return 0.0;
        }
        return this.distanceFromBorder(screenPt);
    }

    public double distanceFromBorder(Point2d screenPt) {
        Point2d[] pts = this.points();
        double out = Double.MAX_VALUE;
        for (int i = 0; i < pts.length; ++i) {
            out = Math.min(out, new Line(pts[i], pts[(i + 1) % pts.length]).distance(screenPt));
        }
        return out;
    }

    public DRectangle normalize(DRectangle rect) {
        DRectangle out = new DRectangle(rect);
        out.x = (out.x - this.x) / this.width;
        out.y = (out.y - this.y) / this.height;
        out.width /= this.width;
        out.height /= this.height;
        return out;
    }

    public Point2d normalize(Point2d p) {
        return new Point2d((p.x - this.x) / this.width, (p.y - this.y) / this.height);
    }

    public Point2d transform(Point2d p) {
        return new Point2d(p.x * this.width + this.x, p.y * this.height + this.y);
    }

    public DRectangle transform(DRectangle rect) {
        DRectangle out = new DRectangle(rect);
        out.x = out.x * this.width + this.x;
        out.y = out.y * this.height + this.y;
        out.width *= this.width;
        out.height *= this.height;
        return out;
    }

    public DRectangle scale(double s2) {
        DRectangle t = new DRectangle(this);
        t.x *= s2;
        t.height *= s2;
        t.y *= s2;
        t.width *= s2;
        return t;
    }

    public DRectangle transform(DRectangle src, DRectangle dest) {
        DRectangle out = new DRectangle(this);
        out.x = (out.x - src.x) / src.width;
        out.y = (out.y - src.y) / src.height;
        out.width /= src.width;
        out.height /= src.height;
        out.x = out.x * dest.width + dest.x;
        out.y = out.y * dest.height + dest.y;
        out.width *= dest.width;
        out.height *= dest.height;
        return out;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DRectangle)) {
            return false;
        }
        DRectangle o = (DRectangle)obj;
        return o.x == this.x && o.y == this.y && o.width == this.width && o.height == this.height;
    }

    public static class Enveloper
    extends DRectangle {
        boolean seen = false;

        @Override
        public void envelop(Tuple2d pt) {
            if (!this.seen) {
                this.x = pt.x;
                this.y = pt.y;
                this.height = 0.0;
                this.width = 0.0;
                this.seen = true;
            } else {
                super.envelop(pt);
            }
        }

        public void envelop(DRectangle bb) {
            for (Point2d p : bb.points()) {
                this.envelop(p);
            }
        }

        public void envelop(Point q) {
            this.envelop(new Point2d(q.x, q.y));
        }
    }

    public static interface WidthGen {
        public List<Double> gen(RectDir var1);
    }

    public static class RectDir {
        public boolean dirX;
        public DRectangle rect;

        public RectDir(boolean dir, DRectangle rect) {
            this.rect = rect;
            this.dirX = dir;
        }
    }

    public static enum Direction {
        Left,
        Top;

    }

    public static class FromComparator
    implements Comparator<DRectangle> {
        Direction dir;

        public FromComparator(Direction l) {
            this.dir = l;
        }

        @Override
        public int compare(DRectangle arg0, DRectangle arg1) {
            switch (this.dir) {
                case Left: {
                    return Double.compare(arg0.x, arg1.x);
                }
            }
            return Double.compare(arg0.y, arg1.y);
        }
    }

    public static enum Bounds {
        XMIN(-1),
        XCEN(0),
        XMAX(1),
        YMIN(-1),
        YCEN(0),
        YMAX(1),
        WIDTH(0),
        HEIGHT(0);

        int sign;

        private Bounds(int sign) {
            this.sign = sign;
        }

        public int sign() {
            return this.sign;
        }

        public Bounds flip() {
            switch (this) {
                case XMIN: {
                    return XMAX;
                }
                case XMAX: {
                    return XMIN;
                }
                case YMIN: {
                    return YMAX;
                }
                case YMAX: {
                    return YMIN;
                }
            }
            return null;
        }

        public boolean isX() {
            switch (this) {
                case XMIN: {
                    return true;
                }
                case XMAX: {
                    return true;
                }
                case XCEN: {
                    return true;
                }
                case YMIN: {
                    return false;
                }
                case YMAX: {
                    return false;
                }
                case YCEN: {
                    return false;
                }
            }
            throw new Error();
        }

        public boolean isY() {
            return !this.isX();
        }

        public Bounds next() {
            switch (this) {
                case XMIN: {
                    return YMIN;
                }
                case YMIN: {
                    return XMAX;
                }
                case XMAX: {
                    return YMAX;
                }
                case YMAX: {
                    return XMIN;
                }
            }
            return null;
        }

        public Bounds length() {
            switch (this) {
                case XMIN: 
                case XMAX: {
                    return HEIGHT;
                }
                case YMIN: 
                case YMAX: {
                    return WIDTH;
                }
            }
            return null;
        }
    }
}

