/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.twak.utils.LContext;
import org.twak.utils.collections.ItIt;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.Loopable;

public class LoopL<E>
extends ArrayList<Loop<E>> {
    public LoopL() {
    }

    public LoopL(Loop<E> fromPoints) {
        this();
        this.add(fromPoints);
    }

    public LoopL(LoopL<E> toClone) {
        this();
        for (Loop loop : toClone) {
            this.add(new Loop(loop));
        }
    }

    public LoopL(List<Loop<E>> toClone) {
        this();
        for (Loop<E> loop : toClone) {
            this.add(new Loop<E>(loop));
        }
    }

    public Iterable<E> eIterator() {
        return new EIterable();
    }

    public void addLoopL(LoopL<E> e) {
        this.addAll(e);
    }

    public int count() {
        int i = 0;
        for (Loop l : this) {
            for (Object e : l) {
                ++i;
            }
        }
        return i;
    }

    public void reverseEachLoop() {
        for (Loop loop : this) {
            loop.reverse();
        }
    }

    public Iterator<LContext<E>> getCIterator() {
        return new ContextIt();
    }

    public Iterable<LContext<E>> getCIterable() {
        return new Iterable<LContext<E>>(){

            @Override
            public Iterator<LContext<E>> iterator() {
                return LoopL.this.getCIterator();
            }
        };
    }

    public Iterator<Loopable<E>> getLoopableIterator() {
        return new LoopableLIterator();
    }

    public Iterable<Loopable<E>> getLoopableIterable() {
        return new Iterable<Loopable<E>>(){

            @Override
            public Iterator<Loopable<E>> iterator() {
                return new LoopableLIterator();
            }
        };
    }

    public LoopLoopable<E> find(E e) {
        for (Loop loop : this) {
            Loopable<E> lp = loop.find(e);
            if (lp == null) continue;
            return new LoopLoopable(loop, lp);
        }
        return null;
    }

    public Stream<E> streamE() {
        return this.stream().flatMap(l -> l.stream());
    }

    public Loop<E> loop() {
        Loop out = new Loop();
        this.add(out);
        return out;
    }

    public Loop<E> newLoop() {
        Loop out = new Loop();
        this.add(out);
        return out;
    }

    @Override
    public boolean isEmpty() {
        for (Loop loop : this) {
            Iterator iterator = loop.iterator();
            if (!iterator.hasNext()) continue;
            Object e = iterator.next();
            return false;
        }
        return true;
    }

    public static class LoopLoopable<E> {
        public Loop<E> loop;
        public Loopable<E> loopable;

        public LoopLoopable(Loop loop, Loopable loopable) {
            this.loop = loop;
            this.loopable = loopable;
        }
    }

    public abstract class Map<O> {
        public LoopL<O> run() {
            LoopL out = new LoopL();
            for (Loop loopE : LoopL.this) {
                Loop<Object> loopO = new Loop<Object>();
                out.add(loopO);
                for (Loopable loopable : loopE.loopableIterator()) {
                    loopO.append(this.map(loopable));
                }
                for (Loop loop : loopE.holes) {
                    Loop<Object> loopHoleO = new Loop<Object>();
                    for (Loopable e : loop.loopableIterator()) {
                        loopHoleO.append(this.map(e));
                    }
                    loopO.holes.add(loopHoleO);
                }
            }
            return out;
        }

        public abstract O map(Loopable<E> var1);
    }

    public class LoopableLIterator
    implements Iterator<Loopable<E>> {
        Iterator<Loop<E>> loopIt = null;
        Iterator<Loopable<E>> loopableIt = null;
        Loopable<E> loopable;
        Loop<E> loop;

        public LoopableLIterator() {
            this.loopIt = LoopL.this.iterator();
            this.findNext();
        }

        private void findNext() {
            if (this.loopIt == null) {
                return;
            }
            if (this.loopableIt != null && this.loopableIt.hasNext()) {
                this.loopable = this.loopableIt.next();
            } else if (this.loopIt.hasNext()) {
                this.loop = this.loopIt.next();
                this.loopableIt = this.loop.loopableIterator().iterator();
                this.findNext();
            } else {
                this.loopIt = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.loopIt != null;
        }

        @Override
        public Loopable<E> next() {
            Loopable out = this.loopable;
            this.findNext();
            return out;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public class ContextIt
    implements Iterator<LContext<E>> {
        Iterator<Loop<E>> loopIt = null;
        Iterator<Loopable<E>> loopableIt = null;
        Loopable<E> loopable;
        Loop<E> loop;

        public ContextIt() {
            this.loopIt = LoopL.this.iterator();
            this.findNext();
        }

        private void findNext() {
            if (this.loopIt == null) {
                return;
            }
            if (this.loopableIt != null && this.loopableIt.hasNext()) {
                this.loopable = this.loopableIt.next();
            } else if (this.loopIt.hasNext()) {
                this.loop = this.loopIt.next();
                this.loopableIt = this.loop.loopableIterator().iterator();
                this.findNext();
            } else {
                this.loopIt = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.loopIt != null;
        }

        @Override
        public LContext next() {
            LContext out = new LContext(this.loopable, this.loop);
            this.findNext();
            return out;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public class EIterable
    implements Iterable<E> {
        @Override
        public Iterator<E> iterator() {
            return new ItIt(LoopL.this);
        }
    }
}

