/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils;

import java.awt.Point;
import java.io.Serializable;
import java.util.Comparator;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.twak.utils.Mathz;
import org.twak.utils.geom.Anglez;
import org.twak.utils.geom.LinearForm;

public class Line
implements Serializable {
    public Point2d start;
    public Point2d end;
    public static Comparator<Line> lineLengthComparator = new Comparator<Line>(){

        @Override
        public int compare(Line o1, Line o2) {
            return Double.compare(o2.lengthSquared(), o1.lengthSquared());
        }
    };

    public Line() {
    }

    public Line(Point2d start, Point2d end) {
        this.start = start;
        this.end = end;
    }

    public Line(Point start, Point end) {
        this.start = new Point2d(start.x, start.y);
        this.end = new Point2d(end.x, end.y);
    }

    public Line(double x1, double y1, double x2, double y2) {
        this(new Point2d(x1, y1), new Point2d(x2, y2));
    }

    public Line(Line line) {
        this(new Point2d(line.start), new Point2d(line.end));
    }

    public Line(LinearForm lf, double pp1, double pp2) {
        this.start = lf.fromPParam(pp1);
        this.end = lf.fromPParam(pp2);
    }

    public Point2d intersects(LinearForm other) {
        Point2d location = new LinearForm(this).intersect(other);
        if (location == null) {
            return null;
        }
        if (location.x >= Math.min(this.start.x, this.end.x) && location.x <= Math.max(this.start.x, this.end.x) && location.y >= Math.min(this.start.y, this.end.y) && location.y <= Math.max(this.start.y, this.end.y)) {
            return location;
        }
        return null;
    }

    public Point2d intersects(Line other) {
        return this.intersects(other, true);
    }

    public Point2d intersects(Line other, boolean doClip) {
        double a1 = this.end.y - this.start.y;
        double b1 = this.start.x - this.end.x;
        double c1 = a1 * this.start.x + b1 * this.start.y;
        double a2 = other.end.y - other.start.y;
        double b2 = other.start.x - other.end.x;
        double c2 = a2 * other.start.x + b2 * other.start.y;
        double det = a1 * b2 - a2 * b1;
        if (det == 0.0) {
            return null;
        }
        double x = (b2 * c1 - b1 * c2) / det;
        double y = (a1 * c2 - a2 * c1) / det;
        if (!doClip) {
            return new Point2d(x, y);
        }
        double tol = 0.0;
        if (x >= Math.min(this.start.x, this.end.x) - tol && x <= Math.max(this.start.x, this.end.x) + tol && y >= Math.min(this.start.y, this.end.y) - tol && y <= Math.max(this.start.y, this.end.y) + tol && x >= Math.min(other.start.x, other.end.x) - tol && x <= Math.max(other.start.x, other.end.x) + tol && y >= Math.min(other.start.y, other.end.y) - tol && y <= Math.max(other.start.y, other.end.y) + tol) {
            return new Point2d(x, y);
        }
        return null;
    }

    public Point2d intersects(Point2d origin, Vector2d dir) {
        double a1 = this.end.y - this.start.y;
        double b1 = this.start.x - this.end.x;
        double c1 = a1 * this.start.x + b1 * this.start.y;
        double a2 = dir.y;
        double b2 = -dir.x;
        double c2 = a2 * origin.x + b2 * origin.y;
        double det = a1 * b2 - a2 * b1;
        if (det == 0.0) {
            return null;
        }
        double x = (b2 * c1 - b1 * c2) / det;
        double y = (a1 * c2 - a2 * c1) / det;
        double tol = 1.0E-6;
        if (x >= Math.min(this.start.x, this.end.x) - tol && x <= Math.max(this.start.x, this.end.x) + tol && y >= Math.min(this.start.y, this.end.y) - tol && y <= Math.max(this.start.y, this.end.y) + tol) {
            Vector2d d = new Vector2d(x, y);
            d.sub(origin);
            if (d.dot(dir) > -tol) {
                return new Point2d(x, y);
            }
        }
        return null;
    }

    public String toString() {
        return "new Line ( new Point2d ( " + this.start.x + "," + this.start.y + "), new Point2d ( " + this.end.x + "," + this.end.y + ")),";
    }

    public double xAtY(double y) {
        double a1 = this.end.y - this.start.y;
        double b1 = this.start.x - this.end.x;
        double c1 = a1 * this.end.x + b1 * this.end.y;
        if (a1 == 0.0) {
            return this.start.x;
        }
        return (c1 - b1 * y) / a1;
    }

    public double yAtX(double x) {
        double a1 = this.end.y - this.start.y;
        double b1 = this.start.x - this.end.x;
        double c1 = a1 * this.end.x + b1 * this.end.y;
        if (b1 == 0.0) {
            return this.start.y;
        }
        return (c1 - a1 * x) / b1;
    }

    public boolean isHoriz() {
        return this.start.y == this.end.y;
    }

    public boolean isVert() {
        return this.start.x == this.end.x;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Line)) {
            return false;
        }
        Line line = (Line)obj;
        return this.start.equals(line.start) && this.end.equals(line.end);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.start != null ? this.start.hashCode() : 0);
        hash = 53 * hash + (this.end != null ? this.end.hashCode() : 0);
        return hash;
    }

    public Point2d getOther(Point2d p) {
        if (this.start.equals(p)) {
            return this.end;
        }
        if (this.end.equals(p)) {
            return this.start;
        }
        if (this.start.equals(this.end)) {
            return this.start;
        }
        throw new Error("There is no other");
    }

    public double lengthSquared() {
        return Math.pow(this.end.x - this.start.x, 2.0) + Math.pow(this.end.y - this.start.y, 2.0);
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double distance(Tuple2d p) {
        return this.distance(p, true);
    }

    public double distance(Tuple2d p, boolean clamp) {
        if (this.start.equals(this.end)) {
            return this.start.distance(new Point2d(p));
        }
        if (clamp) {
            Point2d p2 = this.project(new Point2d(p), clamp);
            return p2.distance(new Point2d(p));
        }
        double num = Math.abs((this.end.x - this.start.x) * (this.start.y - p.y) - (this.start.x - p.x) * (this.end.y - this.start.y));
        double den = this.length();
        if (den == 0.0) {
            return new Point2d(p).distance(this.start);
        }
        return num / den;
    }

    public double findPPram(Point2d pt) {
        Vector2d v1 = new Vector2d(this.end);
        v1.sub(this.start);
        Vector2d v2 = new Vector2d(pt);
        v2.sub(this.start);
        return v1.dot(v2) / v1.dot(v1);
    }

    public Point2d fromPPram(double fParam) {
        if (Double.isNaN(fParam)) {
            return null;
        }
        Vector2d v2 = this.dir();
        v2.scale(fParam);
        v2.add(this.start);
        return new Point2d(v2);
    }

    public Point2d project(Point2d pt, boolean clamp) {
        Vector2d v1 = new Vector2d(this.end);
        v1.sub(this.start);
        Vector2d v2 = new Vector2d(pt);
        v2.sub(this.start);
        double len = v1.length();
        if (len == 0.0) {
            return new Point2d(pt);
        }
        double param = v2.dot(v1) / len;
        if (clamp) {
            param = Mathz.clamp(param, 0.0, len);
        }
        v1.normalize();
        v1.scale(param);
        v1.add(this.start);
        return new Point2d(v1);
    }

    public Vector2d dir() {
        Vector2d out = new Vector2d(this.end);
        out.sub(this.start);
        return out;
    }

    public Line clip(Line line, LinearForm a, LinearForm b) {
        if (line == null) {
            return line;
        }
        Point2d start = line.start;
        Vector2d dir = new Vector2d(line.end);
        dir.sub(line.start);
        double aC = a.intersectsP(start, dir);
        double bC = b.intersectsP(start, dir);
        if (aC < 0.0 && bC < 0.0) {
            return null;
        }
        if (aC > 1.0 && bC > 1.0) {
            return null;
        }
        double s2 = 0.0;
        double e = 1.0;
        if (aC < bC) {
            if (aC < Double.POSITIVE_INFINITY) {
                s2 = Math.max(aC, s2);
            }
            if (bC < Double.POSITIVE_INFINITY) {
                e = Math.min(bC, e);
            }
        } else {
            if (bC < Double.POSITIVE_INFINITY) {
                s2 = Math.max(bC, s2);
            }
            if (aC < Double.POSITIVE_INFINITY) {
                e = Math.min(aC, e);
            }
        }
        Vector2d s22 = new Vector2d(start);
        Vector2d d2 = new Vector2d(dir);
        d2.scale(s2);
        s22.add(d2);
        Vector2d s3 = new Vector2d(start);
        Vector2d d3 = new Vector2d(dir);
        d3.scale(e);
        s3.add(d3);
        return new Line(new Point2d(s22), new Point2d(s3));
    }

    public boolean isOnLeft(Point2d o) {
        Vector2d ov = new Line(this.end, o).dir();
        Vector2d tv = this.dir();
        return tv.x * ov.y - tv.y * ov.x < 0.0;
    }

    public double aTan2() {
        return Math.atan2(this.end.y - this.start.y, this.end.x - this.start.x);
    }

    private static double normAngle(double a) {
        if (a > 1.5707963267948966) {
            a -= Math.PI;
        }
        if (a < -1.5707963267948966) {
            a += Math.PI;
        }
        return a;
    }

    public double absAngle(Line sl) {
        return Anglez.dist(this.aTan2(), sl.aTan2());
    }

    public Point2d[] points() {
        return new Point2d[]{this.start, this.end};
    }

    public Line reverse() {
        return new Line(this.end, this.start);
    }

    public void reverseLocal() {
        Point2d t = this.start;
        this.start = this.end;
        this.end = t;
    }

    public double distance(Line l) {
        if (l.start.equals(l.end)) {
            return this.distance(l.start, true);
        }
        if (this.start.equals(this.end)) {
            return l.distance(this.start, true);
        }
        if (this.intersects(l, true) != null) {
            return 0.0;
        }
        return Mathz.min(l.distance(this.start, true), l.distance(this.end, true), this.distance(l.start, true), this.distance(l.end, true));
    }

    public void moveLeft(double d) {
        Vector2d perp = this.dir();
        perp = new Vector2d(-perp.y, perp.x);
        perp.scale(d / perp.length());
        this.start.add(perp);
        this.end.add(perp);
    }

    public boolean hasNaN() {
        return Double.isNaN(this.start.x) || Double.isNaN(this.start.y) || Double.isNaN(this.end.x) || Double.isNaN(this.end.y);
    }

    public void set(double x1, double y1, double x2, double y2) {
        this.start = new Point2d(x1, y1);
        this.end = new Point2d(x2, y2);
    }

    public static class AlongLineComparator
    implements Comparator<Point2d> {
        Line line;

        public AlongLineComparator(Point2d start, Point2d end) {
            this.line = new Line(start, end);
        }

        @Override
        public int compare(Point2d o1, Point2d o2) {
            return Double.compare(this.line.findPPram(o1), this.line.findPPram(o2));
        }
    }
}

