/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.io.Serializable;
import jsinterop.annotations.JsType;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Shape;

@JsType
public class S2Edge
implements Serializable,
S2Shape {
    private final S2Point start;
    private final S2Point end;

    public S2Edge(S2Point start, S2Point end) {
        this.start = start;
        this.end = end;
    }

    public S2Point getStart() {
        return this.start;
    }

    public S2Point getEnd() {
        return this.end;
    }

    public String toString() {
        return "Edge: (" + this.start.toDegreesString() + " -> " + this.end.toDegreesString() + ")";
    }

    public int hashCode() {
        return this.getStart().hashCode() - this.getEnd().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof S2Edge)) {
            return false;
        }
        S2Edge other = (S2Edge)o;
        return this.getStart().equalsPoint(other.getStart()) && this.getEnd().equalsPoint(other.getEnd());
    }

    @Override
    public int numEdges() {
        return 1;
    }

    @Override
    public void getEdge(int index, S2Shape.MutableEdge result) {
        assert (index == 0);
        result.set(this.start, this.end);
    }

    @Override
    public boolean hasInterior() {
        return false;
    }

    @Override
    public boolean containsOrigin() {
        return false;
    }

    @Override
    public int numChains() {
        return 1;
    }

    @Override
    public int getChainStart(int chainId) {
        Preconditions.checkElementIndex(chainId, this.numChains());
        return 0;
    }

    @Override
    public int getChainLength(int chainId) {
        Preconditions.checkElementIndex(chainId, this.numChains());
        return 1;
    }

    @Override
    public void getChainEdge(int chainId, int offset, S2Shape.MutableEdge result) {
        Preconditions.checkElementIndex(offset, this.getChainLength(chainId));
        result.set(this.start, this.end);
    }

    @Override
    public S2Point getChainVertex(int chainId, int edgeOffset) {
        Preconditions.checkElementIndex(chainId, this.numChains());
        Preconditions.checkElementIndex(edgeOffset, 2);
        return edgeOffset == 0 ? this.start : this.end;
    }

    @Override
    public void getChainPosition(int edgeId, S2Shape.ChainPosition result) {
        Preconditions.checkArgument(edgeId == 0);
        result.set(0, 0);
    }

    @Override
    public int dimension() {
        return 1;
    }
}

