/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.media.jai.RasterFactory;
import org.apache.sedona.common.FunctionsGeoTools;
import org.apache.sedona.common.raster.RasterBandEditors;
import org.apache.sedona.common.raster.Rasterization;
import org.apache.sedona.common.raster.inputstream.ByteArrayImageInputStream;
import org.apache.sedona.common.raster.netcdf.NetCdfReader;
import org.apache.sedona.common.utils.ImageUtils;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.arcgrid.ArcGridReader;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;

public class RasterConstructors {
    public static GridCoverage2D fromArcInfoAsciiGrid(byte[] bytes) throws IOException {
        ArcGridReader reader = new ArcGridReader((Object)new ByteArrayImageInputStream(bytes), new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE));
        return reader.read(null);
    }

    public static GridCoverage2D fromGeoTiff(byte[] bytes) throws IOException {
        GeoTiffReader geoTiffReader = new GeoTiffReader((Object)new ByteArrayImageInputStream(bytes), new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE));
        return geoTiffReader.read(null);
    }

    public static GridCoverage2D fromNetCDF(byte[] bytes, String variableName, String lonDimensionName, String latDimensionName) throws IOException, FactoryException {
        NetcdfFile netcdfFile = RasterConstructors.openNetCdfBytes(bytes);
        return NetCdfReader.getRaster(netcdfFile, variableName, latDimensionName, lonDimensionName);
    }

    public static GridCoverage2D fromNetCDF(byte[] bytes, String recordVariableName) throws IOException, FactoryException {
        NetcdfFile netcdfFile = RasterConstructors.openNetCdfBytes(bytes);
        return NetCdfReader.getRaster(netcdfFile, recordVariableName);
    }

    public static String getRecordInfo(byte[] bytes) throws IOException {
        NetcdfFile netcdfFile = RasterConstructors.openNetCdfBytes(bytes);
        return NetCdfReader.getRecordInfo(netcdfFile);
    }

    private static NetcdfFile openNetCdfBytes(byte[] bytes) throws IOException {
        return NetcdfFiles.openInMemory("", bytes);
    }

    public static GridCoverage2D asRaster(Geometry geom, GridCoverage2D raster, String pixelType, boolean allTouched, double value, Double noDataValue, boolean useGeometryExtent) throws FactoryException {
        List<Object> objects = Rasterization.rasterize(geom, raster, pixelType, value, useGeometryExtent, allTouched);
        WritableRaster writableRaster = (WritableRaster)objects.get(0);
        GridCoverage2D rasterized = (GridCoverage2D)objects.get(1);
        GridCoverage2D resultRaster = RasterUtils.clone(writableRaster, rasterized.getSampleDimensions(), rasterized, noDataValue, false);
        if (noDataValue != null) {
            resultRaster = RasterBandEditors.setBandNoDataValue(resultRaster, 1, noDataValue);
        }
        return resultRaster;
    }

    public static GridCoverage2D asRaster(Geometry geom, GridCoverage2D raster, String pixelType, boolean allTouched, double value, Double noDataValue) throws FactoryException {
        GridCoverage2D result = RasterConstructors.asRaster(geom, raster, pixelType, allTouched, value, noDataValue, true);
        return result;
    }

    public static GridCoverage2D asRaster(Geometry geom, GridCoverage2D raster, String pixelType) throws FactoryException {
        return RasterConstructors.asRaster(geom, raster, pixelType, false, 1.0, null);
    }

    public static GridCoverage2D asRaster(Geometry geom, GridCoverage2D raster, String pixelType, boolean allTouched) throws FactoryException {
        return RasterConstructors.asRaster(geom, raster, pixelType, allTouched, 1.0, null);
    }

    public static GridCoverage2D asRaster(Geometry geom, GridCoverage2D raster, String pixelType, boolean allTouched, double value) throws FactoryException {
        return RasterConstructors.asRaster(geom, raster, pixelType, allTouched, value, null);
    }

    public static GridCoverage2D asRasterWithRasterExtent(Geometry geom, GridCoverage2D raster, String pixelType, boolean allTouched, double value, Double noDataValue) throws FactoryException {
        return RasterConstructors.asRaster(geom, raster, pixelType, allTouched, value, noDataValue, false);
    }

    public static DefaultFeatureCollection getFeatureCollection(Geometry geom, CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName("Raster");
        simpleFeatureTypeBuilder.setCRS(crs);
        simpleFeatureTypeBuilder.add("geometry", Geometry.class);
        SimpleFeatureType featureType = simpleFeatureTypeBuilder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        featureBuilder.add((Object)geom);
        SimpleFeature simpleFeature = featureBuilder.buildFeature("1");
        DefaultFeatureCollection featureCollection = new DefaultFeatureCollection();
        featureCollection.add(simpleFeature);
        return featureCollection;
    }

    public static GridCoverage2D makeEmptyRaster(int numBand, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double pixelSize) throws FactoryException {
        return RasterConstructors.makeEmptyRaster(numBand, widthInPixel, heightInPixel, upperLeftX, upperLeftY, pixelSize, -pixelSize, 0.0, 0.0, 0);
    }

    public static GridCoverage2D makeEmptyRaster(int numBand, String dataType, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double pixelSize) throws FactoryException {
        return RasterConstructors.makeEmptyRaster(numBand, dataType, widthInPixel, heightInPixel, upperLeftX, upperLeftY, pixelSize, -pixelSize, 0.0, 0.0, 0);
    }

    public static GridCoverage2D makeEmptyRaster(int numBand, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY, int srid) throws FactoryException {
        return RasterConstructors.makeEmptyRaster(numBand, "d", widthInPixel, heightInPixel, upperLeftX, upperLeftY, scaleX, scaleY, skewX, skewY, srid);
    }

    public static GridCoverage2D makeEmptyRaster(int numBand, String bandDataType, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY, int srid) throws FactoryException {
        Object crs = srid == 0 ? DefaultEngineeringCRS.GENERIC_2D : FunctionsGeoTools.sridToCRS(srid);
        WritableRaster raster = RasterFactory.createBandedRaster((int)RasterUtils.getDataTypeCode(bandDataType), (int)widthInPixel, (int)heightInPixel, (int)numBand, null);
        AffineTransform2D transform = new AffineTransform2D(scaleX, skewY, skewX, scaleY, upperLeftX, upperLeftY);
        GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, widthInPixel, heightInPixel), PixelInCell.CELL_CORNER, (MathTransform)transform, (CoordinateReferenceSystem)crs, null);
        return RasterUtils.create(raster, gridGeometry, null, null);
    }

    public static GridCoverage2D makeNonEmptyRaster(int numBand, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY, int srid, double[][] data, Map<String, List<String>> properties, Double noDataValue, PixelInCell anchor) throws FactoryException {
        Object crs = srid == 0 ? DefaultEngineeringCRS.GENERIC_2D : CRS.decode((String)("EPSG:" + srid), (boolean)true);
        WritableRaster raster = RasterFactory.createBandedRaster((int)5, (int)widthInPixel, (int)heightInPixel, (int)numBand, null);
        for (int i = 0; i < numBand; ++i) {
            raster.setSamples(0, 0, widthInPixel, heightInPixel, i, data[i]);
        }
        AffineTransform2D transform = new AffineTransform2D(scaleX, skewY, skewX, scaleY, upperLeftX, upperLeftY);
        GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, widthInPixel, heightInPixel), anchor, (MathTransform)transform, (CoordinateReferenceSystem)crs, null);
        return RasterUtils.create(raster, gridGeometry, null, noDataValue, properties);
    }

    public static GridCoverage2D makeNonEmptyRaster(int numBands, String bandDataType, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY, int srid, double[][] rasterValues) {
        Object crs = srid == 0 ? DefaultEngineeringCRS.GENERIC_2D : FunctionsGeoTools.sridToCRS(srid);
        WritableRaster raster = RasterFactory.createBandedRaster((int)RasterUtils.getDataTypeCode(bandDataType), (int)widthInPixel, (int)heightInPixel, (int)numBands, null);
        for (int i = 0; i < numBands; ++i) {
            raster.setSamples(0, 0, widthInPixel, heightInPixel, i, rasterValues[i]);
        }
        AffineTransform2D transform = new AffineTransform2D(scaleX, skewY, skewX, scaleY, upperLeftX, upperLeftY);
        GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, widthInPixel, heightInPixel), PixelInCell.CELL_CORNER, (MathTransform)transform, (CoordinateReferenceSystem)crs, null);
        return RasterUtils.create(raster, gridGeometry, null);
    }

    public static GridCoverage2D makeNonEmptyRaster(GridCoverage2D ref, String bandDataType, double[] values) {
        CoordinateReferenceSystem crs = ref.getCoordinateReferenceSystem();
        int widthInPixel = ref.getRenderedImage().getWidth();
        int heightInPixel = ref.getRenderedImage().getHeight();
        int valuesPerBand = widthInPixel * heightInPixel;
        if (values.length == 0) {
            throw new IllegalArgumentException("The size of values should be greater than 0");
        }
        if (values.length % valuesPerBand != 0) {
            throw new IllegalArgumentException("The size of values should be multiple of width * height of the reference raster");
        }
        int numBands = values.length / valuesPerBand;
        WritableRaster raster = RasterFactory.createBandedRaster((int)RasterUtils.getDataTypeCode(bandDataType), (int)widthInPixel, (int)heightInPixel, (int)numBands, null);
        for (int i = 0; i < numBands; ++i) {
            double[] bandValues = Arrays.copyOfRange(values, i * valuesPerBand, (i + 1) * valuesPerBand);
            raster.setSamples(0, 0, widthInPixel, heightInPixel, i, bandValues);
        }
        MathTransform transform = ref.getGridGeometry().getGridToCRS(PixelInCell.CELL_CENTER);
        GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, widthInPixel, heightInPixel), PixelInCell.CELL_CENTER, transform, crs, null);
        return RasterUtils.create(raster, gridGeometry, null);
    }

    public static Tile[] generateTiles(GridCoverage2D gridCoverage2D, int[] bandIndices, int tileWidth, int tileHeight, boolean padWithNoData, double padNoDataValue) {
        int numBands = gridCoverage2D.getNumSampleDimensions();
        if (bandIndices == null || bandIndices.length == 0) {
            bandIndices = new int[numBands];
            for (int i = 0; i < numBands; ++i) {
                bandIndices[i] = i + 1;
            }
        } else {
            for (int bandIndex : bandIndices) {
                if (bandIndex > 0 && bandIndex <= numBands) continue;
                throw new IllegalArgumentException(String.format("Provided band index %d is not present in the raster", bandIndex));
            }
        }
        return RasterConstructors.doGenerateTiles(gridCoverage2D, bandIndices, tileWidth, tileHeight, padWithNoData, padNoDataValue);
    }

    private static Tile[] doGenerateTiles(GridCoverage2D gridCoverage2D, int[] bandIndices, int tileWidth, int tileHeight, boolean padWithNoData, double padNoDataValue) {
        AffineTransform2D affine = RasterUtils.getAffineTransform(gridCoverage2D, PixelOrientation.CENTER);
        RenderedImage image = gridCoverage2D.getRenderedImage();
        double[] noDataValues = new double[bandIndices.length];
        for (int i = 0; i < bandIndices.length; ++i) {
            noDataValues[i] = RasterUtils.getNoDataValue(gridCoverage2D.getSampleDimension(bandIndices[i] - 1));
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int numTileX = (int)Math.ceil((double)width / (double)tileWidth);
        int numTileY = (int)Math.ceil((double)height / (double)tileHeight);
        Tile[] tiles = new Tile[numTileX * numTileY];
        for (int tileY = 0; tileY < numTileY; ++tileY) {
            for (int tileX = 0; tileX < numTileX; ++tileX) {
                int x0 = tileX * tileWidth;
                int y0 = tileY * tileHeight;
                int rectWidth = Math.min(tileWidth, width - x0);
                int rectHeight = Math.min(tileHeight, height - y0);
                int currentTileWidth = padWithNoData ? tileWidth : rectWidth;
                int currentTileHeight = padWithNoData ? tileHeight : rectHeight;
                boolean needPadding = padWithNoData && (rectWidth < tileWidth || rectHeight < tileHeight);
                AffineTransform2D tileAffine = RasterUtils.translateAffineTransform(affine, x0, y0);
                GridGeometry2D gridGeometry2D = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, currentTileWidth, currentTileHeight), PixelInCell.CELL_CENTER, (MathTransform)tileAffine, gridCoverage2D.getCoordinateReferenceSystem(), null);
                WritableRaster raster = RasterFactory.createBandedRaster((int)image.getSampleModel().getDataType(), (int)currentTileWidth, (int)currentTileHeight, (int)bandIndices.length, null);
                GridSampleDimension[] sampleDimensions = new GridSampleDimension[bandIndices.length];
                Raster sourceRaster = image.getData(new Rectangle(x0, y0, rectWidth, rectHeight));
                for (int k = 0; k < bandIndices.length; ++k) {
                    int bandIndex = bandIndices[k] - 1;
                    GridSampleDimension sampleDimension = gridCoverage2D.getSampleDimension(bandIndex);
                    double noDataValue = noDataValues[k];
                    if (needPadding && !Double.isNaN(padNoDataValue)) {
                        sampleDimension = RasterUtils.createSampleDimensionWithNoDataValue(sampleDimension, padNoDataValue);
                        noDataValue = padNoDataValue;
                    }
                    sampleDimensions[k] = sampleDimension;
                    ImageUtils.copyRasterWithPadding(sourceRaster, bandIndex, raster, k, noDataValue);
                }
                GridCoverage2D tile = RasterUtils.create(raster, gridGeometry2D, sampleDimensions);
                tiles[tileY * numTileX + tileX] = new Tile(tileX, tileY, tile);
            }
        }
        return tiles;
    }

    public static GridCoverage2D[] rsTile(GridCoverage2D gridCoverage2D, int[] bandIndices, int tileWidth, int tileHeight, boolean padWithNoData, Double padNoDataValue) {
        if (gridCoverage2D == null) {
            return null;
        }
        if (padNoDataValue == null) {
            padNoDataValue = Double.NaN;
        }
        Tile[] tiles = RasterConstructors.generateTiles(gridCoverage2D, bandIndices, tileWidth, tileHeight, padWithNoData, padNoDataValue);
        GridCoverage2D[] result = new GridCoverage2D[tiles.length];
        for (int i = 0; i < tiles.length; ++i) {
            result[i] = tiles[i].getCoverage();
        }
        return result;
    }

    public static GridCoverage2D[] rsTile(GridCoverage2D gridCoverage2D, int[] bandIndices, int tileWidth, int tileHeight, boolean padWithNoData) {
        return RasterConstructors.rsTile(gridCoverage2D, bandIndices, tileWidth, tileHeight, padWithNoData, Double.NaN);
    }

    public static GridCoverage2D[] rsTile(GridCoverage2D gridCoverage2D, int[] bandIndices, int tileWidth, int tileHeight) {
        return RasterConstructors.rsTile(gridCoverage2D, bandIndices, tileWidth, tileHeight, false);
    }

    public static GridCoverage2D[] rsTile(GridCoverage2D gridCoverage2D, int tileWidth, int tileHeight) {
        return RasterConstructors.rsTile(gridCoverage2D, null, tileWidth, tileHeight);
    }

    public static class Tile {
        private final int tileX;
        private final int tileY;
        private final GridCoverage2D coverage;

        public Tile(int tileX, int tileY, GridCoverage2D coverage) {
            this.tileX = tileX;
            this.tileY = tileY;
            this.coverage = coverage;
        }

        public int getTileX() {
            return this.tileX;
        }

        public int getTileY() {
            return this.tileY;
        }

        public GridCoverage2D getCoverage() {
            return this.coverage;
        }
    }
}

