/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v8;

import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.util.Refs;
import ch.ethz.globis.phtree.v8.Node;
import ch.ethz.globis.phtree.v8.NodeIteratorFullNoGC;
import ch.ethz.globis.phtree.v8.PhTree8;
import java.util.NoSuchElementException;

public final class PhIteratorFullNoGC<T>
implements PhTree.PhExtent<T> {
    public static int STAT_NODES_CHECKED = 0;
    public static int STAT_NODES_IGNORED = 0;
    public static int STAT_NODES_PREFIX_FAILED = 0;
    public static int STAT_NODES_EARLY_IRE_CHECK = 0;
    public static int STAT_NODES_EARLY_IRE_ABORT_I = 0;
    public static int STAT_NODES_EARLY_IRE_ABORT_E = 0;
    public static long MBB_TIME = 0L;
    private final int DIM;
    private final PhIteratorStack stack;
    private final long[] valTemplate;
    private PhFilter checker;
    private final PhTree8<T> pht;
    private PhEntry<T> result;
    boolean isFinished = false;

    public PhIteratorFullNoGC(PhTree8<T> pht, PhFilter checker) {
        this.DIM = pht.getDim();
        this.checker = checker;
        this.stack = new PhIteratorStack();
        this.valTemplate = new long[this.DIM];
        this.pht = pht;
    }

    @Override
    public PhIteratorFullNoGC<T> reset() {
        this.stack.size = 0;
        this.isFinished = false;
        if (this.pht.getRoot() == null) {
            this.isFinished = true;
            return this;
        }
        if (this.stack.prepare(this.pht.getRoot())) {
            this.findNextElement();
        } else {
            this.isFinished = true;
        }
        return this;
    }

    private void findNextElement() {
        block0: while (!this.stack.isEmpty()) {
            NodeIteratorFullNoGC p = this.stack.peek();
            while (p.increment()) {
                if (p.isNextSub()) {
                    PhTreeHelper.applyHcPos(p.getCurrentPos(), p.node().getPostLen(), this.valTemplate);
                    if (!this.stack.prepare(p.getCurrentSubNode())) continue;
                    continue block0;
                }
                this.result = p.getCurrentPost();
                return;
            }
            this.stack.pop();
        }
        this.isFinished = true;
    }

    @Override
    public long[] nextKey() {
        long[] key = ((PhEntry)this.nextEntryReuse()).getKey();
        long[] ret = new long[key.length];
        if (this.DIM > 10) {
            System.arraycopy(key, 0, ret, 0, key.length);
        } else {
            for (int i = 0; i < key.length; ++i) {
                ret[i] = key[i];
            }
        }
        return ret;
    }

    @Override
    public T nextValue() {
        return ((PhEntry)this.nextEntryReuse()).getValue();
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    public PhEntry<T> nextEntry() {
        return new PhEntry(this.nextEntryReuse());
    }

    @Override
    public T next() {
        return ((PhEntry)this.nextEntryReuse()).getValue();
    }

    @Override
    public PhEntry<T> nextEntryReuse() {
        if (this.isFinished) {
            throw new NoSuchElementException();
        }
        PhEntry<T> ret = this.result;
        this.findNextElement();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private class PhIteratorStack {
        private final NodeIteratorFullNoGC<T>[] stack = Refs.newArray(NodeIteratorFullNoGC.class, 64);
        private int size = 0;

        public boolean isEmpty() {
            return this.size == 0;
        }

        public boolean prepare(Node<T> node) {
            node.getInfix(PhIteratorFullNoGC.this.valTemplate);
            NodeIteratorFullNoGC ni = this.stack[this.size++];
            if (ni == null) {
                ni = new NodeIteratorFullNoGC(PhIteratorFullNoGC.this.DIM, PhIteratorFullNoGC.this.valTemplate);
                this.stack[this.size - 1] = ni;
            }
            ni.init(node, PhIteratorFullNoGC.this.checker);
            return true;
        }

        public NodeIteratorFullNoGC<T> peek() {
            return this.stack[this.size - 1];
        }

        public NodeIteratorFullNoGC<T> pop() {
            return this.stack[--this.size];
        }
    }
}

