/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.util.BitTools;

public class PhDistanceMMF
implements PhDistance {
    public static final PhDistanceMMF THIS = new PhDistanceMMF();

    @Override
    public double dist(long[] v1, long[] v2) {
        double d = 0.0;
        for (int i = 0; i < v1.length - 1; ++i) {
            double dl = BitTools.toDouble(v1[i]) - BitTools.toDouble(v2[i]);
            d += dl * dl;
        }
        return Math.sqrt(d);
    }

    @Override
    public void toMBB(double distance, long[] center, long[] outMin, long[] outMax) {
        for (int i = 0; i < center.length - 1; ++i) {
            double c = BitTools.toDouble(center[i]);
            outMin[i] = BitTools.toSortableLong(c - distance);
            outMax[i] = BitTools.toSortableLong(c + distance);
        }
        outMin[outMin.length - 1] = Long.MIN_VALUE;
        outMax[outMax.length - 1] = Long.MAX_VALUE;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

