/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.ProfileFeatureCollection;
import ucar.nc2.ft.point.CollectionInfo;
import ucar.nc2.ft.point.CollectionIteratorAdapter;
import ucar.nc2.ft.point.PointCollectionIteratorFiltered;
import ucar.nc2.ft.point.PointFeatureCCImpl;
import ucar.nc2.ft.point.ProfileFeatureImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.IOIterator;
import ucar.unidata.geoloc.LatLonRect;

public class StandardProfileCollectionImpl
extends PointFeatureCCImpl
implements ProfileFeatureCollection {
    private NestedTable ft;
    private ProfileIterator localIterator;

    protected StandardProfileCollectionImpl(String name, CalendarDateUnit timeUnit, String altUnits) {
        super(name, timeUnit, altUnits, FeatureType.PROFILE);
    }

    StandardProfileCollectionImpl(NestedTable ft, CalendarDateUnit timeUnit, String altUnits) {
        super(ft.getName(), timeUnit, altUnits, FeatureType.PROFILE);
        this.ft = ft;
        this.extras = ft.getExtras();
    }

    @Override
    public ProfileFeatureCollection subset(LatLonRect boundingBox) {
        return new StandardProfileCollectionSubset(this, boundingBox);
    }

    @Override
    public ProfileFeatureCollection subset(LatLonRect boundingBox, CalendarDateRange dateRange) {
        return new StandardProfileCollectionSubset(this, boundingBox);
    }

    @Override
    public Iterator<ProfileFeature> iterator() {
        try {
            PointFeatureCollectionIterator pfIterator = this.getPointFeatureCollectionIterator();
            return new CollectionIteratorAdapter<ProfileFeature>(pfIterator);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IOIterator<PointFeatureCollection> getCollectionIterator() throws IOException {
        return new ProfileIterator(this.ft.getRootFeatureDataIterator());
    }

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator() throws IOException {
        return new ProfileIterator(this.ft.getRootFeatureDataIterator());
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public ProfileFeature next() {
        return this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = (ProfileIterator)this.getPointFeatureCollectionIterator();
    }

    private class ProfileIterator
    implements PointFeatureCollectionIterator,
    IOIterator<PointFeatureCollection> {
        StructureDataIterator structIter;
        StructureData nextProfileData;
        StandardProfileFeature prev;
        CollectionInfo calcInfo;

        ProfileIterator(StructureDataIterator structIter) {
            this.structIter = structIter;
            CollectionInfo info = StandardProfileCollectionImpl.this.getInfo();
            if (!info.isComplete()) {
                this.calcInfo = info;
            }
        }

        @Override
        public boolean hasNext() throws IOException {
            do {
                if (this.prev != null && this.calcInfo != null) {
                    this.calcInfo.extend(this.prev.getInfo());
                }
                if (!this.structIter.hasNext()) {
                    this.structIter.close();
                    if (this.calcInfo != null) {
                        this.calcInfo.setComplete();
                    }
                    return false;
                }
                this.nextProfileData = this.structIter.next();
            } while (StandardProfileCollectionImpl.this.ft.isFeatureMissing(this.nextProfileData));
            return true;
        }

        @Override
        public ProfileFeature next() {
            Cursor cursor = new Cursor(StandardProfileCollectionImpl.this.ft.getNumberOfLevels());
            cursor.tableData[1] = this.nextProfileData;
            cursor.recnum[1] = this.structIter.getCurrentRecno();
            cursor.currentIndex = 1;
            StandardProfileCollectionImpl.this.ft.addParentJoin(cursor);
            this.prev = new StandardProfileFeature(cursor, StandardProfileCollectionImpl.this.ft.getObsTime(cursor), this.nextProfileData);
            return this.prev;
        }

        @Override
        public void close() {
            this.structIter.close();
        }
    }

    private static class StandardProfileCollectionSubset
    extends StandardProfileCollectionImpl {
        StandardProfileCollectionImpl from;
        LatLonRect boundingBox;

        StandardProfileCollectionSubset(StandardProfileCollectionImpl from, LatLonRect boundingBox) {
            super(from.getName() + "-subset", from.getTimeUnit(), from.getAltUnits());
            this.from = from;
            this.boundingBox = boundingBox;
        }

        @Override
        public PointFeatureCollectionIterator getPointFeatureCollectionIterator() throws IOException {
            return new PointCollectionIteratorFiltered(this.from.getPointFeatureCollectionIterator(), new Filter());
        }

        private class Filter
        implements PointFeatureCollectionIterator.Filter {
            private Filter() {
            }

            @Override
            public boolean filter(PointFeatureCollection pointFeatureCollection) {
                ProfileFeature profileFeature = (ProfileFeature)pointFeatureCollection;
                return StandardProfileCollectionSubset.this.boundingBox.contains(profileFeature.getLatLon());
            }
        }
    }

    private class StandardProfileFeature
    extends ProfileFeatureImpl {
        Cursor cursor;
        StructureData profileData;

        StandardProfileFeature(Cursor cursor, double time, StructureData profileData) {
            super(StandardProfileCollectionImpl.this.ft.getFeatureName(cursor), StandardProfileCollectionImpl.this.getTimeUnit(), StandardProfileCollectionImpl.this.getAltUnits(), StandardProfileCollectionImpl.this.ft.getLatitude(cursor), StandardProfileCollectionImpl.this.ft.getLongitude(cursor), time, -1);
            this.cursor = cursor;
            this.profileData = profileData;
            if (this.name.equalsIgnoreCase("unknown")) {
                this.name = this.timeUnit.makeCalendarDate(time).toString();
            }
            if (Double.isNaN(time)) {
                try {
                    PointFeatureIterator iter = this.getPointFeatureIterator();
                    if (iter.hasNext()) {
                        PointFeature pf = iter.next();
                        this.time = pf.getObservationTime();
                        if (this.name == null) {
                            this.name = this.timeUnit.makeCalendarDate(this.time).toString();
                        }
                    } else {
                        if (this.name == null) {
                            this.name = "empty";
                        }
                        this.getInfo().nfeatures = 0;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() {
            return this.profileData;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator() throws IOException {
            Cursor cursorIter = this.cursor.copy();
            StructureDataIterator siter = StandardProfileCollectionImpl.this.ft.getLeafFeatureDataIterator(cursorIter);
            return new StandardProfileFeatureIterator(StandardProfileCollectionImpl.this.ft, this.timeUnit, siter, cursorIter);
        }

        @Override
        @Nonnull
        public CalendarDate getTime() {
            return this.timeUnit.makeCalendarDate(this.time);
        }

        private class StandardProfileFeatureIterator
        extends StandardPointFeatureIterator {
            StandardProfileFeatureIterator(NestedTable ft, CalendarDateUnit timeUnit, StructureDataIterator structIter, Cursor cursor) {
                super(StandardProfileFeature.this, ft, timeUnit, structIter, cursor);
            }

            @Override
            protected boolean isMissing() throws IOException {
                if (super.isMissing()) {
                    return true;
                }
                return this.ft.isAltMissing(this.cursor);
            }
        }
    }
}

