/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.joinJudgement.DedupParams;
import org.apache.sedona.core.spatialPartitioning.EqualPartitioning;
import org.apache.sedona.core.spatialPartitioning.SpatialPartitioner;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.Tuple2;

public class FlatGridPartitioner
extends SpatialPartitioner {
    protected final Boolean preserveUncontainedGeometries;

    public FlatGridPartitioner(GridType gridType, List<Envelope> grids, Boolean preserveUncontainedGeometries) {
        super(gridType, grids);
        this.preserveUncontainedGeometries = preserveUncontainedGeometries;
    }

    public FlatGridPartitioner(GridType gridType, List<Envelope> grids) {
        this(gridType, grids, true);
    }

    public FlatGridPartitioner(List<Envelope> grids, Boolean preserveUncontainedGeometries) {
        this(null, grids, preserveUncontainedGeometries);
    }

    public FlatGridPartitioner(List<Envelope> grids) {
        this(null, grids);
    }

    public Iterator<Tuple2<Integer, Geometry>> placeObject(Geometry spatialObject) throws Exception {
        EqualPartitioning partitioning = new EqualPartitioning(this.grids, this.preserveUncontainedGeometries);
        return partitioning.placeObject(spatialObject);
    }

    @Override
    @Nullable
    public DedupParams getDedupParams() {
        return null;
    }

    public int numPartitions() {
        return this.grids.size() + (this.preserveUncontainedGeometries != false ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FlatGridPartitioner)) {
            return false;
        }
        FlatGridPartitioner other = (FlatGridPartitioner)o;
        if (this.gridType == null || other.gridType == null) {
            return other.grids.equals(this.grids);
        }
        return other.gridType.equals(this.gridType) && other.grids.equals(this.grids);
    }
}

