/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.util.Collections;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.helpers.COWArrayList;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;

public class AppenderAttachableImpl
implements AppenderAttachable {
    private final COWArrayList<Appender> appenderList = new COWArrayList<Appender>(new Appender[0]);

    public void addAppender(Appender newAppender) {
        if (newAppender == null) {
            return;
        }
        this.appenderList.addIfAbsent(newAppender);
    }

    public int appendLoopOnAppenders(LoggingEvent event) {
        int size = 0;
        Appender[] appenderArray = this.appenderList.asTypedArray();
        int len = appenderArray.length;
        for (int i = 0; i < len; ++i) {
            appenderArray[i].doAppend(event);
            ++size;
        }
        return size;
    }

    public Enumeration getAllAppenders() {
        if (this.appenderList == null) {
            return null;
        }
        return Collections.enumeration(this.appenderList);
    }

    public Appender getAppender(String name) {
        if (this.appenderList == null || name == null) {
            return null;
        }
        for (Appender appender : this.appenderList) {
            if (!name.equals(appender.getName())) continue;
            return appender;
        }
        return null;
    }

    public boolean isAttached(Appender appender) {
        if (this.appenderList == null || appender == null) {
            return false;
        }
        for (Appender a : this.appenderList) {
            if (a != appender) continue;
            return true;
        }
        return false;
    }

    public void removeAllAppenders() {
        for (Appender a : this.appenderList) {
            a.close();
        }
        this.appenderList.clear();
    }

    public void removeAppender(Appender appender) {
        if (appender == null || this.appenderList == null) {
            return;
        }
        this.appenderList.remove(appender);
    }

    public void removeAppender(String name) {
        if (name == null || this.appenderList == null) {
            return;
        }
        for (Appender a : this.appenderList.asTypedArray()) {
            if (!name.equals(a.getName())) continue;
            this.appenderList.remove(a);
            break;
        }
    }
}

