/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.Webhook;
import com.microsoft.azure.management.containerregistry.WebhookOperations;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerregistry.implementation.RegistryImpl;
import com.microsoft.azure.management.containerregistry.implementation.WebhooksClientImpl;
import rx.Completable;
import rx.Observable;

@LangDefinition
public class WebhookOperationsImpl
implements WebhookOperations {
    private final RegistryImpl containerRegistry;
    private final WebhooksClientImpl webhooksClient;

    WebhookOperationsImpl(RegistryImpl containerRegistry) {
        this.containerRegistry = containerRegistry;
        this.webhooksClient = containerRegistry != null ? new WebhooksClientImpl((ContainerRegistryManager)containerRegistry.manager(), containerRegistry) : null;
    }

    @Override
    public Webhook get(String webhookName) {
        return (Webhook)this.getAsync(webhookName).toBlocking().single();
    }

    @Override
    public Observable<Webhook> getAsync(String webhookName) {
        if (this.containerRegistry == null) {
            return null;
        }
        return this.webhooksClient.getAsync(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), webhookName);
    }

    @Override
    public void delete(String webhookName) {
        if (this.containerRegistry == null) {
            return;
        }
        this.webhooksClient.delete(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), webhookName);
    }

    @Override
    public Completable deleteAsync(String webhookName) {
        if (this.containerRegistry == null) {
            return null;
        }
        return this.webhooksClient.deleteAsync(this.containerRegistry.resourceGroupName(), this.containerRegistry.name(), webhookName);
    }

    @Override
    public PagedList<Webhook> list() {
        if (this.containerRegistry == null) {
            return null;
        }
        return this.webhooksClient.list(this.containerRegistry.resourceGroupName(), this.containerRegistry.name());
    }

    @Override
    public Observable<Webhook> listAsync() {
        if (this.containerRegistry == null) {
            return null;
        }
        return this.webhooksClient.listAsync(this.containerRegistry.resourceGroupName(), this.containerRegistry.name());
    }
}

