/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core;

import tools.jackson.core.util.JacksonFeature;

public enum StreamReadFeature implements JacksonFeature
{
    AUTO_CLOSE_SOURCE(true),
    IGNORE_UNDEFINED(false),
    STRICT_DUPLICATE_DETECTION(false),
    CLEAR_CURRENT_TOKEN_ON_CLOSE(true),
    INCLUDE_SOURCE_IN_LOCATION(false),
    USE_FAST_BIG_NUMBER_PARSER(true),
    USE_FAST_DOUBLE_PARSER(true);

    private final boolean _defaultState;
    private final int _mask = 1 << this.ordinal();

    private StreamReadFeature(boolean defaultState) {
        this._defaultState = defaultState;
    }

    public static int collectDefaults() {
        int flags = 0;
        for (StreamReadFeature f : StreamReadFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    @Override
    public boolean enabledByDefault() {
        return this._defaultState;
    }

    @Override
    public boolean enabledIn(int flags) {
        return (flags & this._mask) != 0;
    }

    @Override
    public int getMask() {
        return this._mask;
    }
}

