/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;

public abstract class CompoundWriter<V>
implements ValueWriter<V> {
    private int _length = -1;
    private final ValueWriter.Registry _registry;

    public CompoundWriter(ValueWriter.Registry registry) {
        this._registry = registry;
    }

    public CompoundWriter(ValueWriter.Registry registry, V object) {
        this._registry = registry;
    }

    @Override
    public final int getEncodedSize() {
        int encodedSize = 1;
        if (this._length == -1) {
            while (this.hasNext()) {
                encodedSize += this._registry.getValueWriter(this.next()).getEncodedSize();
            }
            if (encodedSize > 255) {
                encodedSize += 3;
            }
            this._length = encodedSize;
        } else {
            encodedSize = this._length;
        }
        encodedSize = encodedSize > 255 ? (encodedSize += 5) : (encodedSize += 2);
        return encodedSize;
    }

    @Override
    public final void writeToBuffer(QpidByteBuffer buffer) {
        if (this._length == -1) {
            this.getEncodedSize();
        }
        this.writeToBuffer(buffer, this._length > 255);
    }

    private void writeToBuffer(QpidByteBuffer buffer, boolean large) {
        this.reset();
        int count = this.getCount();
        buffer.put(large ? this.getFourOctetEncodingCode() : this.getSingleOctetEncodingCode());
        if (large) {
            buffer.putInt(this._length);
            buffer.putInt(count);
        } else {
            buffer.put((byte)this._length);
            buffer.put((byte)count);
        }
        while (this.hasNext()) {
            Object val = this.next();
            this._registry.getValueWriter(val).writeToBuffer(buffer);
        }
    }

    protected abstract byte getFourOctetEncodingCode();

    protected abstract byte getSingleOctetEncodingCode();

    public ValueWriter.Registry getRegistry() {
        return this._registry;
    }

    protected abstract int getCount();

    protected abstract boolean hasNext();

    protected abstract Object next();

    protected abstract void reset();
}

