/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.qpid.server.plugin.ConditionallyAvailable;
import org.apache.qpid.server.plugin.ConfiguredObjectTypeFactory;
import org.apache.qpid.server.plugin.Pluggable;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpidServiceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(QpidServiceLoader.class);

    public <C extends Pluggable> Iterable<C> instancesOf(Class<C> clazz) {
        return this.instancesOf(clazz, false);
    }

    public <C extends Pluggable> Iterable<C> atLeastOneInstanceOf(Class<C> clazz) {
        return this.instancesOf(clazz, true);
    }

    public <C extends Pluggable> Map<String, C> getInstancesByType(Class<C> clazz) {
        HashMap<String, Pluggable> instances = new HashMap<String, Pluggable>();
        for (Pluggable instance : this.instancesOf(clazz)) {
            instances.put(instance.getType(), instance);
        }
        return Collections.unmodifiableMap(instances);
    }

    private <C extends Pluggable> Iterable<C> instancesOf(Class<C> clazz, boolean atLeastOne) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator<C> serviceLoaderIterator = ServiceLoader.load(clazz, classLoader).iterator();
        ArrayList<Pluggable> serviceImplementations = new ArrayList<Pluggable>();
        while (serviceLoaderIterator.hasNext()) {
            Pluggable next = (Pluggable)serviceLoaderIterator.next();
            if (this.isDisabled(clazz, next) || !this.isAvailable(next)) continue;
            serviceImplementations.add(next);
        }
        if (atLeastOne && serviceImplementations.isEmpty()) {
            throw new ServerScopedRuntimeException("At least one implementation of " + String.valueOf(clazz) + " expected");
        }
        LOGGER.debug("Found {} implementations of {}", (Object)serviceImplementations.size(), clazz);
        return serviceImplementations;
    }

    private <C extends Pluggable> boolean isAvailable(C next) {
        return !(next instanceof ConditionallyAvailable) || ((ConditionallyAvailable)next).isAvailable();
    }

    private <C extends Pluggable> boolean isDisabled(Class<C> clazz, C next) {
        return Boolean.getBoolean("qpid.plugin.disabled:" + clazz.getSimpleName().toLowerCase() + "." + next.getType()) || next instanceof ConfiguredObjectTypeFactory && this.isDisabledConfiguredType((ConfiguredObjectTypeFactory)next);
    }

    private boolean isDisabledConfiguredType(ConfiguredObjectTypeFactory<?> typeFactory) {
        String simpleName = typeFactory.getCategoryClass().getSimpleName().toLowerCase();
        return Boolean.getBoolean("qpid.type.disabled:" + simpleName + "." + typeFactory.getType());
    }
}

