/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter.selector;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.qpid.server.filter.ArithmeticExpression;
import org.apache.qpid.server.filter.BooleanExpression;
import org.apache.qpid.server.filter.ComparisonExpression;
import org.apache.qpid.server.filter.ConstantExpression;
import org.apache.qpid.server.filter.Expression;
import org.apache.qpid.server.filter.LogicExpression;
import org.apache.qpid.server.filter.PropertyExpression;
import org.apache.qpid.server.filter.PropertyExpressionFactory;
import org.apache.qpid.server.filter.UnaryExpression;
import org.apache.qpid.server.filter.selector.ParseException;
import org.apache.qpid.server.filter.selector.SelectorParserConstants;
import org.apache.qpid.server.filter.selector.SelectorParserTokenManager;
import org.apache.qpid.server.filter.selector.SimpleCharStream;
import org.apache.qpid.server.filter.selector.Token;

public class SelectorParser<E>
implements SelectorParserConstants {
    private PropertyExpressionFactory<E> _factory;
    public SelectorParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private static final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private boolean trace_enabled;

    public SelectorParser() {
        this(new StringReader(""));
    }

    public void setPropertyExpressionFactory(PropertyExpressionFactory<E> factory) {
        this._factory = factory;
    }

    public BooleanExpression<E> parse(String sql) throws ParseException {
        this.ReInit(new StringReader(sql));
        return this.JmsSelector();
    }

    private BooleanExpression<E> asBooleanExpression(Expression<E> value) throws ParseException {
        if (value instanceof BooleanExpression) {
            return (BooleanExpression)value;
        }
        if (value instanceof PropertyExpression) {
            return UnaryExpression.createBooleanCast(value);
        }
        throw new ParseException("Expression will not result in a boolean value: " + String.valueOf(value));
    }

    public final BooleanExpression<E> JmsSelector() throws ParseException {
        Expression<E> left = null;
        left = this.orExpression();
        this.jj_consume_token(0);
        return this.asBooleanExpression(left);
    }

    public final Expression<E> orExpression() throws ParseException {
        Expression<E> left = this.andExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(10);
            Expression<E> right = this.andExpression();
            left = LogicExpression.createOR(this.asBooleanExpression(left), this.asBooleanExpression(right));
        }
        return left;
    }

    public final Expression<E> andExpression() throws ParseException {
        Expression<E> left = this.equalityExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(9);
            Expression<E> right = this.equalityExpression();
            left = LogicExpression.createAND(this.asBooleanExpression(left), this.asBooleanExpression(right));
        }
        return left;
    }

    public final Expression<E> equalityExpression() throws ParseException {
        Expression<E> left;
        block12: {
            left = this.comparisonExpression();
            block9: while (true) {
                Expression<E> right;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: 
                    case 27: 
                    case 28: {
                        break;
                    }
                    default: {
                        break block12;
                    }
                }
                if (this.jj_2_1(2)) {
                    this.jj_consume_token(27);
                    right = this.comparisonExpression();
                    left = ComparisonExpression.createEqual(left, right);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: {
                        this.jj_consume_token(28);
                        right = this.comparisonExpression();
                        left = ComparisonExpression.createNotEqual(left, right);
                        continue block9;
                    }
                }
                if (this.jj_2_2(2)) {
                    this.jj_consume_token(15);
                    this.jj_consume_token(18);
                    left = ComparisonExpression.createIsNull(left);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        this.jj_consume_token(8);
                        this.jj_consume_token(18);
                        left = ComparisonExpression.createIsNotNull(left);
                        continue block9;
                    }
                }
                break;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return left;
    }

    public final Expression<E> comparisonExpression() throws ParseException {
        Expression<E> left;
        block33: {
            left = this.addExpression();
            block27: while (true) {
                ArrayList<String> list;
                Expression<E> high;
                Expression<E> low;
                String t;
                String u;
                Expression<E> right;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: {
                        break;
                    }
                    default: {
                        break block33;
                    }
                }
                if (this.jj_2_3(2)) {
                    this.jj_consume_token(29);
                    right = this.addExpression();
                    left = ComparisonExpression.createGreaterThan(left, right);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 30: {
                        this.jj_consume_token(30);
                        right = this.addExpression();
                        left = ComparisonExpression.createGreaterThanEqual(left, right);
                        continue block27;
                    }
                    case 31: {
                        this.jj_consume_token(31);
                        right = this.addExpression();
                        left = ComparisonExpression.createLessThan(left, right);
                        continue block27;
                    }
                    case 32: {
                        this.jj_consume_token(32);
                        right = this.addExpression();
                        left = ComparisonExpression.createLessThanEqual(left, right);
                        continue block27;
                    }
                    case 12: {
                        u = null;
                        this.jj_consume_token(12);
                        t = this.stringLiteral();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 13: {
                                this.jj_consume_token(13);
                                u = this.stringLiteral();
                                break;
                            }
                        }
                        left = ComparisonExpression.createLike(left, t, u);
                        continue block27;
                    }
                }
                if (this.jj_2_4(2)) {
                    u = null;
                    this.jj_consume_token(8);
                    this.jj_consume_token(12);
                    t = this.stringLiteral();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 13: {
                            this.jj_consume_token(13);
                            u = this.stringLiteral();
                            break;
                        }
                    }
                    left = ComparisonExpression.createNotLike(left, t, u);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        low = this.addExpression();
                        this.jj_consume_token(9);
                        high = this.addExpression();
                        left = ComparisonExpression.createBetween(left, low, high);
                        continue block27;
                    }
                }
                if (this.jj_2_5(2)) {
                    this.jj_consume_token(8);
                    this.jj_consume_token(11);
                    low = this.addExpression();
                    this.jj_consume_token(9);
                    high = this.addExpression();
                    left = ComparisonExpression.createNotBetween(left, low, high);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 14: {
                        this.jj_consume_token(14);
                        this.jj_consume_token(33);
                        t = this.stringLiteral();
                        list = new ArrayList<String>();
                        list.add(t);
                        block28: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 34: {
                                    break;
                                }
                                default: {
                                    break block28;
                                }
                            }
                            this.jj_consume_token(34);
                            t = this.stringLiteral();
                            list.add(t);
                        }
                        this.jj_consume_token(35);
                        left = ComparisonExpression.createInFilter(left, list, false);
                        continue block27;
                    }
                }
                if (!this.jj_2_6(2)) break;
                this.jj_consume_token(8);
                this.jj_consume_token(14);
                this.jj_consume_token(33);
                t = this.stringLiteral();
                list = new ArrayList();
                list.add(t);
                block29: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 34: {
                            break;
                        }
                        default: {
                            break block29;
                        }
                    }
                    this.jj_consume_token(34);
                    t = this.stringLiteral();
                    list.add(t);
                }
                this.jj_consume_token(35);
                left = ComparisonExpression.createNotInFilter(left, list, false);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return left;
    }

    public final Expression<E> addExpression() throws ParseException {
        Expression<E> left = this.multExpr();
        block4: while (this.jj_2_7(Integer.MAX_VALUE)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 36: {
                    this.jj_consume_token(36);
                    Expression<E> right = this.multExpr();
                    left = ArithmeticExpression.createPlus(left, right);
                    continue block4;
                }
                case 37: {
                    this.jj_consume_token(37);
                    Expression<E> right = this.multExpr();
                    left = ArithmeticExpression.createMinus(left, right);
                    continue block4;
                }
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return left;
    }

    public final Expression<E> multExpr() throws ParseException {
        Expression<E> left;
        block9: {
            left = this.unaryExpr();
            block7: while (true) {
                Expression<E> right;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 38: 
                    case 39: 
                    case 40: {
                        break;
                    }
                    default: {
                        break block9;
                    }
                }
                if (this.jj_2_8(2)) {
                    this.jj_consume_token(38);
                    right = this.unaryExpr();
                    left = ArithmeticExpression.createMultiply(left, right);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        this.jj_consume_token(39);
                        right = this.unaryExpr();
                        left = ArithmeticExpression.createDivide(left, right);
                        continue block7;
                    }
                    case 40: {
                        this.jj_consume_token(40);
                        right = this.unaryExpr();
                        left = ArithmeticExpression.createMod(left, right);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return left;
    }

    public final Expression<E> unaryExpr() throws ParseException {
        Object s = null;
        Expression<E> left = null;
        if (this.jj_2_9(Integer.MAX_VALUE)) {
            this.jj_consume_token(36);
            left = this.unaryExpr();
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 37: {
                    this.jj_consume_token(37);
                    left = this.unaryExpr();
                    left = UnaryExpression.createNegate(left);
                    break;
                }
                default: {
                    if (this.jj_2_10(Integer.MAX_VALUE)) {
                        this.jj_consume_token(8);
                        left = this.equalityExpression();
                        left = UnaryExpression.createNOT(this.asBooleanExpression(left));
                        break;
                    }
                    if (this.jj_2_11(Integer.MAX_VALUE)) {
                        this.jj_consume_token(8);
                        left = this.unaryExpr();
                        left = UnaryExpression.createNOT(this.asBooleanExpression(left));
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 33: {
                            left = this.primaryExpr();
                            break block0;
                        }
                    }
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return left;
    }

    public final Expression<E> primaryExpr() throws ParseException {
        Expression<E> left = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                left = this.literal();
                break;
            }
            case 25: 
            case 26: {
                left = this.variable();
                break;
            }
            default: {
                if (this.jj_2_12(2)) {
                    this.jj_consume_token(33);
                    left = this.orExpression();
                    this.jj_consume_token(35);
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return left;
    }

    public final ConstantExpression<E> literal() throws ParseException {
        ConstantExpression left = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 24: {
                String s = this.stringLiteral();
                left = new ConstantExpression(s);
                break;
            }
            case 19: {
                Token t = this.jj_consume_token(19);
                left = ConstantExpression.createFromDecimal(t.image);
                break;
            }
            case 20: {
                Token t = this.jj_consume_token(20);
                left = ConstantExpression.createFromHex(t.image);
                break;
            }
            case 21: {
                Token t = this.jj_consume_token(21);
                left = ConstantExpression.createFromOctal(t.image);
                break;
            }
            case 22: {
                Token t = this.jj_consume_token(22);
                left = ConstantExpression.createFloat(t.image);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                left = ConstantExpression.TRUE;
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                left = ConstantExpression.FALSE;
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                left = ConstantExpression.NULL;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return left;
    }

    public final String stringLiteral() throws ParseException {
        StringBuffer rc = new StringBuffer();
        boolean first = true;
        Token t = this.jj_consume_token(24);
        String image = t.image;
        for (int i = 1; i < image.length() - 1; ++i) {
            char c = image.charAt(i);
            if (c == '\'') {
                ++i;
            }
            rc.append(c);
        }
        return rc.toString();
    }

    public final PropertyExpression<E> variable() throws ParseException {
        StringBuffer rc = new StringBuffer();
        PropertyExpression<E> left = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 25: {
                Token t = this.jj_consume_token(25);
                left = this._factory.createPropertyExpression(t.image);
                break;
            }
            case 26: {
                Token t = this.jj_consume_token(26);
                String image = t.image;
                for (int i = 1; i < image.length() - 1; ++i) {
                    char c = image.charAt(i);
                    if (c == '\"') {
                        ++i;
                    }
                    rc.append(c);
                }
                return this._factory.createPropertyExpression(rc.toString());
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return left;
    }

    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_1();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_2();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_3();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_4();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_5();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_6();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_7();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_8();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_9();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_10();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_11();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_12();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_3R_literal_468_5_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_literal_469_9_47()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_literal_476_9_48()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_literal_483_9_49()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_literal_490_9_50()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_literal_497_9_51()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_literal_504_9_52()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_literal_511_9_53()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_literal_518_9_54()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_comparisonExpression_277_5_9() {
        Token xsp;
        if (this.jj_3R_addExpression_365_5_10()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_comparisonExpression_279_9_26());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_variable_560_5_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_variable_561_9_55()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_variable_566_9_56()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_addExpression_365_5_10() {
        Token xsp;
        if (this.jj_3R_multExpr_391_5_11()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_addExpression_367_13_31());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_12() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_orExpression_203_5_14()) {
            return true;
        }
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_primaryExpr_452_9_30() {
        return this.jj_3R_variable_560_5_39();
    }

    private boolean jj_3R_primaryExpr_450_9_29() {
        return this.jj_3R_literal_468_5_38();
    }

    private boolean jj_3R_equalityExpression_256_9_28() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private boolean jj_3_11() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_unaryExpr_419_9_12();
    }

    private boolean jj_3R_primaryExpr_449_5_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_primaryExpr_450_9_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_primaryExpr_452_9_30()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_12()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_comparisonExpression_345_11_46() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_3R_stringLiteral_537_5_42();
    }

    private boolean jj_3R_comparisonExpression_311_44_44() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_stringLiteral_537_5_42();
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_unaryExpr_437_13_20() {
        return this.jj_3R_primaryExpr_449_5_25();
    }

    private boolean jj_3R_stringLiteral_537_5_42() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3_10() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_equalityExpression_239_5_13();
    }

    private boolean jj_3R_equalityExpression_246_9_27() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_3R_comparisonExpression_277_5_9();
    }

    private boolean jj_3R_unaryExpr_432_13_19() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_unaryExpr_419_9_12();
    }

    private boolean jj_3_6() {
        Token xsp;
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_stringLiteral_537_5_42()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_comparisonExpression_345_11_46());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(35);
    }

    private boolean jj_3_9() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        return this.jj_3R_unaryExpr_419_9_12();
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_3R_comparisonExpression_277_5_9();
    }

    private boolean jj_3R_equalityExpression_241_9_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_1()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_equalityExpression_246_9_27()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_2()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_equalityExpression_256_9_28()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_comparisonExpression_331_11_45() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_3R_stringLiteral_537_5_42();
    }

    private boolean jj_3R_unaryExpr_427_9_18() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_equalityExpression_239_5_13();
    }

    private boolean jj_3R_comparisonExpression_302_38_43() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_stringLiteral_537_5_42();
    }

    private boolean jj_3R_unaryExpr_422_13_17() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_3R_unaryExpr_419_9_12();
    }

    private boolean jj_3R_equalityExpression_239_5_13() {
        Token xsp;
        if (this.jj_3R_comparisonExpression_277_5_9()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_equalityExpression_241_9_21());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_unaryExpr_420_13_16() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        return this.jj_3R_unaryExpr_419_9_12();
    }

    private boolean jj_3R_literal_518_9_54() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_comparisonExpression_326_9_37() {
        Token xsp;
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_stringLiteral_537_5_42()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_comparisonExpression_331_11_45());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_unaryExpr_419_9_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_unaryExpr_420_13_16()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_unaryExpr_422_13_17()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_unaryExpr_427_9_18()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_unaryExpr_432_13_19()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_unaryExpr_437_13_20()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_literal_511_9_53() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_3R_addExpression_365_5_10()) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_addExpression_365_5_10();
    }

    private boolean jj_3R_andExpression_223_9_58() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_equalityExpression_239_5_13();
    }

    private boolean jj_3R_comparisonExpression_316_9_36() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_3R_addExpression_365_5_10()) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_addExpression_365_5_10();
    }

    private boolean jj_3R_literal_504_9_52() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3R_andExpression_221_5_22() {
        Token xsp;
        if (this.jj_3R_equalityExpression_239_5_13()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_andExpression_223_9_58());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_multExpr_403_9_24() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_3R_unaryExpr_419_9_12();
    }

    private boolean jj_3R_literal_497_9_51() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3R_stringLiteral_537_5_42()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_comparisonExpression_311_44_44()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_multExpr_398_9_23() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        return this.jj_3R_unaryExpr_419_9_12();
    }

    private boolean jj_3R_orExpression_205_9_57() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_3R_andExpression_221_5_22();
    }

    private boolean jj_3R_literal_490_9_50() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_comparisonExpression_299_9_35() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3R_stringLiteral_537_5_42()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_comparisonExpression_302_38_43()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_3R_unaryExpr_419_9_12();
    }

    private boolean jj_3R_multExpr_393_9_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_multExpr_398_9_23()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_multExpr_403_9_24()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_comparisonExpression_294_9_34() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        return this.jj_3R_addExpression_365_5_10();
    }

    private boolean jj_3R_orExpression_203_5_14() {
        Token xsp;
        if (this.jj_3R_andExpression_221_5_22()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_orExpression_205_9_57());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_literal_483_9_49() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_multExpr_391_5_11() {
        Token xsp;
        if (this.jj_3R_unaryExpr_419_9_12()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_multExpr_393_9_15());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_comparisonExpression_289_9_33() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_3R_addExpression_365_5_10();
    }

    private boolean jj_3R_addExpression_374_17_41() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_3R_multExpr_391_5_11();
    }

    private boolean jj_3_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(36)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(37)) {
                return true;
            }
        }
        return this.jj_3R_multExpr_391_5_11();
    }

    private boolean jj_3R_literal_476_9_48() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_comparisonExpression_284_9_32() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        return this.jj_3R_addExpression_365_5_10();
    }

    private boolean jj_3R_addExpression_369_17_40() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        return this.jj_3R_multExpr_391_5_11();
    }

    private boolean jj_3R_variable_566_9_56() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_literal_469_9_47() {
        return this.jj_3R_stringLiteral_537_5_42();
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_3R_addExpression_365_5_10();
    }

    private boolean jj_3R_comparisonExpression_279_9_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_comparisonExpression_284_9_32()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_comparisonExpression_289_9_33()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_comparisonExpression_294_9_34()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_comparisonExpression_299_9_35()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_4()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_comparisonExpression_316_9_36()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_5()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_comparisonExpression_326_9_37()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_6()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_variable_561_9_55() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_addExpression_367_13_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_addExpression_369_17_40()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_addExpression_374_17_41()) {
                return true;
            }
        }
        return false;
    }

    public SelectorParser(InputStream stream) {
        this(stream, null);
    }

    public SelectorParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SelectorParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public SelectorParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SelectorParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new SelectorParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public SelectorParser(SelectorParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(SelectorParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

