/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.filter.MessageFilter;

public class FilterManager {
    private final Map<String, MessageFilter> _filters = new ConcurrentHashMap<String, MessageFilter>();

    public void add(String name, MessageFilter filter) {
        this._filters.put(name, filter);
    }

    public boolean allAllow(Filterable msg) {
        for (MessageFilter filter : this._filters.values()) {
            if (filter.matches(msg)) continue;
            return false;
        }
        return true;
    }

    public boolean startAtTail() {
        for (MessageFilter filter : this._filters.values()) {
            if (!filter.startAtTail()) continue;
            return true;
        }
        return false;
    }

    public Iterator<MessageFilter> filters() {
        return this._filters.values().iterator();
    }

    public boolean hasFilters() {
        return !this._filters.isEmpty();
    }

    public boolean hasFilter(String name) {
        return this._filters.containsKey(name);
    }

    public boolean hasFilter(MessageFilter filter) {
        return this._filters.containsValue(filter);
    }

    public String toString() {
        return this._filters.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterManager that = (FilterManager)o;
        return !(this._filters != null ? !this._filters.equals(that._filters) : that._filters != null);
    }

    public int hashCode() {
        return this._filters != null ? this._filters.hashCode() : 0;
    }
}

