/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GenerationClauseNode;
import org.apache.derby.impl.sql.compile.SpecialFunctionNode;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public class ColumnDefinitionNode
extends TableElementNode {
    boolean isAutoincrement;
    DataTypeDescriptor type;
    DataValueDescriptor defaultValue;
    DefaultInfoImpl defaultInfo;
    DefaultNode defaultNode;
    boolean keepCurrentDefault;
    GenerationClauseNode generationClauseNode;
    long autoincrementIncrement;
    long autoincrementStart;
    boolean autoincrementCycle;
    long autoinc_create_or_modify_Start_Increment;
    boolean autoincrementVerify;
    public static final int CREATE_AUTOINCREMENT = 0;
    public static final int MODIFY_AUTOINCREMENT_RESTART_VALUE = 1;
    public static final int MODIFY_AUTOINCREMENT_INC_VALUE = 2;
    public static final int MODIFY_AUTOINCREMENT_ALWAYS_VS_DEFAULT = 3;
    public static final int MODIFY_AUTOINCREMENT_CYCLE_VALUE = 4;

    ColumnDefinitionNode(String string, ValueNode valueNode, DataTypeDescriptor dataTypeDescriptor, long[] lArray, ContextManager contextManager) throws StandardException {
        super(string, contextManager);
        this.type = dataTypeDescriptor;
        if (valueNode instanceof UntypedNullConstantNode) {
            if (dataTypeDescriptor != null) {
                this.defaultValue = ((UntypedNullConstantNode)valueNode).convertDefaultNode(this.type);
            }
        } else if (valueNode instanceof GenerationClauseNode) {
            this.generationClauseNode = (GenerationClauseNode)valueNode;
        } else {
            this.defaultNode = (DefaultNode)valueNode;
            if (lArray != null) {
                long[] lArray2 = lArray;
                this.autoincrementStart = lArray2[0];
                this.autoincrementIncrement = lArray2[1];
                this.autoincrementCycle = lArray2[4] == 1L;
                this.autoinc_create_or_modify_Start_Increment = lArray2[3];
                this.autoincrementVerify = lArray2[2] <= 0L;
                this.isAutoincrement = true;
                if (dataTypeDescriptor != null) {
                    this.setNullability(false);
                }
            }
        }
        this.keepCurrentDefault = valueNode == null;
    }

    @Override
    public String toString() {
        return "";
    }

    String getColumnName() {
        return this.name;
    }

    final DataTypeDescriptor getType() {
        return this.type;
    }

    public void setType(DataTypeDescriptor dataTypeDescriptor) {
        this.type = dataTypeDescriptor;
    }

    final void setNullability(boolean bl) {
        this.type = this.getType().getNullabilityType(bl);
    }

    void setCollationType(int n) {
        this.type = this.getType().getCollatedType(n, 1);
    }

    DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    DefaultInfo getDefaultInfo() {
        return this.defaultInfo;
    }

    public void setDefaultInfo(DefaultInfoImpl defaultInfoImpl) {
        this.defaultInfo = defaultInfoImpl;
    }

    DefaultNode getDefaultNode() {
        return this.defaultNode;
    }

    public boolean hasGenerationClause() {
        return this.generationClauseNode != null;
    }

    GenerationClauseNode getGenerationClauseNode() {
        return this.generationClauseNode;
    }

    boolean isAutoincrementColumn() {
        return this.isAutoincrement;
    }

    long getAutoincrementStart() {
        return this.autoincrementStart;
    }

    long getAutoincrementIncrement() {
        return this.autoincrementIncrement;
    }

    boolean getAutoincrementCycle() {
        return this.autoincrementCycle;
    }

    long getAutoinc_create_or_modify_Start_Increment() {
        return this.autoinc_create_or_modify_Start_Increment;
    }

    void checkUserType(TableDescriptor tableDescriptor) throws StandardException {
        if (this.hasGenerationClause() && this.getType() == null) {
            return;
        }
        if (!this.getType().getTypeId().userType()) {
            return;
        }
        this.setType(this.bindUserType(this.getType()));
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        String string = this.getType().getTypeId().getCorrespondingJavaTypeName();
        boolean bl = false;
        ClassNotFoundException classNotFoundException = null;
        try {
            bl = classInspector.accessible(string);
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
        }
        if (!bl) {
            throw StandardException.newException((String)"42X26", (Throwable)classNotFoundException, (Object[])new Object[]{string, this.name});
        }
        if (!classInspector.assignableTo(string, "java.io.Serializable") && !classInspector.assignableTo(string, "java.sql.SQLData")) {
            this.getCompilerContext().addWarning(StandardException.newWarning((String)"01J04", (Object[])new Object[]{string, this.name}));
        }
    }

    UUID getOldDefaultUUID() {
        return null;
    }

    int getAction() {
        return 0;
    }

    void bindAndValidateDefault(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        if (!(tableDescriptor == null || this.hasGenerationClause() || this.getType().isNullable() || this.defaultNode != null || this.isAutoincrement)) {
            throw StandardException.newException((String)"42601", (Object[])new Object[]{this.getColumnName()});
        }
        if (this.defaultNode == null) {
            return;
        }
        if (this.defaultValue != null) {
            return;
        }
        this.validateDefault(dataDictionary, tableDescriptor);
    }

    void validateAutoincrement(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int n) throws StandardException {
        if (!this.isAutoincrement) {
            return;
        }
        if (n == 3) {
            throw StandardException.newException((String)"42995", (Object[])new Object[0]);
        }
        if (this.autoincrementIncrement == 0L && (this.autoinc_create_or_modify_Start_Increment == 0L || this.autoinc_create_or_modify_Start_Increment == 2L)) {
            throw StandardException.newException((String)"42Z21", (Object[])new Object[]{this.getColumnName()});
        }
        int n2 = this.getType().getTypeId().getJDBCTypeId();
        switch (n2) {
            case -6: {
                this.autoincrementCheckRange(-128L, 127L, "TINYINT");
                break;
            }
            case 5: {
                this.autoincrementCheckRange(-32768L, 32767L, "SMALLINT");
                break;
            }
            case 4: {
                this.autoincrementCheckRange(Integer.MIN_VALUE, Integer.MAX_VALUE, "INTEGER");
                break;
            }
            case -5: {
                this.autoincrementCheckRange(Long.MIN_VALUE, Long.MAX_VALUE, "BIGINT");
                break;
            }
            default: {
                throw StandardException.newException((String)"42Z22", (Object[])new Object[]{this.getColumnName()});
            }
        }
    }

    private void autoincrementCheckRange(long l, long l2, String string) throws StandardException {
        if (l > this.autoincrementIncrement || l2 < this.autoincrementIncrement) {
            throw StandardException.newException((String)"22003", (Object[])new Object[]{string});
        }
        if (l > this.autoincrementStart || l2 < this.autoincrementStart) {
            throw StandardException.newException((String)"22003", (Object[])new Object[]{string});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateDefault(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        if (this.defaultNode == null) {
            return;
        }
        if (this.isAutoincrement) {
            this.defaultInfo = ColumnDefinitionNode.createDefaultInfoOfAutoInc();
            return;
        }
        CompilerContext compilerContext = this.getCompilerContext();
        ValueNode valueNode = this.defaultNode.getDefaultTree();
        int n = compilerContext.getReliability();
        try {
            Object var6_6 = null;
            Object var7_7 = null;
            compilerContext.setReliability(1192);
            valueNode = valueNode.bindExpression(new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()), null, null);
            TypeId typeId = this.getType().getTypeId();
            TypeId typeId2 = valueNode.getTypeId();
            if (!this.defaultTypeIsValid(typeId, this.getType(), typeId2, valueNode, this.defaultNode.getDefaultText())) {
                throw StandardException.newException((String)"42894", (Object[])new Object[]{this.name});
            }
            if (!this.getTypeCompiler(typeId).storable(typeId2, this.getClassFactory())) {
                throw StandardException.newException((String)"42821", (Object[])new Object[]{typeId.getSQLTypeName(), typeId2.getSQLTypeName()});
            }
            this.defaultInfo = new DefaultInfoImpl(false, this.defaultNode.getDefaultText(), this.defaultValue);
        }
        finally {
            compilerContext.setReliability(n);
        }
    }

    protected static DefaultInfoImpl createDefaultInfoOfAutoInc() {
        return new DefaultInfoImpl(true, null, null);
    }

    boolean defaultTypeIsValid(TypeId typeId, DataTypeDescriptor dataTypeDescriptor, TypeId typeId2, ValueNode valueNode, String string) throws StandardException {
        int n;
        int n2 = typeId.getTypeFormatId();
        int n3 = n = typeId2 == null ? -1 : typeId2.getTypeFormatId();
        if (!valueNode.isConstantExpression()) {
            boolean bl;
            boolean bl2 = bl = n2 == 5 || n2 == 13 || n2 == 230;
            if (valueNode instanceof SpecialFunctionNode) {
                switch (((SpecialFunctionNode)valueNode).kind) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return bl && dataTypeDescriptor.getMaximumWidth() >= 8;
                    }
                    case 2: {
                        return bl && dataTypeDescriptor.getMaximumWidth() >= 128;
                    }
                }
                return false;
            }
        }
        switch (n2) {
            case 4: {
                return valueNode instanceof BooleanConstantNode;
            }
            case 7: {
                return n == 7;
            }
            case 11: {
                return n == 7 || n == 11;
            }
            case 197: {
                if (n == 197) {
                    DataTypeDescriptor dataTypeDescriptor2 = valueNode.getTypeServices();
                    int n4 = string.length();
                    int n5 = dataTypeDescriptor2.getPrecision();
                    int n6 = dataTypeDescriptor2.getScale();
                    int n7 = 1;
                    while (n7 <= n6 && string.charAt(n4 - n7) == '0') {
                        --n6;
                        --n5;
                    }
                    return n6 <= dataTypeDescriptor.getScale() && n5 - n6 <= dataTypeDescriptor.getPrecision() - dataTypeDescriptor.getScale();
                }
                return n == 11 || n == 7;
            }
            case 5: 
            case 13: 
            case 230: {
                return n == 5;
            }
            case 27: 
            case 29: 
            case 232: {
                return n == 27;
            }
            case 267: {
                return n == n2;
            }
            case 6: 
            case 8: 
            case 10: 
            case 35: 
            case 36: 
            case 40: 
            case 440: 
            case 444: {
                return true;
            }
        }
        return false;
    }

    @Override
    void printSubNodes(int n) {
    }
}

