/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.store.bdb;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import org.apache.qpid.server.protocol.v1_0.store.LinkStoreUtils;
import org.apache.qpid.server.protocol.v1_0.store.bdb.LinkValue;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Source;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Target;
import org.apache.qpid.server.store.StoreException;

public class LinkValueEntryBinding
extends TupleBinding<LinkValue> {
    private static final LinkValueEntryBinding INSTANCE = new LinkValueEntryBinding();

    private LinkValueEntryBinding() {
    }

    public LinkValue entryToObject(TupleInput input) {
        byte version = input.readByte();
        Object source = this.read(input);
        if (!(source instanceof Source)) {
            throw new StoreException(String.format("Unexpected object '%s' stored in the store where Source is expected", source.getClass()));
        }
        Object target = this.read(input);
        if (!(target instanceof Target)) {
            throw new StoreException(String.format("Unexpected object '%s' stored in the store where Target is expected", target.getClass()));
        }
        return new LinkValue((Source)source, (Target)target, version);
    }

    public void objectToEntry(LinkValue linkValue, TupleOutput output) {
        output.writeByte((int)linkValue.getVersion());
        this.write(linkValue.getSource(), output);
        this.write(linkValue.getTarget(), output);
    }

    public static LinkValueEntryBinding getInstance() {
        return INSTANCE;
    }

    private Object read(TupleInput input) {
        int size = input.readInt();
        byte[] bytes = new byte[size];
        input.read(bytes);
        return LinkStoreUtils.amqpBytesToObject((byte[])bytes);
    }

    private void write(Object object, TupleOutput output) {
        byte[] bytes = LinkStoreUtils.objectToAmqpBytes((Object)object);
        output.writeInt(bytes.length);
        output.write(bytes);
    }
}

