/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.v0_10.transport.Decoder;
import org.apache.qpid.server.protocol.v0_10.transport.Encoder;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.MethodDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.Option;

public final class SessionFlush
extends Method {
    public static final int TYPE = 524;
    private short packing_flags = 0;

    @Override
    public final int getStructType() {
        return 524;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 2;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public SessionFlush() {
    }

    public SessionFlush(Option ... _options) {
        block9: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case EXPECTED: {
                    this.packing_flags = (short)(this.packing_flags | 0x100);
                    continue block9;
                }
                case CONFIRMED: {
                    this.packing_flags = (short)(this.packing_flags | 0x200);
                    continue block9;
                }
                case COMPLETED: {
                    this.packing_flags = (short)(this.packing_flags | 0x400);
                    continue block9;
                }
                case SYNC: {
                    this.setSync(true);
                    continue block9;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block9;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block9;
                }
                case NONE: {
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + String.valueOf((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.sessionFlush(context, this);
    }

    public final boolean hasExpected() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final SessionFlush clearExpected() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.setDirty(true);
        return this;
    }

    public final boolean getExpected() {
        return this.hasExpected();
    }

    public final SessionFlush setExpected(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x100) : (short)(this.packing_flags & 0xFFFFFEFF);
        this.setDirty(true);
        return this;
    }

    public final SessionFlush expected(boolean value) {
        return this.setExpected(value);
    }

    public final boolean hasConfirmed() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final SessionFlush clearConfirmed() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.setDirty(true);
        return this;
    }

    public final boolean getConfirmed() {
        return this.hasConfirmed();
    }

    public final SessionFlush setConfirmed(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x200) : (short)(this.packing_flags & 0xFFFFFDFF);
        this.setDirty(true);
        return this;
    }

    public final SessionFlush confirmed(boolean value) {
        return this.setConfirmed(value);
    }

    public final boolean hasCompleted() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final SessionFlush clearCompleted() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.setDirty(true);
        return this;
    }

    public final boolean getCompleted() {
        return this.hasCompleted();
    }

    public final SessionFlush setCompleted(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x400) : (short)(this.packing_flags & 0xFFFFFBFF);
        this.setDirty(true);
        return this;
    }

    public final SessionFlush completed(boolean value) {
        return this.setCompleted(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("expected", this.getExpected());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("confirmed", this.getConfirmed());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("completed", this.getCompleted());
        }
        return result;
    }
}

