/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.message.mimecontentconverter.ConversionUtils;
import org.apache.qpid.server.message.mimecontentconverter.MimeContentConverterRegistry;
import org.apache.qpid.server.message.mimecontentconverter.MimeContentToObjectConverter;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_10.transport.MessageProperties;
import org.apache.qpid.server.protocol.v0_10.transport.ReplyTo;
import org.apache.qpid.server.util.GZIPUtils;

@PluggableService
public class MessageConverter_v0_10_to_Internal
implements MessageConverter<MessageTransferMessage, InternalMessage> {
    public Class<MessageTransferMessage> getInputClass() {
        return MessageTransferMessage.class;
    }

    public Class<InternalMessage> getOutputClass() {
        return InternalMessage.class;
    }

    public InternalMessage convert(MessageTransferMessage serverMessage, NamedAddressSpace addressSpace) {
        byte[] uncompressed;
        String mimeType = serverMessage.getMessageHeader().getMimeType();
        byte[] data = new byte[(int)serverMessage.getSize()];
        try (QpidByteBuffer content = serverMessage.getContent();){
            content.get(data);
        }
        String encoding = serverMessage.getMessageHeader().getEncoding();
        if ("gzip".equals(encoding) && (uncompressed = GZIPUtils.uncompressBufferToArray((ByteBuffer)ByteBuffer.wrap(data))) != null) {
            data = uncompressed;
            encoding = null;
        }
        Object body = MessageConverter_v0_10_to_Internal.convertMessageBody(mimeType, data);
        AMQMessageHeader convertedHeader = this.convertHeader(serverMessage, addressSpace, body, encoding);
        return InternalMessage.convert((ServerMessage)serverMessage, (AMQMessageHeader)convertedHeader, (Object)body);
    }

    public void dispose(InternalMessage message) {
    }

    private AMQMessageHeader convertHeader(MessageTransferMessage serverMessage, NamedAddressSpace addressSpace, Object convertedBodyObject, String encoding) {
        String convertedMimeType = this.getInternalConvertedMimeType(serverMessage, convertedBodyObject);
        AMQMessageHeader messageHeader = serverMessage.getMessageHeader();
        HashMap headers = new HashMap();
        messageHeader.getHeaderNames().forEach(headerName -> headers.put(headerName, messageHeader.getHeader(headerName)));
        InternalMessageHeader header = new InternalMessageHeader(headers, messageHeader.getCorrelationId(), messageHeader.getExpiration(), messageHeader.getUserId(), messageHeader.getAppId(), messageHeader.getMessageId(), convertedMimeType, messageHeader.getEncoding(), messageHeader.getPriority(), messageHeader.getTimestamp(), messageHeader.getNotValidBefore(), messageHeader.getType(), messageHeader.getReplyTo(), serverMessage.getArrivalTime());
        MessageProperties messageProps = serverMessage.getHeader().getMessageProperties();
        ReplyTo replyTo = messageProps == null ? null : messageProps.getReplyTo();
        return new DelegatingMessageHeader((AMQMessageHeader)header, replyTo, encoding);
    }

    private String getInternalConvertedMimeType(MessageTransferMessage serverMessage, Object convertedBodyObject) {
        String originalMimeType = serverMessage.getMessageHeader().getMimeType();
        if (originalMimeType != null) {
            if (ConversionUtils.LIST_MESSAGE_CONTENT_TYPES.matcher(originalMimeType).matches() || ConversionUtils.MAP_MESSAGE_CONTENT_TYPES.matcher(originalMimeType).matches()) {
                return null;
            }
            if (ConversionUtils.OBJECT_MESSAGE_CONTENT_TYPES.matcher(originalMimeType).matches()) {
                return "application/x-java-serialized-object";
            }
        }
        return originalMimeType;
    }

    private static Object convertMessageBody(String mimeType, byte[] data) {
        MimeContentToObjectConverter converter = MimeContentConverterRegistry.getMimeContentToObjectConverter((String)mimeType);
        if (data != null && data.length != 0) {
            if (converter != null) {
                return converter.toObject(data);
            }
            if (mimeType != null && ConversionUtils.TEXT_CONTENT_TYPES.matcher(mimeType).matches()) {
                return new String(data, StandardCharsets.UTF_8);
            }
        } else {
            if (mimeType == null) {
                return null;
            }
            if (ConversionUtils.OBJECT_MESSAGE_CONTENT_TYPES.matcher(mimeType).matches()) {
                return new byte[0];
            }
            if (ConversionUtils.TEXT_CONTENT_TYPES.matcher(mimeType).matches()) {
                return "";
            }
            if (ConversionUtils.MAP_MESSAGE_CONTENT_TYPES.matcher(mimeType).matches()) {
                return Collections.emptyMap();
            }
            if (ConversionUtils.LIST_MESSAGE_CONTENT_TYPES.matcher(mimeType).matches()) {
                return Collections.emptyList();
            }
        }
        return data;
    }

    public String getType() {
        return "v0-10 to Internal";
    }

    private static class DelegatingMessageHeader
    implements AMQMessageHeader {
        private final AMQMessageHeader _delegate;
        private final ReplyTo _replyTo;
        private final String _encoding;

        private DelegatingMessageHeader(AMQMessageHeader delegate, ReplyTo replyTo, String encoding) {
            this._delegate = delegate;
            this._replyTo = replyTo;
            this._encoding = encoding;
        }

        public String getCorrelationId() {
            return this._delegate.getCorrelationId();
        }

        public long getExpiration() {
            return this._delegate.getExpiration();
        }

        public String getUserId() {
            return this._delegate.getUserId();
        }

        public String getAppId() {
            return this._delegate.getAppId();
        }

        public String getGroupId() {
            return this._delegate.getGroupId();
        }

        public String getMessageId() {
            return this._delegate.getMessageId();
        }

        public String getMimeType() {
            return this._delegate.getMimeType();
        }

        public String getEncoding() {
            return this._encoding;
        }

        public byte getPriority() {
            return this._delegate.getPriority();
        }

        public long getTimestamp() {
            return this._delegate.getTimestamp();
        }

        public long getNotValidBefore() {
            return this._delegate.getNotValidBefore();
        }

        public String getType() {
            return this._delegate.getType();
        }

        public String getReplyTo() {
            return this._replyTo == null ? null : (this._replyTo.getExchange() == null || this._replyTo.getExchange().equals("") ? this._replyTo.getRoutingKey() : (this._replyTo.getRoutingKey() == null || this._replyTo.getRoutingKey().equals("") ? this._replyTo.getExchange() : this._replyTo.getExchange() + "/" + this._replyTo.getRoutingKey()));
        }

        public Object getHeader(String name) {
            return this._delegate.getHeader(name);
        }

        public boolean containsHeaders(Set<String> names) {
            return this._delegate.containsHeaders(names);
        }

        public boolean containsHeader(String name) {
            return this._delegate.containsHeader(name);
        }

        public Collection<String> getHeaderNames() {
            return this._delegate.getHeaderNames();
        }
    }
}

