/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util;

import java.util.concurrent.atomic.AtomicLong;

public class AtomicLongMax {
    private final AtomicLong value;

    public AtomicLongMax(long initialValue) {
        this.value = new AtomicLong(initialValue);
    }

    public long updateMax(long newMax) {
        long currMax = this.value.get();
        while (newMax > currMax) {
            if (this.value.compareAndSet(currMax, newMax)) {
                return newMax;
            }
            currMax = this.value.get();
        }
        return currMax;
    }

    public long get() {
        return this.value.get();
    }

    public long set(long newValue) {
        return this.value.getAndSet(newValue);
    }
}

