/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.helpers.CyclicBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.logging.logback.LogRecord;

public class RecordEventAppender
extends AppenderBase<ILoggingEvent> {
    private final int _size;
    private final AtomicLong _recordId;
    private CyclicBuffer<LogRecord> _buffer;

    RecordEventAppender(int size) {
        this._size = size;
        this._recordId = new AtomicLong();
    }

    public void start() {
        this._buffer = new CyclicBuffer(this._size);
        super.start();
    }

    public void stop() {
        this._buffer = null;
        super.stop();
    }

    protected void append(ILoggingEvent eventObject) {
        if (this.isStarted()) {
            this._buffer.add((Object)new LogRecord(this._recordId.incrementAndGet(), eventObject));
        }
    }

    public CyclicBuffer<LogRecord> getBuffer() {
        return this._buffer;
    }
}

