/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.upgrade;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Sequence;
import com.sleepycat.je.SequenceConfig;
import com.sleepycat.je.Transaction;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.tuple.ConfiguredObjectBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.MessageMetaDataBinding;
import org.apache.qpid.server.store.berkeleydb.tuple.UUIDTupleBinding;
import org.apache.qpid.server.store.berkeleydb.upgrade.AbstractStoreUpgrade;
import org.apache.qpid.server.store.berkeleydb.upgrade.UpgradeInteractionHandler;

public class UpgradeFrom7To8
extends AbstractStoreUpgrade {
    private static final TypeReference<HashMap<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<HashMap<String, Object>>(){};
    private static final DatabaseEntry MESSAGE_METADATA_SEQ_KEY = new DatabaseEntry("MESSAGE_METADATA_SEQ_KEY".getBytes(StandardCharsets.UTF_8));
    private static final SequenceConfig MESSAGE_METADATA_SEQ_CONFIG = SequenceConfig.DEFAULT.setAllowCreate(true).setWrap(true).setCacheSize(100000);
    private final Map<String, String> _defaultExchanges = new HashMap<String, String>(Map.of("amq.direct", "direct", "amq.topic", "topic", "amq.fanout", "fanout", "amq.match", "headers"));

    /*
     * Exception decompiling
     */
    @Override
    public void performUpgrade(Environment environment, UpgradeInteractionHandler handler, ConfiguredObject<?> parent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void storeVirtualHostHierarchyRecord(Database hierarchyDb, Transaction txn, UUID id, UUID virtualHostId) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        UUIDTupleBinding.getInstance().objectToEntry(virtualHostId, value);
        TupleOutput tupleOutput = new TupleOutput();
        tupleOutput.writeLong(id.getMostSignificantBits());
        tupleOutput.writeLong(id.getLeastSignificantBits());
        tupleOutput.writeString("VirtualHost");
        TupleBinding.outputToEntry((TupleOutput)tupleOutput, (DatabaseEntry)key);
        hierarchyDb.put(txn, key, value);
    }

    private void createMessageMetadataSequence(Database messageMetadataSeqDb, long maximumMessageId) {
        SequenceConfig sequenceConfig = MESSAGE_METADATA_SEQ_CONFIG.setInitialValue(maximumMessageId + 1L);
        Sequence messageMetadataSeq = messageMetadataSeqDb.openSequence(null, MESSAGE_METADATA_SEQ_KEY, sequenceConfig);
        messageMetadataSeq.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getConfigVersion(Database configVersionDb) {
        try (Cursor cursor = null;){
            cursor = configVersionDb.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            if (cursor.getNext(key, value, LockMode.RMW) == OperationStatus.SUCCESS) {
                int n = IntegerBinding.entryToInt((DatabaseEntry)value);
                return n;
            }
            int n = -1;
            return n;
        }
    }

    private void storeConfiguredObjectEntry(Database configuredObjectsDb, Transaction txn, ConfiguredObjectRecord configuredObject) {
        DatabaseEntry key = new DatabaseEntry();
        UUIDTupleBinding uuidBinding = UUIDTupleBinding.getInstance();
        uuidBinding.objectToEntry(configuredObject.getId(), key);
        DatabaseEntry value = new DatabaseEntry();
        ConfiguredObjectBinding configuredObjectBinding = ConfiguredObjectBinding.getInstance();
        configuredObjectBinding.objectToEntry(configuredObject, value);
        OperationStatus status = configuredObjectsDb.put(txn, key, value);
        if (status != OperationStatus.SUCCESS) {
            throw new StoreException("Error writing configured object " + String.valueOf(configuredObject) + " to database: " + String.valueOf(status));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMaximumMessageId(Database messageMetaDataDb) {
        long maximumMessageId = 0L;
        try (Cursor cursor = null;){
            cursor = messageMetaDataDb.openCursor(null, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            MessageMetaDataBinding valueBinding = MessageMetaDataBinding.getInstance();
            while (cursor.getNext(key, value, LockMode.RMW) == OperationStatus.SUCCESS) {
                long messageId = LongBinding.entryToLong((DatabaseEntry)key);
                maximumMessageId = Math.max(messageId, maximumMessageId);
            }
        }
        return maximumMessageId;
    }
}

